<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Jobs_model extends CI_Model
{

  function __construct()
  {
    parent::__construct();
  }

  function getAllJobs()
  {
    $lid = $this->session->userdata('user');

    $db = $this->firebase->getdatabase();
    $jak = array();
    $data = $db->getReference('Jobs')->getSnapshot()->getValue();

    foreach ($data as $l => $c) {
      if ($c['postedBy'] != $lid) {
        array_push($jak, $c);
      }
    }

    return  $jak;
  }

  function getJobsByCategory($catId)
  {
    $lid = $this->session->userdata('user');

    $db = $this->firebase->getdatabase();
    $jak = array();
    $data = $db->getReference('Jobs')->getSnapshot()->getValue();

    foreach ($data as $l => $c) {
      if ($c['postedBy'] != $lid && $c['catID'] == $catId) {
        array_push($jak, $c);
      }
    }

    return  $jak;
  }

  function getJobPostedBy($user)
  {
    $lid = $this->session->userdata('user');

    $db = $this->firebase->getdatabase();
    $jak = array();
    $data = $db->getReference('Jobs')->getSnapshot()->getValue();

    foreach ($data as $l => $c) {
      if ($c['postedBy'] == $lid) {
        array_push($jak, $c);
      }
    }

    return  $jak;
  }

  public function add_job($details)
  {
    $db = $this->firebase->getdatabase();
    $postRef = $db->getReference('Jobs/' . $details["posteAt"])->set($details);
    $postKey = $postRef->getKey();
    return $postKey;
  }

  public function getJobDetails($jobId)
  {
    $db = $this->firebase->getdatabase();
    $data = $db->getReference('Jobs/' . $jobId)->getSnapshot()->getValue();
    return $data;
  }
}
