<!DOCTYPE html>
<html lang="en">

<head>
    <?php include('includes/toplinks.php'); ?>

<style>
    html {
	 box-sizing: border-box;
}
 *, *:before, *:after {
	 box-sizing: inherit;
}
 html, body {
	 width: 100%;
	 height: 100%;
	 margin: 0;
}
 * {
	 font-family: Roboto, sans-serif;
}
 code {
	 font-family: "Roboto Mono", monospace;
}
 :root {
	 --center-size: 300px;
	 --option-size: 70px;
	 --hover-size: 510px;
	 --rot-duration: 250ms;
}
 body {
	 display: grid;
	 align-items: center;
	 justify-items: center;
}
 p.small {
	 font-size: smaller;
	 font-style: italic;
}
 #text {
	 width: 80%;
	 margin-bottom: 20%;
	 font-size: 1.5rem;
}
 #radial-menu {
	 display: grid;
	 align-items: center;
	 justify-items: center;
	 position: fixed;
	 bottom: 0;
	 right: 0;
	 transform: translate(50%,50%);
}
 #radial-menu * {
	 grid-row: 1;
	 grid-column: 1;
}
 #center {
	 width: 300px;
	 height: 300px;
	 border-radius: 50%;
	 background: springgreen;
	 display: grid;
	 align-items: center;
	 justify-items: center;
	 z-index: 2;
}
 #hover-area {
	 width: 300px;
	 height: 300px;
	 border-radius: 50%;
	 background: transparent;
	 position: relative;
}
 #hover-area.hover {
	 width: 510px;
	 height: 510px;
}
 #options {
	 display: grid;
	 align-items: center;
	 justify-items: center;
	 transition: transform 250ms;
	 z-index: 1;
}
 .option {
	 width: 70px;
	 height: 70px;
	 display: grid;
	 align-items: center;
	 justify-items: center;
	 grid-row: 1;
	 grid-column: 1;
	 transition: all 0.5s;
}
 .option-rot {
	 height: 100%;
	 width: 100%;
	 background: crimson;
	 font-size: 1.5rem;
	 color: white;
	 display: grid;
	 align-items: center;
	 justify-items: center;
}
 .option-scale {
	 height: 100%;
	 width: 100%;
	 transition: transform 0.1s;
	 display: grid;
	 align-items: center;
	 justify-items: center;
	 border-radius: 50%;
	 overflow: hidden;
	 cursor: pointer;
}
 .option-scale:hover {
	 transform: scale(1.2);
}
 
</style>

</head>

<body>


<span id="text">
  <p>
    Hover over the circle in the corner to expand, then scroll* to go through the items in the radial menu!
  </p>
  <p class="small">
    *Unfortunately, if you don't have a pointing device, or your pointing device doesn't have a wheel, you won't be able to see the menu scrolling functionality. This is because it uses the <code>wheel</code> event. None of the elements that make up the radial menu are actually scrollable.
  </p>
  <p class="small">
    I've considered using swipe gestures as a wheel-less alternative, but getting swipe speed and direction is something I don't think I have the brainpower to do for now.
  </p>
  <p class="small">
    You'll still be able to open and close the menu by tapping, though; but I don't see how that would be of any use for those without scrollwheels. Sorry!
  </p>
</span>

<div id="radial-menu">
  <div id="hover-area"></div>
  
  <div id="center"></div>
  
  <div id="options">
    <div class="option">
      <div class="option-scale">
        <div class="option-rot">
          <span>01</span>
        </div>
      </div>
    </div>
    <div class="option">
      <div class="option-scale">
        <div class="option-rot">
          <span>02</span>
        </div>
      </div>
    </div>
    <div class="option">
      <div class="option-scale">
        <div class="option-rot">
          <span>03</span>
        </div>
      </div>
    </div>
    <div class="option">
      <div class="option-scale">
        <div class="option-rot">
          <span>04</span>
        </div>
      </div>
    </div>
    <div class="option">
      <div class="option-scale">
        <div class="option-rot">
          <span>05</span>
        </div>
      </div>
    </div>
    <div class="option">
      <div class="option-scale">
        <div class="option-rot">
          <span>06</span>
        </div>
      </div>
    </div>
    <div class="option">
      <div class="option-scale">
        <div class="option-rot">
          <span>07</span>
        </div>
      </div>
    </div>
    <div class="option">
      <div class="option-scale">
        <div class="option-rot">
          <span>08</span>
        </div>
      </div>
    </div>
    <div class="option">
      <div class="option-scale">
        <div class="option-rot">
          <span>09</span>
        </div>
      </div>
    </div>
    <div class="option">
      <div class="option-scale">
        <div class="option-rot">
          <span>10</span>
        </div>
      </div>
    </div>
    <div class="option">
      <div class="option-scale">
        <div class="option-rot">
          <span>11</span>
        </div>
      </div>
    </div>
    <div class="option">
      <div class="option-scale">
        <div class="option-rot">
          <span>12</span>
        </div>
      </div>
    </div>
    <div class="option">
      <div class="option-scale">
        <div class="option-rot">
          <span>13</span>
        </div>
      </div>
    </div>
    <div class="option">
      <div class="option-scale">
        <div class="option-rot">
          <span>14</span>
        </div>
      </div>
    </div>
    <div class="option">
      <div class="option-scale">
        <div class="option-rot">
          <span>15</span>
        </div>
      </div>
    </div>
    <div class="option">
      <div class="option-scale">
        <div class="option-rot">
          <span>16</span>
        </div>
      </div>
    </div>
  </div>
</div>














    <?php include('includes/bottom_links.php'); ?>

    <script>
        let showCount = 4; // adjust this variable to control how many options can be seen on hover
let rotDuration;

if (window.getComputedStyle(document.querySelector(":root")).getPropertyValue("--rot-duration").match("ms"))
  rotDuration = parseFloat(window.getComputedStyle(document.querySelector(":root")).getPropertyValue("--rot-duration"));
else
  rotDuration = parseFloat(window.getComputedStyle(document.querySelector(":root")).getPropertyValue("--rot-duration")) * 1000;

function bringOut() {
  let options = document.querySelectorAll(".option");
  let radius = parseInt(window.getComputedStyle(document.querySelector("#center")).getPropertyValue("width")) / 2 + parseInt(window.getComputedStyle(document.querySelector(".option")).getPropertyValue("width"));
  
  let offset = (0.5 * Math.PI) - Math.acos((parseInt(window.getComputedStyle(document.querySelector(".option")).getPropertyValue("width")) / 2) / radius);
  
  for (let i = 0; i < options.length; i++) {
    let angle = (0.5 * Math.PI - offset) + (0.5 * Math.PI + 2 * offset) * ((i + 1) / (showCount + 1));
    
    options[i].style.transform = `translate(${Math.cos(angle) * radius}px, ${-Math.sin(angle) * radius}px)`;
  }
  
  document.querySelector("#hover-area").classList.add("hover");
}

function bringIn() {
  let options = document.querySelectorAll(".option");
  
  for (let i = 0; i < options.length; i++) {
    options[i].style.removeProperty("transform");
  }
  
  document.querySelector("#hover-area").classList.remove("hover");
}

function scrollMenu(e) {
  let options = document.querySelectorAll(".option");
  let radius = parseInt(window.getComputedStyle(document.querySelector(":root")).getPropertyValue("--center-size")) / 2 + parseInt(window.getComputedStyle(document.querySelector(":root")).getPropertyValue("--option-size"));
  
  let offset = (0.5 * Math.PI) - Math.acos((parseInt(window.getComputedStyle(document.querySelector(":root")).getPropertyValue("--option-size")) / 2) / radius);

  let angle = (0.5 * Math.PI + 2 * offset) * (1 / (showCount + 1));
  let prev = document.querySelector("#options").style.transform.match(/rotate\(([^)]+)\)/) ? parseFloat(document.querySelector("#options").style.transform.match(/rotate\(([^)]+)\)/)[1]) : 0;
  
  function dis(down) {
    let start;
    let toShow = down ? document.querySelectorAll(".option")[parseInt(document.querySelector("#options").dataset.bottom) + 1] : document.querySelectorAll(".option")[parseInt(document.querySelector("#options").dataset.top) - 1];
    let toHide = down ? document.querySelectorAll(".option")[parseInt(document.querySelector("#options").dataset.top)] : document.querySelectorAll(".option")[parseInt(document.querySelector("#options").dataset.bottom)];
    let index = Array.prototype.indexOf.call(document.querySelectorAll(".option"), toHide);
    
    toShow.style.removeProperty("visibility");
    
    function f(t) {
      if (start === undefined) start = t;
      let elapsed = t - start;
      
      if (elapsed >= rotDuration) {
        if (index < parseInt(document.querySelector("#options").dataset.top) || index > parseInt(document.querySelector("#options").dataset.bottom)) 
          toHide.style.visibility = "hidden";
        else toHide.style.removeProperty("visibility");
      } else window.requestAnimationFrame(f);
    }
    
    window.requestAnimationFrame(f);
  }
  
  if (e.deltaY > 0) {
    if (parseInt(document.querySelector("#options").dataset.bottom) < document.querySelectorAll(".option").length - 1) {
      dis(true);
      document.querySelector("#options").style.transform = `rotate(${prev + angle}rad)`;
      document.querySelector("#options").dataset.top = parseInt(document.querySelector("#options").dataset.top) + 1;
      document.querySelector("#options").dataset.bottom = parseInt(document.querySelector("#options").dataset.bottom) + 1;
    }
  } else {
    if (parseInt(document.querySelector("#options").dataset.top) > 0) {
      dis(false);
      document.querySelector("#options").style.transform = `rotate(${prev - angle}rad)`;
      document.querySelector("#options").dataset.top = parseInt(document.querySelector("#options").dataset.top) - 1;
      document.querySelector("#options").dataset.bottom = parseInt(document.querySelector("#options").dataset.bottom) - 1;
    }
  }
}

if (window.matchMedia("(hover: none)").matches) {
  document.querySelector("#hover-area").ontouchend = function() {
    if (document.querySelector("#hover-area").classList.contains("hover")) bringIn();
    else bringOut(showCount);
  };
} else {
  document.querySelector("#hover-area").onmouseenter = bringOut;
  document.querySelector("#hover-area").onmouseleave = bringIn;
  
  document.querySelector("#center").onmouseenter = bringOut;
  document.querySelector("#center").onmouseleave = bringIn;
  
  document.querySelector("#options").onmouseenter = bringOut;
  document.querySelector("#options").onmouseleave = bringIn;
}

function initOptions() {
  document.querySelector("#options").dataset.top = 0;
  document.querySelector("#options").dataset.bottom = showCount - 1;

  let radius = parseInt(window.getComputedStyle(document.querySelector("#center")).getPropertyValue("width")) / 2 + parseInt(window.getComputedStyle(document.querySelector(".option")).getPropertyValue("width"));
  
  let offset = (0.5 * Math.PI) - Math.acos((parseInt(window.getComputedStyle(document.querySelector(".option")).getPropertyValue("width")) / 2) / radius);
  
  for (let i = 0; i < document.querySelectorAll(".option").length; i++) {
    let angle = -(Math.PI + (0.5 * Math.PI - offset) + (0.5 * Math.PI + 2 * offset) * ((i + 1) / (showCount + 1)));
    document.querySelectorAll(".option")[i].querySelector(".option-rot").style.transform = `rotate(${angle}rad)`;
    
    if (i < document.querySelector("#options").dataset.top || i > document.querySelector("#options").dataset.bottom)
      document.querySelectorAll(".option")[i].style.visibility = "hidden";
  }
}

document.querySelector("#radial-menu").onwheel = function(e) {scrollMenu(e)};

window.onload = initOptions;
    </script>


</body>

</html>