<?php

namespace App\Http\Controllers;

use App\Services\GmailService;
use Illuminate\Http\Request;

class EmailController extends Controller
{
    protected $gmailService;

    public function __construct(GmailService $gmailService)
    {
        $this->gmailService = $gmailService;
    }
    

    public function sendRideReceipt($recipientEmail, $receipt, $pdfContent)
    {
        try {
            // Generate HTML body
            $htmlBody = view('receipt', ['receipt' => $receipt])->render();

            // Prepare attachment
            $attachments = [
                [
                    'name' => 'receipt.pdf',
                    'content' => $pdfContent,
                    'mime' => 'application/pdf'
                ]
            ];

            // Send email
            $result = $this->gmailService->sendEmail(
                $recipientEmail,
                'Your Ride Receipt',
                $htmlBody,
                $attachments
            );

            return response()->json([
                'success' => true,
                'message' => 'Email sent successfully',
                'messageId' => $result->getId()
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error sending email: ' . $e->getMessage()
            ], 500);
        }
    }
    
    public function test()
{


    app(GmailService::class)->sendEmail(
        'test@example.com',
        'Test',
        'Hello world'
    );
}

}
