<?php

namespace App\Http\Controllers;

use App\Services\GmailService;
use Illuminate\Http\Request;

class GmailAuthController extends Controller
{
    protected $gmailService;

    public function __construct(GmailService $gmailService)
    {
        $this->gmailService = $gmailService;
    }

    /**
     * Redirect to Google OAuth
     */
    public function redirectToGoogle()
    {



        $authUrl = $this->gmailService->getAuthUrl();
        return redirect()->away($authUrl);
    }



    /**
     * Handle callback from Google
     */
    public function handleGoogleCallback(Request $request)
    {
        $code = $request->get('code');


        if (!$code) {
            return redirect('/')->with('error', 'Authorization code not received');
        }

        try {
            $token = $this->gmailService->authenticate($code);


            // Display tokens to user so they can add to .env
            return view('gmail-success', [
                'access_token' => $token['access_token'],
                'refresh_token' => $token['refresh_token'] ?? null,
            ]);
        } catch (\Exception $e) {
            return redirect('/')->with('error', 'Authentication failed: ' . $e->getMessage());
        }
    }
}
