<?php

namespace App\Http\Controllers;

use App\Services\FirebaseService;
use Illuminate\Http\Request;

class TestFirebaseController extends Controller
{
    protected FirebaseService $firebase;

    public function __construct(FirebaseService $firebase)
    {
        $this->firebase = $firebase;
    }

    public function checkBooking()
    {
        // Your Bookings ID
        $bookingId = '0c090c6a-db14-47f5-8003-6f64c3cc6d94';

        $ride = $this->firebase->getRide($bookingId);

        if (!$ride) {
            return response()->json([
                'success' => false,
                'message' => 'Booking not found',
            ]);
        }

        return response()->json([
            'success' => true,
            'ride' => $ride,
        ]);
    }
}
