<?php

namespace App\Http\Controllers;

use App\Services\FirebaseService;
use App\Services\ReceiptService;

class TestReceiptController extends Controller
{
    protected FirebaseService $firebase;
    protected ReceiptService $receiptService;

    public function __construct(FirebaseService $firebase, ReceiptService $receiptService)
    {
        $this->firebase = $firebase;
        $this->receiptService = $receiptService;
    }

    public function showReceipt()
    {
        // Replace with your Booking ID
        $bookingId = '158a2c7f-ff68-4307-ae82-df86cd7d4ae0';

        // Get ride data from Firebase
        $ride = $this->firebase->getRide($bookingId);

        if (!$ride) {
            return response()->json(['success' => false, 'message' => 'Ride not found']);
        }

        // Normalize ride data for receipt
        $receipt = $this->receiptService->normalize($ride);

        return response()->json([
            'success' => true,
            'receipt' => $receipt,
        ]);
    }
}
