<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class RideReceiptMail extends Mailable
{
    use Queueable, SerializesModels;

    public $receipt;
    public $pdfContent;

    public function __construct(array $receipt, string $pdfContent)
    {
        $this->receipt = $receipt;
        $this->pdfContent = $pdfContent;
    }

    public function build()
    {
        return $this->view('receipt')
            ->subject('Your Ride Receipt')
            ->attachData($this->pdfContent, 'receipt.pdf', [
                'mime' => 'application/pdf',
            ]);
    }
}
