<?php

namespace App\Services;

class MapRouteService
{
    /**
     * Decode a single Google polyline into lat/lng points
     *
     * @param string $encoded
     * @return array
     */
    public function decodePolyline(string $encoded): array
    {
        $points = [];
        $index = 0;
        $len = strlen($encoded);
        $lat = 0;
        $lng = 0;

        while ($index < $len) {
            $result = 0;
            $shift = 0;
            do {
                $b = ord($encoded[$index++]) - 63;
                $result |= ($b & 0x1f) << $shift;
                $shift += 5;
            } while ($b >= 0x20);
            $dlat = (($result & 1) ? ~($result >> 1) : ($result >> 1));
            $lat += $dlat;

            $result = 0;
            $shift = 0;
            do {
                $b = ord($encoded[$index++]) - 63;
                $result |= ($b & 0x1f) << $shift;
                $shift += 5;
            } while ($b >= 0x20);
            $dlng = (($result & 1) ? ~($result >> 1) : ($result >> 1));
            $lng += $dlng;

            $points[] = ['lat' => $lat / 1e5, 'lng' => $lng / 1e5];
        }

        return $points;
    }

    /**
     * Combine all direction segments into a full route
     *
     * @param array $directionsResponse
     * @return array
     */
    public function getFullRoute(array $directionsResponse): array
    {
        $fullRoute = [];
        foreach ($directionsResponse as $segment) {
            if (!empty($segment['polyline'])) {
                $points = $this->decodePolyline($segment['polyline']);
                $fullRoute = array_merge($fullRoute, $points);
            }
        }
        return $fullRoute;
    }
}
