<?php

namespace App\Services;

class StaticMapService
{
    /**
     * Generate a static map image URL with route points using Google Maps API
     *
     * @param array $routePoints
     * @param int $width
     * @param int $height
     * @return string
     */
    public function generateMapImage(array $routePoints, int $width = 620, int $height = 280): string
    {
        if (empty($routePoints)) return '';

        $apiKey = env('GOOGLE_MAPS_API_KEY'); // fetch from .env

        $start = $routePoints[0];
        $end = end($routePoints);

        // Start and end markers
        $markers = "color:green|{$start['lat']},{$start['lng']}";
        $markers .= "&markers=color:red|{$end['lat']},{$end['lng']}";

        // Build route path
        $pathParts = [];
        foreach ($routePoints as $point) {
            $pathParts[] = "{$point['lat']},{$point['lng']}";
        }
        $path = implode('|', $pathParts);

        // Build Google Static Maps URL
        $url = "https://maps.googleapis.com/maps/api/staticmap?";
        $url .= "size={$width}x{$height}";
        $url .= "&{$markers}";
        $url .= "&path={$path}";
        $url .= "&key={$apiKey}";


        // Save image locally (optional)
        // $img = file_get_contents($url);
        // if ($img !== false) {
        //     file_put_contents(public_path('map.png'), $img); // saves in Laravel public folder
        // }

        return $url;
    }
}
