<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Ride Receipt</title>
<style>
@page { size: A4 portrait; margin: 10mm; }

* { margin: 0; padding: 0; box-sizing: border-box; }

body {
    font-family: 'Helvetica', 'Arial', sans-serif;
    font-size: 10pt; /* reduced from 11pt */
    line-height: 1.4; /* tighter spacing */
    color: #222;
    background: white;
}

.receipt-container {
    width: 100%;
    max-width: 190mm; /* slightly narrower to fit A4 */
    margin: 0 auto;
}

/* HEADER */
.header {
    text-align: center;
    margin-bottom: 20px;
    padding-bottom: 10px;
    border-bottom: 2px solid #000;
}
.company-name { font-size: 22pt; font-weight: bold; margin-bottom: 5px; letter-spacing: 1.5px; }
.receipt-title { font-size: 12pt; color: #555; margin-bottom: 4px; font-weight: 600; }
.receipt-date { font-size: 10pt; color: #666; }

/* TRIP ID */
.trip-id-box {
    text-align: center;
    margin: 15px 0;
    padding: 10px;
    background: #f5f5f5;
    border: 1px solid #ccc;
    border-radius: 5px;
}
.trip-id-label { font-size: 8pt; color: #666; font-weight: bold; margin-bottom: 4px; display: block; }
.trip-id-value { font-size: 9pt; font-family: 'Courier New', monospace; color: #333; }

/* MAP SECTION */
/* MAP SECTION */
.map-section {
    margin: 12px 0;
    text-align: center;
}
.map-section img {
    max-width: 100%;       /* scales down to container width */
    max-height: 280px;     /* smaller height for A4 */
    width: auto;
    height: auto;
    border: 1px solid #ddd;
    border-radius: 6px;
    display: block;
    margin: 0 auto;
}


/* SECTIONS */
.section { margin-bottom: 15px; page-break-inside: avoid; }
.section-title {
    font-size: 11pt; font-weight: bold; margin-bottom: 8px;
    color: #000; background: #e8e8e8; padding: 6px 10px;
    border-left: 4px solid #000;
}

/* LOCATION ITEMS */
.location-item { margin-bottom: 12px; padding: 10px 12px; background: #fafafa; border-left: 3px solid #22c55e; border-radius: 3px; }
.location-item.dropoff { border-left-color: #ef4444; }
.location-label { font-size: 8pt; font-weight: bold; color: #666; text-transform: uppercase; margin-bottom: 3px; display: block; }
.location-address { font-size: 9pt; color: #222; line-height: 1.4; }

/* TRIP STATS */
.stats-table { width: 100%; border-collapse: collapse; margin: 10px 0; }
.stats-table td { padding: 10px 5px; text-align: center; border: 1px solid #ddd; background: #f9f9f9; width: 33.33%; }
.stat-label { display: block; font-size: 8pt; color: #666; font-weight: bold; text-transform: uppercase; margin-bottom: 4px; }
.stat-value { display: block; font-size: 12pt; font-weight: bold; color: #000; }

/* TWO COLUMNS */
.two-columns { display: table; width: 100%; border-collapse: collapse; margin-bottom: 15px; }
.column { display: table-cell; width: 50%; padding: 10px; background: #fafafa; border: 1px solid #ddd; vertical-align: top; }
.column:first-child { border-right: none; }
.column-title { font-size: 10pt; font-weight: bold; margin-bottom: 8px; border-bottom: 1px solid #ccc; padding-bottom: 4px; }
.info-item { margin-bottom: 8px; }
.info-label { font-size: 8pt; color: #666; font-weight: bold; margin-bottom: 2px; display: block; }
.info-value { font-size: 9pt; color: #222; display: block; }

/* TOTAL BOX */
.total-box { margin: 20px 0; padding: 15px 20px; background: #f5f5f5; border: 2px solid #000; border-radius: 6px; page-break-inside: avoid; }
.total-row { display: table; width: 100%; margin-bottom: 8px; }
.total-label { display: table-cell; font-size: 14pt; font-weight: bold; color: #000; vertical-align: middle; }
.total-amount { display: table-cell; font-size: 22pt; font-weight: bold; color: #000; text-align: right; vertical-align: middle; }
.payment-line { font-size: 10pt; color: #555; padding-top: 6px; border-top: 1px solid #ccc; margin-top: 6px; }
.payment-line strong { color: #000; text-transform: capitalize; }

/* FOOTER */
.footer { margin-top: 20px; padding-top: 10px; border-top: 1px solid #ccc; text-align: center; font-size: 9pt; color: #666; line-height: 1.5; }
.footer p { margin: 3px 0; }
.footer strong { color: #000; }

</style>
</head>
<body>
<div class="receipt-container">
    <!-- Header -->
    <div class="header">
        <div class="company-name">Kataaru</div>
        <div class="receipt-title">Ride Receipt</div>
        <div class="receipt-date">{{ $receipt['date'] ?? 'N/A' }}</div>
    </div>
    

    
        <!-- Map Section -->
    @if(!empty($receipt['mapImageBase64']))
    <div class="map-section">
        <img src="{{ $receipt['mapImageBase64'] }}" alt="Map">
    </div>
    @endif
    
    <!-- Trip Route -->
    <div class="section">
        <div class="section-title">Trip Route</div>
        <div class="location-item">
            <span class="location-label">Pickup Location</span>
            <span class="location-address">{{ $receipt['pickup'] ?? 'N/A' }}</span>
        </div>
        <div class="location-item dropoff">
            <span class="location-label">Dropoff Location</span>
            <span class="location-address">{{ $receipt['destination'] ?? 'N/A' }}</span>
        </div>
    </div>
    
    <!-- Trip Stats -->
    <div class="section">
        <div class="section-title">Trip Details</div>
        <table class="stats-table">
            <tr>
                <td>
                    <span class="stat-label">Distance</span>
                    <span class="stat-value">{{ $receipt['distance'] ?? 'N/A' }}</span>
                </td>
                <td>
                    <span class="stat-label">Duration</span>
                    <span class="stat-value">{{ $receipt['time'] ?? 'N/A' }}</span>
                </td>
                <td>
                    <span class="stat-label">Vehicle</span>
                    <span class="stat-value" style="font-size:11pt;">{{ $receipt['vehicleType'] ?? 'N/A' }}</span>
                </td>
            </tr>
        </table>
    </div>
    
    <!-- Passenger & Driver -->
    <div class="section">
        <div class="section-title">Ride Information</div>
        <div class="two-columns">
            <div class="column">
                <div class="column-title">Passenger</div>
                <div class="info-item">
                    <span class="info-label">Name</span>
                    <span class="info-value">{{ $receipt['customerName'] ?? 'N/A' }}</span>
                </div>
                <div class="info-item">
                    <span class="info-label">Email</span>
                    <span class="info-value">{{ $receipt['customerEmail'] ?? 'N/A' }}</span>
                </div>
            </div>
            <div class="column">
                <div class="column-title">Driver</div>
                <div class="info-item">
                    <span class="info-label">Name</span>
                    <span class="info-value">{{ $receipt['driverName'] ?? 'N/A' }}</span>
                </div>
                <div class="info-item">
                    <span class="info-label">Vehicle</span>
                    <span class="info-value">
                        @if(isset($receipt['vehicleMake']) && $receipt['vehicleMake'] != 'N/A')
                            {{ $receipt['vehicleMake'] }} {{ $receipt['vehicleModel'] ?? '' }}
                        @else
                            N/A
                        @endif
                    </span>
                </div>
                @if(isset($receipt['vehicleTagNumber']) && $receipt['vehicleTagNumber'] != 'N/A')
                <div class="info-item">
                    <span class="info-label">License Plate</span>
                    <span class="info-value">{{ $receipt['vehicleTagNumber'] }}</span>
                </div>
                @endif
            </div>
        </div>
    </div>
    
    <!-- Total -->
    <div class="total-box">
        <div class="total-row">
            <span class="total-label">TOTAL FARE</span>
            <span class="total-amount">{{ $receipt['amount'] ?? '$0.00' }}</span>
        </div>
        <div class="payment-line">
            Payment Method: <strong>{{ $receipt['paymentType'] ?? 'N/A' }}</strong>
        </div>
    </div>
    
    <!-- Footer -->
    <div class="footer">
        <p><strong>Thank you for riding with us!</strong></p>
        <p>Questions or concerns? Please contact our support team.</p>
    </div>
</div>
</body>
</html>
