<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\GeneratePdfController;
use App\Http\Controllers\TestReceiptController;
use App\Http\Controllers\TestFirebaseController;
use App\Services\GmailService;
use App\Http\Controllers\GmailAuthController;
use App\Http\Controllers\EmailController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});
//test routes
Route::get('/test-booking', [TestFirebaseController::class, 'checkBooking']);
Route::get('/test-receipt', [TestReceiptController::class, 'showReceipt']);
// Route::get('/generate-receipt/{rideId}', [GeneratePdfController::class, 'generateReceiptPdf']);
Route::get('/generate-receipt/{rideId}', [GeneratePdfController::class, 'generateAndEmailReceipt']);
Route::get('/email/test',  [EmailController::class, 'test']);


Route::get('/gmail/auth', [GmailAuthController::class, 'redirectToGoogle']);
Route::get('/gmail/callback', [GmailAuthController::class, 'handleGoogleCallback']);

