<?php
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';
class Api extends REST_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->model('api_model');
        $this->load->model('geofence_model');
        $this->load->model('email_model');
    }
    public function index_get()
    {
        //$this->checkgeofence('8','22.275334996986643','70.88614147123701');
    }

    public function index_post()   //Get GPS feed in device
    {
        $id = isset($_REQUEST['id']) ? $_REQUEST['id'] : '';
        $checklogin = $this->api_model->checkgps_auth($id);


        if ($checklogin) {
            echo $v_id = $checklogin[0]['v_id'];
            $lat = isset($_REQUEST["lat"]) ? $_REQUEST["lat"] : NULL;
            $lon = isset($_REQUEST["lon"]) ? $_REQUEST["lon"] : NULL;
            $timestamp = isset($_REQUEST["timestamp"]) ? $_REQUEST["timestamp"] : NULL;
            $altitude = isset($_REQUEST["altitude"]) ? $_REQUEST["altitude"] : NULL;
            $speed = isset($_REQUEST["speed"]) ? $_REQUEST["speed"] : NULL;
            $bearing = isset($_REQUEST["bearing"]) ? $_REQUEST["bearing"] : NULL;
            $accuracy = isset($_REQUEST["accuracy"]) ? $_REQUEST["accuracy"] : NULL;
            $comment = isset($_REQUEST["comment"]) ? $_REQUEST["comment"] : NULL;
            $postarray = array('v_id' => $v_id, 'latitude' => $lat, 'longitude' => $lon, 'time' => date('Y-m-d h:i:s'), 'altitude' => $altitude, 'speed' => $speed, 'bearing' => $bearing, 'accuracy' => $accuracy, 'comment' => $comment);
            $this->api_model->add_postion($postarray);
            $this->checkgeofence($v_id, $lat, $lon);
            $response = array('error' => false, 'message' => ['v_id' => $v_id]);
            $this->set_response($response);
        }
    }
    public function positions_post()     //Postion feed to front end   
    {
        $this->db->select("*");
        $this->db->from('positions');
        $this->db->where('v_id', $this->post('t_vechicle'));
        $this->db->where('date(time) >=', $this->post('fromdate'));
        $this->db->where('date(time) <=', $this->post('todate'));
        $query = $this->db->get();
        $data = $query->result_array();
        $distancefrom = reset($data);
        $distanceto = end($data);
        $totaldist = $this->totaldistance($distancefrom, $distanceto);
        $returndata = array('status' => 1, 'data' => $data, 'totaldist' => $totaldist, 'message' => 'data');
        $this->set_response($returndata);
    }

    public function totaldistance($distancefrom, $distanceto, $earthRadius = 6371000)
    {
        $latFrom = deg2rad($distancefrom['latitude']);
        $lonFrom = deg2rad($distancefrom['longitude']);
        $latTo = deg2rad($distanceto['latitude']);
        $lonTo = deg2rad($distanceto['longitude']);
        $latDelta = $latTo - $latFrom;
        $lonDelta = $lonTo - $lonFrom;
        $angle = 2 * asin(sqrt(pow(sin($latDelta / 2), 2) + cos($latFrom) * cos($latTo) * pow(sin($lonDelta / 2), 2)));
        return $angle * $earthRadius;
    }
    public function currentpositions_get()
    {
        $data = array();
        $postions = array();
        $this->db->select("p.*,v.v_name,v.v_type,v.v_color");
        $this->db->from('positions p');
        $this->db->join('vehicles v', 'v.v_id = p.v_id');
        $this->db->where('v.v_is_active', 1);

        if (isset($_GET['uname'])) {
            $this->db->where('v.v_api_username', $_GET['uname']);
        }

        if (isset($_GET['gr'])) {
            $this->db->where('v.v_group', $_GET['gr']);
        }

        if (isset($_GET['v_id'])) {
            $this->db->where('v.v_id', $_GET['v_id']);
        }

        $this->db->where('`id` IN (SELECT MAX(id) FROM positions GROUP BY `v_id`)', NULL, FALSE);
        $query = $this->db->get();
        $data = $query->result_array();
        if (count($data) >= 1) {
            $resp = array('status' => 1, 'data' => $data);
        } else {
            $resp = array('status' => 0, 'message' => 'No live GPS feed found');
        }
        $this->set_response($resp);
    }
    public function checkgeofence($vid, $lat, $log)
    {
        $vgeofence = $this->geofence_model->getvechicle_geofence($vid);
        if (!empty($vgeofence)) {
            $points = array("$lat $log");
            foreach ($vgeofence as $geofencedata) {
                $lastgeo = explode(" ,", $geofencedata['geo_area']);
                $polygon = $geofencedata['geo_area'] . $lastgeo[0];
                $polygondata = explode(' , ', $polygon);
                foreach ($polygondata as $polygoncln) {
                    $geopolygondata[] = str_replace(",", ' ', $polygoncln);
                }
                foreach ($points as $key => $point) {
                    $geocheck = pointInPolygon($point, $geopolygondata, false);
                    if ($geocheck == 'outside' || $geocheck == 'boundary' || $geocheck == 'inside') {
                        $wharray = array(
                            'ge_v_id' => $vid, 'ge_geo_id' => $geofencedata['geo_id'], 'ge_event' => $geocheck,
                            'DATE(ge_timestamp)' => date('Y-m-d')
                        );
                        $geofence_events = $this->db->select('*')->from('geofence_events')->where($wharray)->get()->result_array();

                        if (count($geofence_events) == 0) {
                            $insertarray = array('ge_v_id' => $vid, 'ge_geo_id' => $geofencedata['geo_id'], 'ge_event' => $geocheck, 'ge_timestamp' =>
                            date('Y-m-d h:i:s'));
                            $this->db->insert('geofence_events', $insertarray);
                        }
                    }
                }
            }
        }
    }
    public function sendEmailToAdmin()
    {
        $email = $this->input->post('from');
        $body = $this->input->post('body');
        $subject = $this->input->post('subject');
        $this->email_model->sendemail($email, $subject, $body);
    }
}
