<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Contest extends CI_Controller
{

  function __construct()
  {
    parent::__construct();
    // $this->load->database();
    $this->load->model('common');
    $this->load->helper(array('form', 'url', 'string'));
    $this->load->library('form_validation');
    $this->load->library('session');
  }

  public function index($id = "")
  {
    if ($id == "") {
      $data['contests'] = $this->common->readdatafromcollectionwhereclause("Contest");
    } else {
      $data['contests'] = $this->common->readdatafromcollectionwhereclause("Contest", "userId", "=", $id);
    }

    $data['users'] = $this->common->readdatafromcollectionwhereclause("Users", "userRole", "=", "user");
    $this->template->template_render('contest_management', $data);
  }

  public function addcontest()
  {
    $this->template->template_render('contest_add');
  }

  public function insertcontest()
  {
    if (isset($_POST)) {
      $data = $_POST;
      $data['startDate'] = strtotime($data['startDate']) * 1000;
      $data['endDate'] = strtotime($data['endDate']) * 1000;
      $firebase = $this->firebase->init();
      $storage = $firebase->createStorage();
      $defaultBucket = $storage->getBucket();

      if ($_FILES['authenticityProof']['tmp_name'] != '') {
        $uploadedFile = $defaultBucket->upload(
          file_get_contents($_FILES['authenticityProof']['tmp_name']),
          [
            'name' => "authenticity" . rand() . time() . $_FILES['authenticityProof']['name'],
          ]
        );

        $data['authenticityProof'] = $uploadedFile->info()['mediaLink'];
      }

      $total = count($_FILES['shoePhoto']['name']);
      for ($i = 0; $i < $total; $i++) {
        $uploadedFile = $defaultBucket->upload(
          file_get_contents($_FILES['shoePhoto']['tmp_name'][$i]),
          [
            'name' => "shoePhoto" . rand() . time() . $_FILES['shoePhoto']['name'][$i],
          ]
        );
        $data['shoePhoto'][$i] = $uploadedFile->info()['mediaLink'];
      }

      $contestId = time();
      $response = $this->common->adddatamodel("Contest", $contestId, $data);
      if ($response) {
        $this->session->set_flashdata('successmessage', 'New contest added successfully..');
      } else {
        $this->session->set_flashdata('warningmessage', 'Error in creating new contest..');
      }
      redirect('contest');
    } else {
      $this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
      redirect('contest');
    }
  }

  public function editcontest()
  {
    $id = $this->uri->segment(3);
    $data['id'] = $id;
    $data['contestdetails'] = $this->common->readdatadocument("Contest", $id);
    $this->template->template_render('editcontest', $data);
  }

  public function updatecontestdata()
  {
    $id = $this->uri->segment(3);
    if (isset($_POST)) {
      $response = $this->common->updatedatamodel("Contest", $id, $this->input->post());
      if ($response) {
        $this->session->set_flashdata('successmessage', 'contest updated successfully..');
        redirect('contest');
      } else {
        $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
        redirect('contest');
      }
    } else {
      $this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
      redirect('contest');
    }
  }

  public function featureContest()
  {
    $id = $this->uri->segment(3);

    $data['isFeatured'] = TRUE;
    $response = $this->common->updatedatamodel("Contest", $id, $data);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Contest Featured successfully..');
      redirect('contest');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
      redirect('contest');
    }
  }
}
