<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->helper('url');
        $this->load->library('session');
        $this->load->model('dashboard_model');
        $this->load->model('common');
        $this->load->model('geofence_model');
        // $this->load->database();
    }

    public function index()
    {
        $data["usersCount"] = $this->common->readnumberofdocumentsincollectionbetween("Users", "userType", "=", "USER");
        $data["contestsCount"] = $this->common->readnumberofdocumentsincollectionbetween("Contest");
        $this->template->template_render('dashboard', $data);
    }



    public function iechart()
    {
        $data = $this->common->get_iechartdata();
        $res = "['" . implode("', '", array_keys($data)) . "']";
        $income = "['" . implode("', '", array_column($data, 'income')) . "']";
        $expense = "['" . implode("', '", array_column($data, 'expense')) . "']";
        echo json_encode(array('res' => $res, 'income' => $income, 'expense' => $expense));
    }
    public function remindermark()
    {
        $data = array('r_isread' => 1);
        $this->db->where('r_id', $this->input->post('r_id'));
        echo $this->db->update('reminder', $data);
    }
    public function privacypolicy()
    {
        $this->load->helper('file');
        $fileName = FCPATH  . "assets/privacy/privacypolicy.html";

        $data['html'] = read_file($fileName);
        $this->template->template_render('edit_privacy', $data);
    }
    public function editprivacypolicy()
    {
        $this->load->helper('file');
        // $businessName = "Gillani Estates";
        // $fileName = base_url() . "assets/privacy/privacypolicy" . time() . ".txt";
        $fileName = FCPATH  . "assets/privacy/privacypolicy.html";

        $html = $this->input->post('htmldata');
        if (!write_file($fileName, $html)) {
            echo 'Unable to write the file';
        } else {
            $data['success'] = true;
            echo json_encode($data);
        }
    }
    public function generateprivacypolicy()
    {
        $this->load->helper('file');
        $businessName = $this->input->post('businessName');
        $endDate = $this->input->post('endDate');
        $appName = $this->input->post('appName');
        $fileName = "assets/privacy/privacypolicy" . time() . ".html";
        // $fileName = base_url() . "assets/privacy/privacypolicy" . time() . ".txt";
        $filePath = FCPATH  . $fileName;


        $html = preg_replace('/{{BusinessName}}/i', $businessName, $this->input->post('htmldata'));
        $html = preg_replace('/{{EndDate}}/i', $endDate, $html);
        $html = preg_replace('/{{AppName}}/i', $appName, $html);
        if (!write_file($filePath, $html)) {
            echo 'Unable to write the file';
        } else {
            $data['success'] = true;
            $data['link'] = base_url() . $fileName;
            echo json_encode($data);
        }

        // print_r($html);
    }
}
