<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark">Contest's List
        </h1>
      </div>
      <!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="<?= base_url(); ?>/dashboard">Dashboard</a></li>
          <li class="breadcrumb-item active">Contest's List</li>
        </ol>
      </div>
    </div>
  </div>
</div>
<section class="content">
  <div class="container-fluid">
    <div class="card">
      <div class="card-body p-0">
        <div class="table-responsive">
          <table id="custtbl" class="table card-table table-vcenter text-nowrap">
            <thead>
              <tr>
                <th class="w-1">S.No</th>
                <th>Contest Name</th>
                <th>Image</th>
                <th>Start Date</th>
                <th>End Date</th>
                <th>Persons Limit</th>
                <th>Earning</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody>
              <?php if (!empty($contests)) {
                $count = 1;
                foreach ($contests as $contestId => $contest) {
              ?>
                  <tr>
                    <td> <?php echo output($count);
                          $count++; ?></td>
                    <td> <?php echo output($contest['contestName']); ?></td>
                    <td> <img src="<?php echo $contest['shoePhoto'][0]; ?>" height="100px" width="100px" alt=""> </td>
                    <td> <?php echo date('m/d/Y', $contest['startDate'] / 1000); ?></td>
                    <td><?php echo date('m/d/Y', $contest['endDate'] / 1000); ?></td>
                    <td><?php echo output($contest['personLimit']); ?></td>
                    <td><?php echo "$ " . output($contest['ticketPrice']); ?></td>
                    <td>
                      <?php
                      if ($contest['isFeatured']) {
                      ?>
                        <span class="badge badge-success">Featured</span>
                      <?php
                      } else {
                      ?>
                        <a class="icon" href="<?php echo base_url(); ?>contest/featureContest/<?php echo output($contestId); ?>">
                          <button class="btn btn-warning">Feature</button>
                        </a>
                      <?php
                      }
                      ?>
                    </td>
                  </tr>
              <?php }
              } ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</section>