<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/BaseController.php';
class Login extends BaseController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('login_model');
        $this->load->model('user_model');
            $this->load->library('facebook');
    }

    /**
     * Index Page for this controller.
     */
    public function index()
    {
        
        $this->isLoggedIn();
        
    }

    
    /**
     * This function used to check the user is logged in or not
     */
    function isLoggedIn()
{
    $isLoggedIn = $this->session->userdata('isLoggedIn');

    // Check if the user is already logged in
    if (isset($isLoggedIn)) {
        // Redirect to the site if the user is logged in
        redirect('site');
    }

    // Include the necessary libraries for Google API
    include_once APPPATH . "libraries/google-api-php-client/Google_Client.php";
    include_once APPPATH . "libraries/google-api-php-client/contrib/Google_Oauth2Service.php";
    $this->load->config('social');

    // Google API Credentials
    $client_id = $this->config->item('google_client_id');
    $client_secret = $this->config->item('google_client_secret');
    $redirect_url = base_url() . $this->config->item('google_redirect_url');

    // Google Client Configuration
    $google = new Google_Client();
    $google->setApplicationName('Login to Social Login');
    $google->setClientId($client_id);
    $google->setClientSecret($client_secret);
    $google->setRedirectUri($redirect_url);
    $google_oauthV2 = new Google_Oauth2Service($google);

    // Handle Google OAuth2 callback
    if (isset($_GET['code']) && !isset($_GET['state'])) {
        $google->authenticate($_GET['code']);
        $this->session->set_userdata('google_access_token', $google->getAccessToken());
        redirect($redirect_url);
    }

    $gp_access_token = $this->session->userdata('google_access_token');
    if (!empty($gp_access_token)) {
        $google->setAccessToken($gp_access_token);
    }

    // Facebook and Google login handling
    $data = array();

    if ($this->facebook->is_authenticated()) {
        // Facebook login flow
        $userProfile = $this->facebook->request('get', '/me?fields=id,first_name,last_name,email,gender,locale,picture.width(128).height(128)');

        if (!empty($userProfile) && !empty($userProfile['id'])) {
            // Prepare user data for insertion
            $userData['oauth_provider'] = 'facebook';
            $userData['oauth_uid'] = $userProfile['id'] ?? '';
            $userData['first_name'] = $userProfile['first_name'] ?? '';
            $userData['last_name'] = $userProfile['last_name'] ?? '';
            $userData['email'] = $userProfile['email'] ?? '';
            $userData['gender'] = $userProfile['gender'] ?? '';
            $userData['link'] = 'https://www.facebook.com/' . $userData['oauth_uid'];
            $userData['picture'] = $userProfile['picture']['data']['url'] ?? '';

            // Additional processing if needed
            // ...

        } else {
            // Get login URLs
            $data['fb_login_url'] = $this->facebook->login_url();
            $data['gl_login_url'] = $google->createAuthUrl();
        }
    } elseif ($google->getAccessToken()) {
        // Google login flow
        $userProfile = $google_oauthV2->userinfo->get();

        if (!empty($userProfile) && !empty($userProfile['id'])) {
            // Prepare user data for insertion
            $userData['oauth_provider'] = 'google';
            $userData['oauth_uid'] = $userProfile['id'] ?? '';
            $userData['first_name'] = $userProfile['given_name'] ?? '';
            $userData['last_name'] = $userProfile['family_name'] ?? '';
            $userData['email'] = $userProfile['email'] ?? '';
            $userData['gender'] = $userProfile['gender'] ?? '';
            $userData['link'] = $userProfile['link'] ?? '';
            $userData['picture'] = $userProfile['picture'] ?? '';

            // Insert or update user data
            $userInfo = array(
                'name' => $userData['first_name'] . " " . $userData['last_name'],
                'first_name' => $userData['first_name'],
                'last_name' => $userData['last_name'],
                'image' => $userData['picture'],
                'email' => $userData['email'],
                'login_oauth_uid' => $userData['oauth_uid'],
                'signintype' => 'google',
                'role' => 'user', 
                'isOnline' => 1,
            );

            $existingUser = $this->db->where('login_oauth_uid', $userData['oauth_uid'])->get('users')->row_array();
            if (empty($existingUser)) {
                $this->db->insert('users', $userInfo);
                $result = $this->db->insert_id();

                $user = array(
                    'user_id' => $result,
                    'firstname' => $userData['first_name'],
                    'lastname' => $userData['last_name'],
                    'category' => "",
                    'treatment' => "",
                    'noofsurgery' => "",
                    'practiceType' => "",
                    'specialist' => "",
                    'address' => "",
                    'postcode' => ""
                );
                $this->db->insert('user', $user);

                $user = $this->db->where('login_oauth_uid', $userData['oauth_uid'])->get('users')->row();
                $sessionArray = array(
                    'userId' => $user->id,
                    'name' => $user->name,
                    'first_name' => $user->first_name,
                    'last_name' => $user->last_name,
                    'email' => $user->email,
                    'role' => 'user',
                    'isLoggedIn' => TRUE
                );

                $this->session->set_userdata($sessionArray);
                $this->session->set_flashdata('success', 'New User created successfully');
                redirect('site/editprofile');
            } else {
                $user = $this->db->where('login_oauth_uid', $userData['oauth_uid'])->get('users')->row();
                if ($user->role === 'user') {
                    $sessionArray = array(
                        'userId' => $user->id,
                        'name' => $user->name,
                        'first_name' => $user->first_name,
                        'last_name' => $user->last_name,
                        'email' => $user->email,
                        'role' => 'user',
                        'isLoggedIn' => TRUE
                    );

                    $this->session->set_userdata($sessionArray);
                    $this->session->set_flashdata('success', 'Welcome back...');
                    redirect('site/editprofile');
                } else {
                    $this->session->set_flashdata('error', 'You do not have permission to log in.');
                    redirect('site/logout');
                }
            }
        } else {
            // Get login URLs
            $data['fb_login_url'] = $this->facebook->login_url();
            $data['gl_login_url'] = $google->createAuthUrl();
        }
    } else {
        // Get login URLs
        $data['fb_login_url'] = $this->facebook->login_url();
        $data['gl_login_url'] = $google->createAuthUrl();
    }

    // Load the login view with the appropriate data
    $this->load->view('login', $data);
}

    
    
    /**
     * This function used to logged in user
     */
      public function loginMe()
    {
        $this->load->library('form_validation');
    
        $this->form_validation->set_rules('email', 'Email', 'required|valid_email|max_length[128]|trim');
        $this->form_validation->set_rules('password', 'Password', 'required|max_length[32]');
    
        if ($this->form_validation->run() == FALSE) {
            $this->index();
        } else {
            $email = strtolower($this->security->xss_clean($this->input->post('email')));
            $password = $this->input->post('password');
    
            $result = $this->login_model->loginMe($email, $password);
    
            if (!empty($result) && $result->role === 'user') {
                // Create session data if the user is valid and has the 'user' role
                $sessionArray = array(
                    'userId' => $result->id,
                    'image' => $result->image,
                    'email' => $result->email,
                    'isLoggedIn' => TRUE,
                    'name' => $result->first_name . ' ' . $result->last_name,
                    'first_name' => $result->first_name,
                    'last_name' => $result->last_name
                );
    
                $this->session->set_userdata($sessionArray);
    
                // Set user as online
                $userData = array('isOnline' => 1);
                $this->user_model->editUser($userData, $result->id);
    
                redirect(base_url('site'));
            } else {
                // Set error message for invalid login or incorrect role
                $errorMessage = empty($result) ? 'Email or password mismatch' : 'Access denied. Only users with the role "user" can log in.';
                $this->session->set_flashdata('error', $errorMessage);
                redirect(base_url('login'));
            }
        }
    }

    /**
     * This function used to load forgot password view
     */
    public function forgotPassword()
    {
        $isLoggedIn = $this->session->userdata('isLoggedIn');
        
        if(!isset($isLoggedIn) || $isLoggedIn != TRUE)
        {
            $this->load->view('users/forgotPassword');
        }
        else
        {
            redirect('/dashboard');
        }
    }
    
    /**
     * This function used to generate reset password request link
     */
    function resetPasswordUser()
    {
        $status = '';
        
        $this->load->library('form_validation');
        
        $this->form_validation->set_rules('login_email','Email','trim|required|valid_email');
                
        if($this->form_validation->run() == FALSE)
        {
            $this->forgotPassword();
        }
        else 
        {
            $email = strtolower($this->security->xss_clean($this->input->post('login_email')));
            
            if($this->login_model->checkEmailExist($email))
            {
                $encoded_email = urlencode($email);
                
                $this->load->helper('string');
                $data['email'] = $email;
                $data['activation_id'] = random_string('alnum',15);
                $data['createdDtm'] = date('Y-m-d H:i:s');
                $data['agent'] = getBrowserAgent();
                $data['client_ip'] = $this->input->ip_address();
                
                $save = $this->login_model->resetPasswordUser($data);                
                
                if($save)
                {
                    $data1['reset_link'] = base_url() . "resetPasswordConfirmUser/" . $data['activation_id'] . "/" . $encoded_email;
                    $userInfo = $this->login_model->getCustomerInfoByEmail($email);

                    if(!empty($userInfo)){
                        $data1["name"] = $userInfo->name;
                        $data1["email"] = $userInfo->email;
                        $data1["message"] = "Reset Your Password";
                    }

                    $sendStatus = resetPasswordEmail($data1);

                    if($sendStatus){
                        $status = "send";
                        setFlashData($status, "Reset password link sent successfully, please check mails.");
                    } else {
                        $status = "notsend";
                        setFlashData($status, "Email has been failed, try again.");
                    }
                }
                else
                {
                    $status = 'unable';
                    setFlashData($status, "It seems an error while sending your details, try again.");
                }
            }
            else
            {
                $status = 'invalid';
                setFlashData($status, "This email is not registered with us.");
            }
            redirect('/forgotPassword');
        }
    }

    /**
     * This function used to reset the password 
     * @param string $activation_id : This is unique id
     * @param string $email : This is user email
     */
    function resetPasswordConfirmUser($activation_id, $email)
    {
        // Get email and activation code from URL values at index 3-4
        $email = urldecode($email);
        
        // Check activation id in database
        $is_correct = $this->login_model->checkActivationDetails($email, $activation_id);
        
        $data['email'] = $email;
        $data['activation_code'] = $activation_id;
        
        if ($is_correct == 1)
        {
            $this->load->view('users/newPassword', $data);
        }
        else
        {
            redirect('/login');
        }
    }
    
    /**
     * This function used to create new password for user
     */
    function createPasswordUser()
    {
        $status = '';
        $message = '';
        $email = strtolower($this->input->post("email"));
        $activation_id = $this->input->post("activation_code");
        
        $this->load->library('form_validation');
        
        $this->form_validation->set_rules('password','Password','required|max_length[20]');
        $this->form_validation->set_rules('cpassword','Confirm Password','trim|required|matches[password]|max_length[20]');
        
        if($this->form_validation->run() == FALSE)
        {
            $this->resetPasswordConfirmUser($activation_id, urlencode($email));
        }
        else
        {
            $password = $this->input->post('password');
            $cpassword = $this->input->post('cpassword');
            
            // Check activation id in database
            $is_correct = $this->login_model->checkActivationDetails($email, $activation_id);
            
            if($is_correct == 1)
            {                
                $this->login_model->createPasswordUser($email, $password);
                
                $status = 'success';
                $message = 'Password reset successfully';
            }
            else
            {
                $status = 'error';
                $message = 'Password reset failed';
            }
            
            setFlashData($status, $message);

            redirect("/login");
        }
    }

    private function accessInfo($roleId)
    {
        $finalMatrixArray = [];
        $matrix = $this->login_model->getRoleAccessMatrix($roleId);
        
        if(!empty($matrix)) {
            $accessMatrix = json_decode($matrix->access);
            foreach($accessMatrix as $moduleMatrix) {
                $finalMatrixArray[$moduleMatrix->module] = (array) $moduleMatrix;
            }
        }
        
        return $finalMatrixArray;
    }
}

?>