<style>
  .w-200px {
    width: 230px;
  }
  .info-title{
    background: none;
    margin-right: auto;
    border: none;
  }
  .info-card-detail{
    padding-right: 10px;
  }
   @media(max-width:768px){
     .w-200px {
    width: 200px;
  }
   .w100p{
      width:100%;
  }
  
  }
</style>
<main class="">
  <div class="container my-2">
    <div class="">
      <div class="d-flex justify-content-center">
        <!-- Nav tabs -->
        <ul
          class="nav nav-tabs n-tabs gap-3 mt-4"
          id="contentTabs"
          role="tablist"
        >
          <li class="nav-item" role="presentation">
            <button
              class="nav-link active w-200px"
              id="articles-tab"
              data-bs-toggle="tab"
              data-bs-target="#articles"
              type="button"
              role="tab"
              aria-controls="articles"
              aria-selected="true"
              data-i18n="client_activity"
            ></button>
          </li>
          <li class="nav-item" role="presentation">
            <button
              class="nav-link w-200px"
              id="videos-tab"
              data-bs-toggle="tab"
              data-bs-target="#videos"
              type="button"
              role="tab"
              aria-controls="videos"
              aria-selected="false"
              data-i18n="prospective_client_activity"
            ></button>
          </li>
        </ul>
      </div>

      <!-- Tab panes -->
      <div class="tab-content mt-2" id="contentTabsContent">
        <div
          class="tab-pane fade show active mb-5 mt-2"
          id="articles"
          role="tabpanel"
          aria-labelledby="articles-tab"
        >
          <div class="row g-2 my-3">
          
          </div>
        </div>
        <div
          class="tab-pane fade my-3"
          id="videos"
          role="tabpanel"
          aria-labelledby="videos-tab"
        >
          <div class="row g-2 my-3">
           
          </div>
        </div>
      </div>
    </div>
  </div>
</main>
<!-- Swiper CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
<!-- Swiper JS -->
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
<scrip src="https://vjs.zencdn.net/7.20.3/video.min.js"></script>
<script>
  // Global variables
  let currentUser = null;
  let currentUserData = null;
   firebase.initializeApp(firebaseConfig);
  const db = firebase.firestore();
  const auth = firebase.auth();

  // Initialize when auth state changes
  // firebase.auth().onAuthStateChanged(async (user) => {
  //   if (user) {
  //     currentUser = user;
  //     currentUserData = await db.collection("Users").doc(user.uid).get().then(doc => doc.data());
  //     loadAlerts();
  //   }
  // });

  firebase.auth().onAuthStateChanged(async (user) => {
    if (user) {
      try {
        currentUser = user;

        // Fetch user Firestore data
        const userDoc = await db.collection("Users").doc(user.uid).get();
        currentUserData = userDoc.exists ? userDoc.data() : null;

        if (!currentUserData) {
          console.warn("⚠️ No user data found for:", user.uid);
          return;
        }

        // Store a marker so reload runs only once
        const hasReloaded = sessionStorage.getItem("hasReloaded");

        // Call loadAlerts after ensuring user data is ready
        await loadAlerts();

        // 🔄 Force one-time reload (to ensure Firestore listeners + DOM align)
        if (!hasReloaded) {
          console.log("🔄 Initializing full sync reload...");
          sessionStorage.setItem("hasReloaded", "true");
          setTimeout(() => {
            window.location.reload();
          }, 500);
        } else {
          console.log("✅ Auth ready, alerts loaded (no reload needed)");
        }

      } catch (err) {
        console.error("❌ Error during auth initialization:", err);
      }
    } else {
      console.log("🚪 User signed out");
      currentUser = null;
      currentUserData = null;
      sessionStorage.removeItem("hasReloaded");
    }
  });



    let unsubscribeClientActivity = null;
    let unsubscribeProspectiveActivity = null;

 
    async function loadAlerts() {
      if (!currentUser) return;

      // 🔄 Unsubscribe old listeners
      if (unsubscribeClientActivity) unsubscribeClientActivity();
      if (unsubscribeProspectiveActivity) unsubscribeProspectiveActivity();

      try {
        // 1️⃣ Fetch current user
        const userDoc = await db.collection("Users").doc(currentUser.uid).get();
        const userData = userDoc.data();
        if (!userData) return console.warn("No user data found.");

        // 2️⃣ Get Law Firm and Practice Areas
        const lawFirmId = userData.LawFirmId;
        if (!lawFirmId) return console.warn("No LawFirmId found.");

        const lawFirmDoc = await db.collection("LawFirm").doc(lawFirmId).get();
        const lawFirmData = lawFirmDoc.data();
        if (!lawFirmData) return console.warn("No LawFirm data found.");

        const practiceAreas = lawFirmData.practiceAreas || [];

        // 3️⃣ Build dynamic queries for BOTH law fields
        const lawFields = [];
        if (practiceAreas.includes("Criminal Defense")) lawFields.push("LawId");
        if (practiceAreas.includes("Immigration")) lawFields.push("imigrationLawId");

        if (lawFields.length === 0) {
          console.warn("⚠️ No valid practice area found (Criminal/Immigration).");
          return;
        }

        // 4️⃣ Create a combined query array (both fields)
        const clientQueries = [];
        const prospectiveQueries = [];

        lawFields.forEach((lawField) => {
          clientQueries.push(
            db.collection("QuoteAlert")
              .where(lawField, "==", currentUser.uid)
              .where("status", "==", "request")
              .where("isLawArchived", "in", [false, null])
          );
          prospectiveQueries.push(
            db.collection("QuoteAlert")
              .where(lawField, "==", currentUser.uid)
              .where("status", "==", "request")
              .where("isLawArchived", "in", [false, null])
          );
        });

        // 5️⃣ Attach snapshot listeners (merge multiple lawFields)
        unsubscribeClientActivity = onMultipleSnapshots(clientQueries, handleClientActivitySnapshot);
        unsubscribeProspectiveActivity = onMultipleSnapshots(prospectiveQueries, handleProspectiveSnapshot);

      } catch (error) {
        console.error("❌ Error loading alerts:", error);
      }
    }

  /**
   * 🔁 Helper function to listen to multiple snapshot queries and merge them.
   */

    function onMultipleSnapshots(queries, callback) {
      const unsubscribers = queries.map((query) =>
        query.onSnapshot((snapshot) => callback(snapshot))
      );
      return () => unsubscribers.forEach((unsub) => unsub());
    }

    function handleClientActivitySnapshot(snapshot) {
      const container = document.querySelector("#articles .row.g-2.my-3");
      renderAlerts(snapshot, container, true);
    }

    function handleProspectiveSnapshot(snapshot) {
      const container = document.querySelector("#videos .row.g-2.my-3");
      renderAlerts(snapshot, container, false);
    }

    async function renderAlerts(snapshot, container, isClientActivity) {
      container.innerHTML = ""; // Clear existing content

      if (snapshot.empty) {
        container.innerHTML = `
          <div class="col-md-12">
            <div class="alert alert-warning">
              <div class="card-body text-center">
                <p>No activity found</p>
              </div>
            </div>
          </div>
        `;
        return;
      }
      
      const sortedDocs = snapshot.docs.sort((a, b) => b.data().createdDate - a.data().createdDate);
     for (const doc of sortedDocs) {
       const alert = doc.data();
        if (alert.isAttorenyHide === true) continue;
        // Fetch the client (user who raised alert)
        const userDoc = await db.collection("Users").doc(alert.userId).get();
        const userData = userDoc.data();

        const designatedLawyer = userData.designatedLawyerId || "";
        const designatedImmLawyer = userData.designatedImmigrationLawyerId || "";
        const isDesignated = (designatedLawyer === currentUser.uid) || (designatedImmLawyer === currentUser.uid);

        // Keep client vs prospective logic consistent for both fields
        if (isClientActivity && !isDesignated) continue;   // client tab: must be designated
        if (!isClientActivity && isDesignated) continue;   // prospective tab: must NOT be designated



        // Format date
        const date = new Date(alert.createdDate);
        const formattedDate = date.toLocaleDateString('en-US', {
          weekday: 'long',
          year: 'numeric',
          month: 'long',
          day: 'numeric',
          hour: '2-digit',
          minute: '2-digit'
        });

        let attorneyName = "Opted Out";
        let immigrationAttorneyName = "Opted Out";

        try {
          console.debug("[renderAlerts] docId:", doc.id, "alert raw:", alert);

            // --- Criminal attorney ---
            if (alert.LawId) {
              const attorneyDoc = await db.collection("Users").doc(alert.LawId).get();
              if (attorneyDoc.exists) {
                const attorneyData = attorneyDoc.data();
                attorneyName = attorneyData.Name || "N/A";
              } else {
                attorneyName = "Opted Out";
              }
            }

            // --- Immigration attorney ---
            if (alert.imigrationLawId) {
              const immDoc = await db.collection("Users").doc(alert.imigrationLawId).get();
              if (immDoc.exists) {
                const immData = immDoc.data();
                immigrationAttorneyName = immData.Name || "N/A";
              } else {
                immigrationAttorneyName = "Opted Out";
              }
            }

          } catch (err) {
            console.error("[renderAlerts] Error fetching attorney(s):", err);
          }


        // Generate Swiper video section
        const swiperClass = `swiper-${doc.id}`;
      
        const videoHtml = alert.videoUrls && alert.videoUrls.length > 0 ? `
        <video 
          class="video-cl w-100 mb-2 autoplay-video" 
          data-index="0"
          data-urls='${JSON.stringify(alert.videoUrls)}'
          muted 
          autoplay 
          playsinline 
          controls>
          <source src="${alert.videoUrls[0]}" type="video/mp4">
          Your browser does not support the video tag.
        </video>
        ` : '<div class="alert alert-info">No video available</div>';


        if (alert.videoUrls && alert.videoUrls.length > 0) {
          setTimeout(() => {
            new Swiper(`.swiper-${doc.id}`, {
              loop: true,
              slidesPerView: 1,
              spaceBetween: 10,
              navigation: {
                nextEl: `.swiper-${doc.id} .swiper-button-next`,
                prevEl: `.swiper-${doc.id} .swiper-button-prev`,
              },
              pagination: {
                el: `.swiper-${doc.id} .swiper-pagination`,
                clickable: true,
              },
            });
          }, 0);
        }

          // ✅ Immigration info
        const ANumber = userData.ANumber || "N/A";
        const countryOfCitizenship = userData.countryOfCitizenship || "N/A";
        const visaType = userData.visaType || "N/A";
        const visaExpiryDate = userData.visaExpiryDate
          ? new Date(userData.visaExpiryDate).toLocaleDateString('en-US')
      : "N/A";
       const dateOfBirth = userData.userDOB
          ? new Date(userData.userDOB).toLocaleDateString('en-US')
      : "N/A";

        // Card UI
        const alertHtml = `
          <div class="col-md-12">
          <div class="card stCard">
                  
                    <div class="card-body">
                    <div class="d-flex justify-content-end align-items-center">
                      <div class="info-title">
                        <p class="mb-0 fp2">Legal Emergency Alert for ${alert.title}</p>
                        <p class="ft7 mb-2">${formattedDate}</p>
                      </div>
                      <div clas="d-flex gap-3 align-items-center">
                    
                      ${alert.isFalse ? `<img src="<?= base_url('assets/images/icons/warning.png'); ?>" alt="Warning" style="width: 20px; height: 20px; margin-left: 5px;" title="False Alert" />` : ""}
                        <button onclick="archiveByLawyer('${doc.id}')" class="btn btn-sm  py-1 px-2 btn-ar" title="Archive">
                          <img src="<?= base_url(); ?>/assets/images/icons/ari.png"/> <small>Archive</small>
                          </button>
                        <button onclick="openDocusignDocument('${doc.id}')" class="btn btn-sm py-1 px-2 btn-ar" title="document">
                          <i class="fa-solid fa-file" style="color:#0412CA; font-size:22px"></i>
                        </button>

                      </div>
                    </div>
                    <div class="row g-2">
                   <div class="col-md-6">

                    <div class="d-flex flex-wrap flex-column gap-3">
                      <div class="d-flex flex-wrap align-items-start">

                        <!-- 🟦 PERSONAL INFO -->
                        <p class="fw-bold text-primary mb-1 mt-2 w-100 border-bottom pb-1">Personal Info</p>
                        <p class="mb-0 info-card-detail"><strong>Client Name:</strong> ${userData.Name}</p>
                        <p class="mb-0 info-card-detail"><strong>Date of Birth:</strong> ${dateOfBirth}</p>
                        <p class="mb-0 info-card-detail"><strong>Location:</strong> ${alert.city}, ${alert.county}</p>

                        <!-- 🟩 IMMIGRATION INFO -->
                        <p class="fw-bold text-success mb-1 mt-2 w-100 border-bottom pb-1">Immigration Info</p>
                        <p class="mb-0 info-card-detail"><strong>Citizenship:</strong> ${countryOfCitizenship}</p>
                        <p class="mb-0 info-card-detail"><strong>Visa Type:</strong> ${visaType}</p>
                        <p class="mb-0 info-card-detail"><strong>Visa Expiry Date:</strong> ${visaExpiryDate}</p>
                        <p class="mb-0 info-card-detail"><strong>A-Number:</strong> ${ANumber}</p>

                        <!-- 🟥 CASE DETAILS -->
                        <p class="fw-bold text-danger mb-1 mt-2 w-100 border-bottom pb-1">Case Details</p>
                        <p class="mb-0 info-card-detail"><strong>Offense:</strong>
                          ${
                            Array.isArray(alert.offense) && alert.offense.length
                              ? alert.offense.map(o =>
                        `${o.chargedesc} (${o.severity}) - ${o.warrantissuedagency || 'Unknown Agency'}`
                                ).join('<br>')
                              : 'N/A'
                          }
                        </p>
                        <p class="mb-0 info-card-detail"><strong>Detained At:</strong> ${alert.detainedPlace || 'N/A'}</p>
                        <p class="mb-0 info-card-detail"><strong>Designated Attorney:</strong> ${attorneyName}, ${immigrationAttorneyName}</p>
                        <p class="mb-0 info-card-detail"><strong>Attorney Alerted:</strong> ${alert.isAttorneyAlerted ? 'Yes' : 'No'}</p>

                      </div>
                    </div>

                    </div>


                  <div class="col-md-6">
                    ${videoHtml}
                  </div>
                </div>

                <form id="form-${doc.id}" class="row" method="post" onsubmit="return handleSubmit(event, '${doc.id}')">
                  <div class="col-md-3">
                    <label for="quote-${doc.id}" class="s-label">Quote</label>
                    <div class="input-group inp-gr mb-3">
                      <span class="input-group-text">$</span>
                      <input type="number" class="form-control" id="quote-${doc.id}" name="quote"
                        placeholder="Enter Quote" value="${alert.qoutesPrice || ''}" required />
                    </div>
                  </div>
                  <div class="col-md-3">
                    <label for="deposit-${doc.id}" class="s-label">Deposit</label>
                    <div class="input-group inp-gr mb-3">
                      <span class="input-group-text">$</span>
                      <input type="number" class="form-control" id="deposit-${doc.id}" name="deposit"
                        placeholder="Enter deposit" value="${alert.qoutesDeposite || ''}"  />
                    </div>
                  </div>
                  <div class="col-md-6">
                  <div class="row g-2 justify-content-end">

                    <div class="col-6 col-md-auto d-flex justify-content-center justify-content-md-end">
                      <button 
                        onclick="fetchArrestDetails('${alert.title}', '${doc.id}')"
                        type="button"
                        class="btn btn-save w-100 border-15 py-2 px-3">
                        Arrest Details
                      </button>
                    </div>

                    ${
                      isClientActivity
                        ? `<div class="col-6 col-md-auto d-flex justify-content-center justify-content-md-end">
                            <button type="button"
                              class="btn btn-danger w-100 border-15 py-2 px-4"
                              onclick="handleOptOut('${doc.id}')">Opt Out</button>
                          </div>`
                        : ""
                    }

                    <div class="col-6 col-md-auto d-flex justify-content-center justify-content-md-end">
                      <button type="submit"
                        class="btn btn-save w-100 border-15 py-2 px-4">
                        Submit
                      </button>
                    </div>

                    <div class="col-6 col-md-auto d-flex justify-content-center justify-content-md-end">
                      <button
                        onclick="hideAlertFromAttorney('${doc.id}')"
                        type="button"
                        class="btn btn-danger w-100 border-15 py-2 px-4"
                        title="Permanently Delete?">
                        Delete Activity
                      </button>
                    </div>

                  </div>
                </div>

                </form>
              </div>
            </div>
          </div>
        `;

        container.insertAdjacentHTML('beforeend', alertHtml);
      }
      setupSequentialPlayback();
    }

    async function handleOptOut(alertId) {
      try {
        const alertRef = db.collection("QuoteAlert").doc(alertId);
        console.log("Alert Reference:", alertRef);
                
        
        const alertDoc = await alertRef.get();
        console.log("Alert Document:", alertDoc);
        if (!alertDoc.exists) {
          Swal.fire("Error", "Alert not found.", "error");
          return;
        }

        const alertData = alertDoc.data();
        console.log("Alert Data:", alertData);

        const lawyerId = currentUser.uid; // ✅ match against attorney ID

        
        const updateFields = {
          updatedAt: firebase.firestore.FieldValue.serverTimestamp(),
        };
        if (alertData.LawId === lawyerId) {
          updateFields.LawId = "",
          updateFields.isOptOut = true; // Criminal attorney opted out
        }
        if (alertData.imigrationLawId === lawyerId) {
          updateFields.imigrationLawId = "",
          updateFields.isImmigrationOptOut = true; // Immigration attorney opted out
        }

        await alertRef.update(updateFields);

        // 🔔 Notify client + emergency contacts
        await sendOptOutMessagesToUserAndEmergency(alertData.userId);

        Swal.fire({
          icon: "success",
          title: "Opted Out",
          text: "You have successfully opted out of this case.",
        });

        loadAlerts();
      } catch (error) {
        console.error("Error opting out:", error);
        Swal.fire({
          icon: "error",
          title: "Error",
          text: "Failed to opt out. Please try again.",
        });
      }
    }


    // async function handleSubmit(event, alertId) {
    //   event.preventDefault();
      
    //   const quote = parseFloat(document.getElementById(`quote-${alertId}`).value);
    //   let deposit = parseFloat(document.getElementById(`deposit-${alertId}`).value);
      
    //     if (isNaN(deposit)) {
    //     deposit = 0;
    //   }


      
    //   if (isNaN(quote) || isNaN(deposit) || quote <= 0 ) {
    //     Swal.fire({
    //       icon: "error",
    //       title: "Invalid Input",
    //       text: "Please enter valid positive numbers for quote and deposit",
    //     });
    //     return;
    //   }
      
    //   try {
    //     await db.collection("QuoteAlert").doc(alertId).update({
    //       qoutesPrice: quote,
    //       qoutesDeposite: deposit,
    //       isAttorneyAlerted: true,
    //       status: "accept",
    //       updatedAt: firebase.firestore.FieldValue.serverTimestamp()
    //     });
        
    //     Swal.fire({
    //       icon: "success",
    //       title: "Submitted",
    //       text: "Quote  have been successfully submitted",
    //     });
        
    //     // Refresh the alerts
    //     loadAlerts();
    //   } catch (error) {
    //     console.error("Error submitting quote:", error);
    //     Swal.fire({
    //       icon: "error",
    //       title: "Error",
    //       text: "Failed to submit quote. Please try again.",
    //     });
    //   }
    // }
  async function handleSubmit(event, alertId) {
    event.preventDefault();

    const quote = parseFloat(document.getElementById(`quote-${alertId}`).value);
    let deposit = parseFloat(document.getElementById(`deposit-${alertId}`).value);
    if (isNaN(deposit)) deposit = 0;

    if (isNaN(quote) || isNaN(deposit) || quote <= 0) {
      Swal.fire({
        icon: "error",
        title: "Invalid Input",
        text: "Please enter valid positive numbers for quote and deposit",
      });
      return;
    }

    try {
      const alertRef = db.collection("QuoteAlert").doc(alertId);
      const alertDoc = await alertRef.get();
      if (!alertDoc.exists) {
        Swal.fire("Error", "QuoteAlert not found.", "error");
        return;
      }
      const alertData = alertDoc.data();
  
    // ✅ Step 1: Get LawFirmId and TemplateId
      if (!currentUserData || !currentUserData.LawFirmId) {
        Swal.fire("Error", "LawFirm ID not found in user data.", "error");
        return;
      }

      const lawFirmId = currentUserData.LawFirmId;
      const lawFirmDoc = await db.collection("LawFirm").doc(lawFirmId).get();
      if (!lawFirmDoc.exists) {
        Swal.fire("Error", "LawFirm document not found.", "error");
        return;
      }

      const lawFirmData = lawFirmDoc.data();
      const templateId = lawFirmData.templateId;

    // ✅ Step 2: If template_id is missing in QuoteAlert → duplicate-template API
  
      if (!alertData.template_id) {
        if (!templateId) {
          Swal.fire("Missing Template", "Template not found in LawFirm.", "error");
          return;
        }

        Swal.fire({
          title: "Preparing document...",
          text: "Please wait while we duplicate template.",
          allowOutsideClick: false,
          didOpen: () => Swal.showLoading(),
        });
       

        const apiUrl = "https://buzzwaretechserver.site/duepro_docusign_apis/index.php/docusign/duplicate-template";
        // const apiUrl = "https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/duplicate-template";
        // const apiUrl = "http://137.184.111.69/test_docusign_apis/index.php/docusign/duplicate-template";
        const formData = new URLSearchParams();
        formData.append("template_id", templateId);
        formData.append("doc_id", alertId);

        const response = await fetch(apiUrl, {
          method: "POST",
          body: formData,
        });
        const result = await response.json();
        Swal.close();

        if (!result.success) {
          Swal.fire("Error", result.message || "Failed to duplicate template.", "error");
          return;
        }
      }

    // ✅ Step 3: If both LawId and imigrationLawId exist → make a copy
      if (alertData.LawId && alertData.imigrationLawId) {
        const newData = { ...alertData };
        newData.qoutesPrice = 0;
        newData.qoutesDeposite = 0;
        newData.isCopy = true;
        newData.status = "request";
        newData.LawFirmId = lawFirmId; // from current user

        if (lawFirmData.practiceAreas === "Criminal Defense") {
          newData.LawId = "";
          newData.acceptedAttorneyType = "";
        } else if (lawFirmData.practiceAreas === "Immigration") {
          newData.imigrationLawId = "";
          newData.acceptedAttorneyType = "";
        }

        const newId = `${alertId}_copy`;
        await db.collection("QuoteAlert").doc(newId).set(newData);
        console.log("✅ New QuoteAlert copy created:", newId);
      }

    // ✅ Step 4: Update original quote
    await alertRef.update({
        qoutesPrice: quote,
        qoutesDeposite: deposit,
        isAttorneyAlerted: true,
        status: "accept",
        updatedAt: Date.now(),
        LawFirmId: lawFirmId,
        acceptedAttorneyType: lawFirmData.practiceAreas.includes("Criminal Defense") ? "Criminal Defense" : "Immigration",
      });

      Swal.fire({
        icon: "success",
        title: "Submitted",
        text: "Quote has been successfully submitted.",
      });

    // ✅ Refresh alerts
      loadAlerts();

    } catch (error) {
      console.error("Error submitting quote:", error);
      Swal.fire({
        icon: "error",
        title: "Error",
        text: "Failed to submit quote. Please try again.",
      });
    }
  }




    // async function handleSubmit(event, alertId) {
    //   event.preventDefault();

    //   const quote = parseFloat(document.getElementById(`quote-${alertId}`).value);
    //   let deposit = parseFloat(document.getElementById(`deposit-${alertId}`).value);
    //   if (isNaN(deposit)) deposit = 0;

    //   if (isNaN(quote) || isNaN(deposit) || quote <= 0) {
    //     Swal.fire({
    //       icon: "error",
    //       title: "Invalid Input",
    //       text: "Please enter valid positive numbers for quote and deposit",
    //     });
    //     return;
    //   }

    //   try {
    //     const alertRef = db.collection("QuoteAlert").doc(alertId);
    //     const alertDoc = await alertRef.get();
    //     if (!alertDoc.exists) {
    //       Swal.fire("Error", "QuoteAlert not found.", "error");
    //       return;
    //     }
    //     const alertData = alertDoc.data();

    //     // ✅ Step 1: Get LawFirmId and TemplateId
    //     if (!currentUserData || !currentUserData.LawFirmId) {
    //       Swal.fire("Error", "LawFirm ID not found in user data.", "error");
    //       return;
    //     }

    //     const lawFirmId = currentUserData.LawFirmId;
    //     const lawFirmDoc = await db.collection("LawFirm").doc(lawFirmId).get();
    //     if (!lawFirmDoc.exists) {
    //       Swal.fire("Error", "LawFirm document not found.", "error");
    //       return;
    //     }

    //     const lawFirmData = lawFirmDoc.data();
    //     const templateId = lawFirmData.templateId;

    //     // ✅ Step 2: If template_id is missing in QuoteAlert → duplicate-template API
    //     if (!alertData.template_id) {
    //       if (!templateId) {
    //         Swal.fire("Missing Template", "Template not found in LawFirm.", "error");
    //         return;
    //       }

    //       Swal.fire({
    //         title: "Preparing document...",
    //         text: "Please wait while we duplicate template.",
    //         allowOutsideClick: false,
    //         didOpen: () => Swal.showLoading(),
    //       });

    //       const apiUrl = "http://137.184.111.69/test_docusign_apis/index.php/docusign/duplicate-template";
    //       const formData = new URLSearchParams();
    //       formData.append("template_id", templateId);
    //       formData.append("doc_id", lawFirmId);

    //       const response = await fetch(apiUrl, {
    //         method: "POST",
    //         body: formData,
    //       });
    //       const result = await response.json();
    //       Swal.close();

    //       if (!result.success) {
    //         Swal.fire("Error", result.message || "Failed to duplicate template.", "error");
    //         return;
    //       }
    //     }

    //     // ✅ Step 3: If both LawId and imigrationLawId exist → make a copy
    //     if (alertData.LawId && alertData.imigrationLawId) {
    //       const newData = { ...alertData };
    //       newData.qoutesPrice = 0;
    //       newData.qoutesDeposite = 0;
    //       newData.isCopy = true;
    //       newData.status = "request";
    //       newData.LawFirmId = lawFirmId; // from current user

    //       if (lawFirmData.practiceAreas === "Criminal Defense") {
    //         newData.LawId = "";
    //       } else if (lawFirmData.practiceAreas === "Immigration") {
    //         newData.imigrationLawId = "";
    //       }

    //       const newId = `${alertId}_copy`;
    //       await db.collection("QuoteAlert").doc(newId).set(newData);
    //       console.log("✅ New QuoteAlert copy created:", newId);
    //     }

    //     // ✅ Step 4: Update original quote
    //     await alertRef.update({
    //       qoutesPrice: quote,
    //       qoutesDeposite: deposit,
    //       isAttorneyAlerted: true,
    //       status: "accept",
    //       updatedAt: Date.now(),
    //     });

    //     Swal.fire({
    //       icon: "success",
    //       title: "Submitted",
    //       text: "Quote has been successfully submitted.",
    //     });

    //     // ✅ Refresh alerts
    //     loadAlerts();

    //   } catch (error) {
    //     console.error("Error submitting quote:", error);
    //     Swal.fire({
    //       icon: "error",
    //       title: "Error",
    //       text: "Failed to submit quote. Please try again.",
    //     });
    //   }
    // }

    async function fetchArrestDetails(name, alertId) {
      try {
        const upperName = name.toUpperCase();
        let arrest = null;

        // 1️⃣ Try fetching from API
        try {
          const res = await fetch(`https://us-central1-duepro-2cf60.cloudfunctions.net/widgets/searchnew?name=${encodeURIComponent(upperName)}`);
          const result = await res.json();

          if (result.success !== 0 && result.result) {
            arrest = result.result; // API data found
          }
        } catch (apiError) {
          console.warn("API fetch failed:", apiError);
        }

        // 2️⃣ If API fails, try Firestore
        if (!arrest) {
          const alertDoc = await db.collection("QuoteAlert").doc(alertId).get();
          if (alertDoc.exists) {
            const alertData = alertDoc.data();
            if (alertData.offense && Array.isArray(alertData.offense) && alertData.offense.length > 0) {
              arrest = {
                fullName: name,
                offense: alertData.offense
              };
            }
          }
        }

        // 3️⃣ If still no record, show message
        if (!arrest) {
          return Swal.fire("No Record", "No arrest record found.", "info");
        }

        // Format API arrest date if present
        const arrestDate = arrest.arrestDate ? new Date(arrest.arrestDate).toLocaleString() : "N/A";

        Swal.fire({
          title: `Arrest Details`,
          html: `
            <p><strong>Name:</strong> ${arrest.fullName || name}</p>
            <p><strong>Gender:</strong> ${arrest.gender || 'N/A'}</p>
            <p><strong>Age:</strong> ${arrest.age || 'N/A'}</p>
            <p><strong>Address:</strong> ${arrest.address || 'N/A'}</p>
            <p><strong>City/State/Zip:</strong> ${arrest.cityStateZip || 'N/A'}</p>
            <p><strong>Offense:</strong><br />
              ${
                Array.isArray(arrest.offense) && arrest.offense.length
                  ? arrest.offense.map(o =>
                      `${o.chargedesc || 'Unknown'} (${o.severity || '-'}) - ${o.warrantissuedagency || 'Unknown Agency'}`
                    ).join('<br>')
                  : 'N/A'
              }
            </p>
            <p><strong>Detention:</strong> ${arrest.detention || 'N/A'}</p>
            <p><strong>Arrest Date:</strong> ${arrestDate}</p>
          `,
          confirmButtonText: 'Close'
        });

      } catch (err) {
        console.error(err);
        Swal.fire("Error", "Failed to fetch arrest details.", "error");
      }
    }

    function setupSequentialPlayback() {
      document.querySelectorAll('.autoplay-video').forEach(video => {
        video.addEventListener('ended', () => {
          const urls = JSON.parse(video.getAttribute('data-urls') || '[]');
          let currentIndex = parseInt(video.getAttribute('data-index') || '0', 10);

          if (currentIndex + 1 < urls.length) {
            currentIndex += 1;
            const nextUrl = urls[currentIndex];

            video.setAttribute('data-index', currentIndex);
            video.querySelector('source').src = nextUrl;
            video.load();
            video.play();
          }
        });
      });
    }

    async function sendOptOutMessagesToUserAndEmergency(userId) {
      if (!currentUser || !userId) return;

      try {
        const userDoc = await db.collection("Users").doc(userId).get();
        if (!userDoc.exists) return;

        const userData = userDoc.data();
        const emergencyContactId = userData.designatedEmgContact;
        const userName = userData?.Name || "The client";

        const messageText = `${userName}'s designated attorney has opted out from being able to help in this situation. Please request a quote from a different attorney.`;
        const messageText2 = `Your's designated attorney has opted out from being able to help in this situation. Please request a quote from a different attorney.`;
        // Send to user
        await sendOptOutMessageDirect(userId, messageText2);

        // Send to emergency contact
        if (emergencyContactId) {
          await sendOptOutMessageDirect(emergencyContactId, messageText);
        }

      } catch (error) {
        console.error("Error sending opt-out messages to user and emergency:", error);
      }
    }
    async function sendOptOutMessageDirect(receiverId, messageText) {
      if (!currentUser || !receiverId) return;

      try {
        const chatQuery = await db.collection("Chats")
          .where(`participants.${currentUser.uid}`, "==", true)
          .where(`participants.${receiverId}`, "==", true)
          .limit(1)
          .get();

        let chatId;
        if (!chatQuery.empty) {
          chatId = chatQuery.docs[0].id;
        } else {
          const newChat = {
            participants: {
              [currentUser.uid]: true,
              [receiverId]: true
            },
            lastMessage: {},
            createdAt: Date.now()
          };
          const chatRef = await db.collection("Chats").add(newChat);
          chatId = chatRef.id;
        }

        const message = {
          content: messageText,
          fromID: currentUser.uid,
          fromName: currentUserData?.Name || "Attorney",
          toID: receiverId,
          isRead: false,
          messageId: generateId(),
          timestamp: Date.now(),
          type: "system"
        };

        await db.collection("Chats").doc(chatId).collection("Conversations").add(message);
        await db.collection("Chats").doc(chatId).update({ lastMessage: message });

      } catch (error) {
        console.error("Error sending opt-out message:", error);
      }
    }

    async function sendMessageToUser(receiverId, message) {
      try {
        // 🔍 Check if chat already exists
        const chatQuery = await db.collection("Chats")
          .where(`participants.${currentUser.uid}`, "==", true)
          .where(`participants.${receiverId}`, "==", true)
          .limit(1)
          .get();

        let chatId;
        if (!chatQuery.empty) {
          chatId = chatQuery.docs[0].id;
        } else {
          const newChat = {
            participants: {
              [currentUser.uid]: true,
              [receiverId]: true
            },
            lastMessage: {},
            createdAt: Date.now()
          };
          const chatRef = await db.collection("Chats").add(newChat);
          chatId = chatRef.id;
        }

        // 💬 Add message to chat
        await db.collection("Chats").doc(chatId).collection("Conversations").add(message);

        // 🕒 Update last message
        await db.collection("Chats").doc(chatId).update({ lastMessage: message });

      } catch (error) {
        console.error("❌ Error sending message to user:", error);
      }
    }

    function generateId() {
      return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, c => {
        const r = Math.random() * 16 | 0;
        const v = c === 'x' ? r : (r & 0x3 | 0x8);
        return v.toString(16);
      });
    }

    async function hideAlertFromAttorney(alertId) {
      try {
        const confirm = await Swal.fire({
          title: "Permanently Delete?",
          text: "This action cannot be undone.",
          icon: "warning",
          showCancelButton: true,
          confirmButtonText: "Yes, Delete it"
        });

        if (!confirm.isConfirmed) return;

        await db.collection("QuoteAlert").doc(alertId).update({
          isAttorenyHide: true,
          updatedAt: firebase.firestore.FieldValue.serverTimestamp()
        });

        Swal.fire("Deleted", "The alert is now Deleted.", "success");
        loadAlerts();
      } catch (error) {
        console.error("Error hiding alert:", error);
        Swal.fire("Error", "Could not hide alert. Try again later.", "error");
      }
    }

    // async function openDocusignDocument(alertId) {
    //   if (!currentUserData || !currentUserData.LawFirmId) {
    //     Swal.fire("Error", "LawFirm ID not found.", "error");
    //     return;
    //   }

    //   const lawFirmId = currentUserData.LawFirmId;

    //   try {
    //     const lawFirmDoc = await db.collection("LawFirm").doc(lawFirmId).get();

    //     if (!lawFirmDoc.exists) {
    //       Swal.fire("Error", "LawFirm document not found.", "error");
    //       return;
    //     }

    //     const lawFirmData = lawFirmDoc.data();
    //     const templateId = lawFirmData.templateId || lawFirmData.docusignTemplateId;

    //     if (!templateId) {
    //       Swal.fire("Error", "Template ID not found in LawFirm document.", "error");
    //       return;
    //     }

    //     const url = `https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/view?template_id=${templateId}&doc_id=${alertId}`;
    //     // const url = `http://137.184.111.69/test_docusign_apis/index.php/docusign/view?template_id=${templateId}&doc_id=${alertId}`;
    //     window.open(url, "_blank");

    //   } catch (error) {
    //     console.error("Error opening document:", error);
    //     Swal.fire("Error", "Cannot open document.", "error");
    //   }
    // }
    async function openDocusignDocument(alertId) {
  if (!currentUserData || !currentUserData.LawFirmId) {
    Swal.fire("Error", "LawFirm ID not found.", "error");
    return;
  }

  const lawFirmId = currentUserData.LawFirmId;

  try {
    // 1️⃣ Fetch QuoteAlert document
    const alertDoc = await db.collection("QuoteAlert").doc(alertId).get();

    if (!alertDoc.exists) {
      Swal.fire("Error", "QuoteAlert document not found.", "error");
      return;
    }

    const alertData = alertDoc.data();

    // Check if QuoteAlert has its own template ID
    let selectedTemplateId = null;

    if (alertData.template_id) {
      selectedTemplateId = alertData.template_id;
    } else if (alertData.Immegrationtemplate_id) {
      selectedTemplateId = alertData.Immegrationtemplate_id;
    }

    // 2️⃣ If no template found in QuoteAlert → use LawFirm template
    if (!selectedTemplateId) {
      const lawFirmDoc = await db.collection("LawFirm").doc(lawFirmId).get();

      if (!lawFirmDoc.exists) {
        Swal.fire("Error", "LawFirm document not found.", "error");
        return;
      }

      const lawFirmData = lawFirmDoc.data();
      selectedTemplateId =
        lawFirmData.templateId || lawFirmData.docusignTemplateId;

      if (!selectedTemplateId) {
        Swal.fire(
          "Error",
          "No template ID found in QuoteAlert or LawFirm document.",
          "error"
        );
        return;
      }
    }

    // 3️⃣ Open Docusign Document
    const url = `https://buzzwaretechserver.site/duepro_docusign_apis/index.php/docusign/view?template_id=${selectedTemplateId}&doc_id=${alertId}`;
    // const url = `https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/view?template_id=${selectedTemplateId}&doc_id=${alertId}`;

    window.open(url, "_blank");

  } catch (error) {
    console.error("Error opening document:", error);
    Swal.fire("Error", "Cannot open document.", "error");
  }
}


    async function archiveByLawyer(alertId) {
        const result = await Swal.fire({
          title: 'Move to Archive?',
          text: 'You can restore this alert within 30 days of when the alert occurred.',
          icon: 'warning',
          showCancelButton: true,
          confirmButtonText: 'Yes, archive it',
          cancelButtonText: 'Cancel',
          reverseButtons: true
        });

        if (result.isConfirmed) {
          try {
            await db.collection("QuoteAlert").doc(alertId).update({
              isLawArchived: true,
              updatedAt: firebase.firestore.FieldValue.serverTimestamp()
            });

            Swal.fire({
              icon: "success",
              title: "Archived",
              text: "This alert has been archived successfully.",
            });

            loadAlerts(); // reload alert list
          } catch (error) {
            console.error("Error archiving:", error);
            Swal.fire({
              icon: "error",
              title: "Error",
              text: "Failed to archive this alert.",
            });
          }
        }
    }

</script> 



<style>
  .ft7{
    display: -webkit-box;
  -webkit-line-clamp: 2; /* Limit to 2 lines */
  -webkit-box-orient: vertical;
  overflow: hidden;
  text-overflow: ellipsis;
  }
</style>