 <!-- main -->
  <!-- Select2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<style>
  .select2-container--default .select2-selection--multiple {
        border-radius: 15px;
    filter: drop-shadow(0px 5px 7.5px rgba(0, 0, 0, 0.05));
    background-color: #ffffff;
    padding-block: 0.6rem;
  }
  .select2-container--default.select2-container--focus .select2-selection--multiple {
    border-color: #86b7fe;
    outline: 0;
    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
  }

  /* Remove default arrow icon */
  .select2-selection__arrow {
    display: none;
  }

  /* Add Bootstrap-like chevron icon (optional using ::after) */
  .select2-container--default .select2-selection--multiple::after {
    content: '';
    position: absolute;
    top: 50%;
    right: 1rem;
    width: 1rem;
    height: 1rem;
    transform: translateY(-50%);
    background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='none' viewBox='0 0 16 16' stroke='currentColor' stroke-width='2'%3e%3cpath stroke-linecap='round' stroke-linejoin='round' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
    background-repeat: no-repeat;
    background-size: 100% 100%;
    pointer-events: none;
    color: #6c757d;
  }
  .social-icon {
    transition: transform 0.2s ease;
  }
  .social-icon:hover {
    transform: scale(1.2);
  }

  .share-container {
    position: relative;
    display: inline-block;
    z-index:999;
  }

  .share-btn {
    background: #0412CA;
    border: none;
    color: #fff;
    border-radius: 50%;
    width: 50px;
    height: 50px;
    font-size: 20px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: background 0.3s, transform 0.2s;
  }

  .share-btn:hover {
    /*background: #0056b3;*/
    transform: scale(1.05);
  }

  .share-options {
    position: absolute;
    top: 90px;
    left: 14px;
    display: flex;
    flex-direction: column;
    gap: 8px;
    opacity: 0;
    transform: translateY(-10px);
    pointer-events: none;
    transition: all 0.25s ease;
    z-index:999;
        background: #0412ca45;
      padding: 10px;
      border-radius: 50px;
  }

  .share-options.active {
    opacity: 1;
    transform: translateY(0);
    pointer-events: auto;
  }

  .share-icon {
    width: 40px;
    height: 40px;
    border: none;
    border-radius: 50%;
    color: #fff;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: transform 0.2s, opacity 0.3s;
  }

  .share-icon:hover {
    transform: scale(1.1);
  }

  .whatsapp { background: #25d366; }
  .facebook { background: #1877f2; }
  .twitter { background: #000000; }
  .linkedin { background: #0a66c2; }
  .instagram { background: #e4405f; }
  .copy { background: #6c757d; }


</style>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

<main class="">
  <div class="container">
    <div class="my-5">
      <p class="fs-1p" data-i18n="add_law_firm"></p>

      <div class="">
        <div class="mt-3 text-end d-none">
          <button type="button" id="shrBtn" class="btn btn-save btn-width">
            🔗 Share
          </button>
        </div>

        <!-- Floating Share Button -->
        <div class="d-flex justify-content-end my-2">
          <div class="share-container d-flex align-items-center gap-2 flex-column">
            <p class="fs1 mb-0">Share Invite</p>
            <button id="shareBtn" class="share-btn">
              <i class="bi bi-share-fill"></i>
            </button>
            <div class="share-options" id="shareOptions">
              <button class="share-icon whatsapp" data-platform="whatsapp">
                <i class="bi bi-whatsapp"></i>
              </button>
              <button class="share-icon facebook" data-platform="facebook">
                <i class="bi bi-facebook"></i>
              </button>
              <button class="share-icon twitter" data-platform="twitter">
                <i class="bi bi-twitter-x"></i>
              </button>
              <button class="share-icon linkedin" data-platform="linkedin">
                <i class="bi bi-linkedin"></i>
              </button>
              <button class="share-icon instagram" data-platform="instagram">
                <i class="bi bi-instagram"></i>
              </button>
              <button class="share-icon copy" data-platform="copy">
                <i class="bi bi-clipboard"></i>
              </button>
            </div>
          </div>


        </div>
      </div>

      <!-- Bootstrap Icons -->
      <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

    </div>

    <form>
      <div class="row g-3">
        <div class="col-md-6">
          <label for="practice" class="custom-label mb-2" data-i18n="practice_label"></label>
          <input class="form-control custom-input" type="text" id="practice" name="practice" />
        </div>

        <div class="col-md-6">
          <label for="areas" class="custom-label mb-2" data-i18n="practice_areas_label"></label>
          <select class="form-select custom-input" id="areas" name="areas">
            <option value="Criminal Defense" data-i18n="practice_area_criminal_defense"></option>
            <option value="Immigration">Immigration</option>
          </select>
        </div>

        <div class="col-md-6">
          <label for="mobile" class="custom-label mb-2" data-i18n="mobile_label"></label>
          <input class="form-control custom-input" type="tel" id="mobile" name="mobile" />
        </div>

        <div class="col-md-6">
          <label for="address" class="custom-label mb-2" data-i18n="address_label"></label>
          <input class="form-control custom-input" type="text" id="address" name="address" required />
          <input type="hidden" id="userlat" name="userlat" />
          <input type="hidden" id="userlon" name="userlon" />

        </div>

        <div class="col-md-6">
          <label for="counties" class="custom-label mb-2" data-i18n="counties_served_label"></label>
          <select class="form-control custom-input" id="counties" name="counties[]" multiple>
            <option value="Bexar" data-i18n="Bexar">Bexar</option>
            <option value="Cameron" data-i18n="Cameron">Cameron</option>
            <option value="Collin" data-i18n="Collin">Collin</option>
            <option value="Dallas" data-i18n="Dallas">Dallas</option>
            <option value="Denton" data-i18n="Denton">Denton</option>
            <option value="Ellis" data-i18n="Ellis">Ellis</option>
            <option value="El Paso" data-i18n="El Paso">El Paso</option>
            <option value="Fort Bend" data-i18n="Fort Bend">Fort Bend</option>
            <option value="Harris" data-i18n="Harris">Harris</option>
            <option value="Hidalgo" data-i18n="Hidalgo">Hidalgo</option>
            <option value="Hood" data-i18n="Hood">Hood</option>
            <option value="Hunt" data-i18n="Hunt">Hunt</option>
            <option value="Johnson" data-i18n="Johnson">Johnson</option>
            <option value="Kaufman" data-i18n="Kaufman">Kaufman</option>
            <option value="Navarro" data-i18n="Navarro">Navarro</option>
            <option value="Palo Pinto" data-i18n="Palo Pinto">Palo Pinto</option>
            <option value="Parker" data-i18n="Parker">Parker</option>
            <option value="Rockwall" data-i18n="Rockwall">Rockwall</option>
            <option value="Somervell" data-i18n="Somervell">Somervell</option>
            <option value="Tarrant" data-i18n="Tarrant">Tarrant</option>
            <option value="Travis" data-i18n="Travis">Travis</option>
            <option value="Wise" data-i18n="Wise">Wise</option>
          </select>

        </div>

        <div class="col-md-6">
          <label for="email" class="custom-label mb-2" data-i18n="email_label"></label>
          <input class="form-control custom-input" type="email" id="email" name="email" />
        </div>

        <div class="col-md-6">
          <label for="website" class="custom-label mb-2" data-i18n="website_label"></label>
          <input class="form-control custom-input" type="url" id="website" name="website" />
        </div>

        <div class="col-md-6 align-self-end">
          <label class="custom-label mb-2" data-i18n="intro_video_label"></label>
          <label for="videoUpload" class="upload-btn btn w-100" data-i18n="upload_prompt"></label>
          <input type="file" id="videoUpload" name="video" accept="video/*" class="d-none" />
          <div id="videoPreview" class="mt-2 text-muted"></div>
        </div>

        <div class="col-md-6">
          <label class="custom-label mb-2" data-i18n="photo_label"></label>
          <label for="photoUpload" class="upload-btn btn w-100" data-i18n="upload_prompt"></label>
          <input type="file" id="photoUpload" name="photo" accept="image/*" class="d-none" />
          <div id="photoPreview" class="mt-2"></div>
        </div>

        <div class="col-md-6">
          <label class="custom-label mb-2" data-i18n="supporting_document_label"></label>
          <label for="document" class="upload-btn btn w-100" data-i18n="upload_prompt"></label>
          <input type="file" id="document" name="document" class="d-none" />
          <div id="documentPreview" class="mt-2 text-muted"></div>
        </div>

        <div class="col-md-12 mt-4 mb-5">
          <div class="row justify-content-center">
            <!-- <div class="col-md-6">
               <button id="syncBtn" type="button" class="btn btn-save" data-i18n="sync_my_case_label"></button>
             </div> -->
            <div class="col-md-6">
              <button type="submit" class="btn btn-save w-100" data-i18n="save"></button>
            </div>
          </div>
        </div>
      </div>
    </form>
    <script>
      const videoUpload = document.getElementById("videoUpload");
      const photoUpload = document.getElementById("photoUpload");
      const documentUpload = document.getElementById("document");
      const addressInput = document.getElementById("address");

      videoUpload.addEventListener("change", function () {
        const file = this.files[0];
        const preview = document.getElementById("videoPreview");

        if (file) {
          const url = URL.createObjectURL(file);

          preview.innerHTML = `
          
            <p style="margin-top: 10px;">
              <a href="${url}" target="_blank" style="color: #007bff; text-decoration: none;">
                ${file.name}
              </a>
            </p>
          `;
        } else {
          preview.innerHTML = "";
        }
      });

      photoUpload.addEventListener("change", function () {
        const file = this.files[0];
        const preview = document.getElementById("photoPreview");
        if (file) {
          const url = URL.createObjectURL(file);
          preview.innerHTML = `<img src="${url}" alt="Image Preview" class="img-fluid rounded border" style="max-height: 200px;" />`;
        } else {
          preview.innerHTML = "";
        }
      });
    
      documentUpload.addEventListener("click", async function (e) {
        e.preventDefault();

        const address = addressInput.value.trim();
        if (!address) {
          Swal.fire({
            title: "Error",
            text: "Address field is required before uploading supporting document.",
            icon: "warning",
            confirmButtonText: "OK"
          });
          return;
        }

        try {
          const user = firebase.auth().currentUser;
          if (!user) throw new Error("User not logged in.");

          const uid = user.uid;
          const lawRef = db.collection("LawFirm").doc(uid);
          let lawDoc = await lawRef.get();
          let lawData = {};

          if (!lawDoc.exists) {
            // Create law firm document if it doesn't exist
            lawData = {
              address: address,
              userId: uid,
              createdDate: Date.now(),
              templateId: null,
              myCaseLawId: null
            };
            await lawRef.set(lawData);
          } else {
            lawData = lawDoc.data();
            // Update address if changed
            if (lawData.address !== address) {
              await lawRef.update({ address });
            }
          }

          // Fetch templateId and myCaseLawId
          const templateId = lawData.templateId || "";
          
          const myCaseLawId = lawData.myCaseLawId || "null";

          // Open fresh-document API
          // const apiUrl = `https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/fresh-document?doc_id=${uid}&template_id=${templateId}&myCaseLawId=${myCaseLawId}`;
          const apiUrl = `https://buzzwaretechserver.site/duepro_docusign_apis/index.php/docusign/fresh-document?doc_id=${uid}&template_id=${templateId}&myCaseLawId=${myCaseLawId}`;
          window.open(apiUrl, "_blank");

          // Preview the file if already selected
          const file = documentUpload.files[0];
          if (file) {
            documentPreview.innerHTML = `<p>📄 ${file.name}</p>`;
          }

        } catch (err) {
          console.error("Error preparing fresh document:", err);
          Swal.fire("Error", err.message, "error");
        }
      });
      // Optional: Preview file after change (if address already filled)
      documentUpload.addEventListener("change", function () {
        const file = this.files[0];
        if (!addressInput.value.trim()) {
          Swal.fire("Error", "Address field is required first.", "info");
          this.value = ""; // reset file input
          return;
        }
        if (file) {
          documentPreview.innerHTML = `<p>📄 ${file.name}</p>`;
        } else {
          documentPreview.innerHTML = "";
        }
      });  
      
      // document.getElementById("syncBtn").addEventListener("click", function () {
      //   const docId = modelLaw.docId; // make sure this variable exists
      //   if (!docId) {
      //     alert("Document ID missing");
      //     return;
      //   }

      //   const url = `https://buzzwaretechserver.site/mycase_apis/mycase/connect?id=${docId}`;
      //   window.open(url, "_blank"); // open in new tab
      // });
    </script>

    <script>
      const updateBtn = document.getElementById("updateBtn");
      const formInputs = document.querySelectorAll(
        "#profileForm input, #profileForm textarea"
      );

      // -----------ALREADY DISMANTLED EDIT BUTTON CODE --------------
        // const editBtn = document.getElementById("editBtn");
        // editBtn.addEventListener("click", () => {
        //   formInputs.forEach((input) =>
        //     input.removeAttribute("readonly")
        //   );
        //   updateBtn.classList.remove("d-none");
        // });
    </script>
  </div>
</main>
      <!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

      <!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
      <script>
  $(document).ready(function () {
    $('#counties').select2({
     
    });
  });
</script>

      <!-- Google Places API -->
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyB0jx5yCf4vk4I5ridEorfPMqohEhpH1H4&libraries=places"></script>
<script>
  const db = firebase.firestore();
  const storage = firebase.storage();
  let existingLawFirmId = null;
  let autocomplete;
  let userlat = null;
  let userlon = null;

  function initAutocomplete() {
    const input = document.getElementById('address');
    autocomplete = new google.maps.places.Autocomplete(input);
    autocomplete.setFields(['geometry', 'address_components', 'formatted_address']);

    autocomplete.addListener('place_changed', function () {
      const place = autocomplete.getPlace();
      if (!place.geometry) {
        Swal.fire("Invalid Address", "No details found for selected address.", "warning");
        return;
      }
      userlat = place.geometry.location.lat();
      userlon = place.geometry.location.lng();
      document.getElementById('userlat').value = userlat;
      document.getElementById('userlon').value = userlon;
    });
  }

  async function fetchDocumentBase64(templateId) {
    try {
      const url = `https://buzzwaretechserver.site/duepro_docusign_apis/index.php/docusign/downloadTemplatePdf?template_id=${templateId}`;
      // const url = `https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/downloadTemplatePdf?template_id=${templateId}`;
      
      const response = await fetch(url);
      const result = await response.json();

      if (!result.success || !result.pdfBase64) {
        throw new Error(result.message || "Base64 not found!");
      }

      return result.pdfBase64;

    } catch (err) {
      Swal.fire("Error", err.message, "error");
      return null;
    }
  }

  function openBase64PDF(base64Data) {
    // Remove base64 header if exists
    if (base64Data.includes(",")) {
      base64Data = base64Data.split(",")[1];
    }

    // Fix URL-safe base64
    base64Data = base64Data.replace(/-/g, "+").replace(/_/g, "/");

    // Decode
    const byteCharacters = atob(base64Data);

    const byteArray = new Uint8Array(byteCharacters.length);
    for (let i = 0; i < byteCharacters.length; i++) {
      byteArray[i] = byteCharacters.charCodeAt(i);
    }

    // Convert to PDF
    const blob = new Blob([byteArray], { type: "application/pdf" });
    const blobUrl = URL.createObjectURL(blob);

    // Open in new tab
    window.open(blobUrl, "_blank");
  }

  window.onload = initAutocomplete;


  firebase.auth().onAuthStateChanged(async (user) => {
    if (!user) {
      Swal.fire("Error", "You must be logged in.", "error");
      return;
    }

    const userDoc = await db.collection("Users").doc(user.uid).get();
    const userData = userDoc.data();

    if (userData?.LawFirmId) {
      existingLawFirmId = userData.LawFirmId;
      
      const lawFirmDoc = await db.collection("LawFirm").doc(existingLawFirmId).get();

      if (lawFirmDoc.exists) {
        const law = lawFirmDoc.data();

        // Populate form fields
        document.getElementById("practice").value = law.bioPractice || "";
        document.getElementById("areas").value = law.practiceAreas || "";
        document.getElementById("mobile").value = law.phone || "";
        document.getElementById("address").value = law.address || "";
        document.getElementById("email").value = law.email || "";
        document.getElementById("website").value = law.website || "";
        document.getElementById("documentPreview").value = law.templateId || "";

        
        $('#counties').val(law.county || []).trigger('change');

        if (law.userlat && law.userlon) {
          document.getElementById("userlat").value = law.userlat;
          document.getElementById("userlon").value = law.userlon;
          userlat = law.userlat;
          userlon = law.userlon;
        }

        // ✅ Show existing uploaded files if available
        if (law.imageUrl) {
          document.getElementById("photoPreview").innerHTML =
            `<img src="${law.imageUrl}" alt="Uploaded Photo" class="img-fluid rounded border" style="max-height: 200px;" />`;
        }

        if (law.videoUrl) {
          document.getElementById("videoPreview").innerHTML =
            ` <p style="margin-top: 10px;">
        <a href="${law.videoUrl}" target="_blank" class="btn btn-sm btn-outline-primary" >
        View Video
        </a>`;
        }

      if (law.templateId) {
          document.getElementById("documentPreview").innerHTML = `
            <button id="viewDocumentBtn" type="button" class="btn btn-sm btn-outline-primary">
              📄 View Uploaded Document
            </button>
          `;
          

          document.getElementById("viewDocumentBtn").addEventListener("click", async () => {
            Swal.fire({
              title: "Opening Document...",
              text: "Please wait while we load your file.",
              allowOutsideClick: false,
              allowEscapeKey: false,
              didOpen: () => {
                Swal.showLoading();
              }
            });

            const base64 = await fetchDocumentBase64(law.templateId);

            if (base64) {
              Swal.close();
              openBase64PDF(base64);
            } else {
              Swal.fire("Error", "Unable to view document.", "error");
            }
          });
        }
         // Sync with MyCase
    document.getElementById("syncBtn").addEventListener("click", () => {
      const url = `https://buzzwaretechserver.site/mycase_apis/mycase/connect?id=${existingLawFirmId}`;
      window.open(url, "_blank");
    });
      }
    }
  });

  document.querySelector("form").addEventListener("submit", async (e) => {
    e.preventDefault();
      Swal.fire({
    title: "Please wait...",
    text: "Submiting",
    allowOutsideClick: false,
    allowEscapeKey: false,
    didOpen: () => {
      Swal.showLoading();
    }
    });
    const user = firebase.auth().currentUser;
    if (!user) {
      Swal.fire("Error", "You must be logged in.", "error");
      return;
    }

    const form = e.target;
    const address = form.address.value.trim();

    // Fallback geocoding if lat/lon not filled from autocomplete
    if (!userlat || !userlon) {
      try {
        const location = await new Promise((resolve, reject) => {
          const geocoder = new google.maps.Geocoder();
          geocoder.geocode({ address }, (results, status) => {
            if (status === "OK" && results[0]) {
              const loc = results[0].geometry.location;
              resolve({ lat: loc.lat(), lng: loc.lng() });
            } else reject("Geocoding failed: " + status);
          });
        });
        userlat = location.lat;
        userlon = location.lng;
      } catch (geoError) {
        Swal.fire("Location Error", "Failed to retrieve lat/lon from address.", "error");
        return;
      }
    }

    const storageRef = storage.ref();
    const uploadFile = async (inputId, folder) => {
      const fileInput = document.getElementById(inputId);
      if (fileInput.files.length > 0) {
        const file = fileInput.files[0];
        const fileRef = storageRef.child(`lawfirm_uploads/${folder}/${Date.now()}_${file.name}`);
        await fileRef.put(file);
        return await fileRef.getDownloadURL();
      }
      return null;
    };

    const lawFirmData = {
      bioPractice: form.practice.value.trim(),
      practiceAreas: form.areas.value,
      phone: form.mobile.value.trim(),
      address: address,
      email: form.email.value.trim(),
      website: form.website.value.trim(),
      county: $('#counties').val(),
      userlat,
      userlon,
      userId: user.uid,
      updatedDate: Date.now()
    };

    try {
      const photoUrl = await uploadFile("photoUpload", "photos");
      const videoUrl = await uploadFile("videoUpload", "videos");
      const docUrl = await uploadFile("document", "documents");

      if (photoUrl) lawFirmData.imageUrl = photoUrl;
      if (videoUrl) lawFirmData.videoUrl = videoUrl;
      if (docUrl) lawFirmData.docUrl = docUrl;

      let lawFirmRef;

    if (existingLawFirmId) {
    // ✅ Update existing law firm
    await db.collection("LawFirm").doc(existingLawFirmId).update(lawFirmData);
    lawFirmRef = { id: existingLawFirmId };
    } else {
      // ✅ Create a new law firm document using the current user's UID as the document ID
      lawFirmData.createdDate = Date.now();
      await db.collection("LawFirm").doc(user.uid).set(lawFirmData);
      await db.collection("Users").doc(user.uid).update({ LawFirmId: user.uid });
      lawFirmRef = { id: user.uid }; // ✅ so later code uses the UID as the law firm id
    }



    if (docUrl) {
      try {
        // 1️⃣ Get DocuSign token
        // const response = await fetch(
        //   "https://sugarfest.online/docusign_apis/index.php/docusign/token",
        //   { headers: { Accept: "application/json" } }
        // );
        const response = await fetch(
          // "http://137.184.111.69/test_docusign_apis/index.php/docusign/token",
          "https://buzzwaretechserver.site/duepro_docusign_apis/index.php/docusign/token",
          // "https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/token",
          { headers: { Accept: "application/json" } }
        );

        if (!response.ok) throw new Error("Failed to get token");
        const data = await response.json();

        if (!data.success) {
          console.warn("Token API responded without success:", data);
          return;
        }

        // ✅ Save only templateId in Firestore
        
        
        // ✅ Keep access token only in memory
        const accessToken = data.access_token;

        // 2️⃣ Convert the just-uploaded document to base64
        const file = document.getElementById("document").files[0];
        if (!file) throw new Error("No document selected");
        const fileBase64 = await new Promise((resolve, reject) => {
          const reader = new FileReader();
          reader.onload = () => {
            // strip the "data:application/pdf;base64," prefix
            const base64String = reader.result.split(",")[1];
            resolve(base64String);
          };
          reader.onerror = reject;
          reader.readAsDataURL(file);
        });


        // 3️⃣ Call create-draft-template API
        const formData = new FormData();
        formData.append("attorneyId", user.uid);   // ✅ Firebase user ID
        formData.append("document", fileBase64);   // ✅ Base64 encoded PDF
        // formData.append("returnUrl", "https://sugarfest.online/docusign_apis/index.php");
        formData.append("returnUrl", window.location.href);

        formData.append("otherData", `${lawFirmData}`);

        const draftResponse = await fetch(
          "https://buzzwaretechserver.site/duepro_docusign_apis/index.php/docusign/create-draft-template",
          // "https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/create-draft-template",
          // "http://137.184.111.69/test_docusign_apis/index.php/docusign/create-draft-template",
          //  "https://sugarfest.online/docusign_apis/index.php/docusign/create-draft-template",
          {
            method: "POST",
            headers: {
              Authorization: `Bearer ${accessToken}`, // ✅ token used only in header
              // ❗ Do NOT manually set Content-Type with FormData
            },
            body: formData,
          }
        );
        if (!draftResponse.ok) throw new Error("Failed to create draft template");

        const draftData = await draftResponse.json();
        console.log("✅ DocuSign draft template created:", draftData);
        await db.collection("LawFirm").doc(lawFirmRef.id).update({
          templateId: draftData.data.templateId, // 👈 store only templateId, not the token

        });
        // 5️⃣ 👉 Open the sender view so the attorney can prepare fields
        const senderViewUrl = draftData.data.senderViewUrl;
      
        if (senderViewUrl) {
          // open in a new tab
    //   window.location.href=senderViewUrl
        } else {
          console.warn("senderViewUrl not returned by API");
        }


      } catch (apiErr) {
        console.error("❌ DocuSign API error:", apiErr);
        
      }
    }

            Swal.fire("Success", "Law firm information saved successfully.", "success");


    } catch (error) {
      console.error("Error saving law firm:", error);
      Swal.fire("Error", error.message, "error");
    }
  });
    
  document.getElementById("shrBtn").addEventListener("click", async () => {
    try {
      const user = firebase.auth().currentUser;
      if (!user) {
        Swal.fire("Error", "You must be logged in to share your link.", "error");
        return;
      }

      // ✅ Use LawFirm ID or fallback to user UID
      const lawFirmId = existingLawFirmId || user.uid;
      const shareUrl = `https://duepro.com/userlogins?attorneyId=${lawFirmId}`;
      const message = `Check out my attorney profile on DuePro: ${shareUrl}`;

      // ✅ Copy link to clipboard initially
      await navigator.clipboard.writeText(shareUrl);

      // ✅ SweetAlert with copy + brand icons
      Swal.fire({
        title: "Share Your Attorney Link",
        html: `
          <p class="mb-3">Your link has been copied to clipboard!</p>
          <div class="d-flex justify-content-center mb-3">
            <button id="copyLinkBtn" class="btn btn-dark btn-sm">
              <i class="bi bi-clipboard"></i>
            </button>
          </div>
          <div class="d-flex flex-wrap justify-content-center gap-3">
            <a href="https://wa.me/?text=${encodeURIComponent(message)}" target="_blank" class="social-icon" style="color: #25D366;">
              <i class="bi bi-whatsapp" style="font-size: 28px;"></i>
            </a>
            <a href="https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(shareUrl)}" target="_blank" class="social-icon" style="color: #1877F2;">
              <i class="bi bi-facebook" style="font-size: 28px;"></i>
            </a>
            <a href="https://twitter.com/intent/tweet?text=${encodeURIComponent(message)}" target="_blank" class="social-icon" style="color: #000000;">
              <i class="bi bi-twitter-x" style="font-size: 28px;"></i>
            </a>
            <a href="https://www.linkedin.com/sharing/share-offsite/?url=${encodeURIComponent(shareUrl)}" target="_blank" class="social-icon" style="color: #0A66C2;">
              <i class="bi bi-linkedin" style="font-size: 28px;"></i>
            </a>
            <a href="https://www.instagram.com/" target="_blank" class="social-icon" style="color: #E4405F;">
              <i class="bi bi-instagram" style="font-size: 28px;"></i>
            </a>
          </div>
        `,
        showConfirmButton: true,
        confirmButtonText: "Close",
        icon: "success",
        didOpen: () => {
          // Add copy functionality to the button inside SweetAlert
          document.getElementById("copyLinkBtn").addEventListener("click", async () => {
            try {
              await navigator.clipboard.writeText(shareUrl);
              const btn = document.getElementById("copyLinkBtn");
              btn.innerHTML = '<i class="bi bi-check2"></i>'; // show checkmark
              btn.classList.replace("btn-dark", "btn-success");
              setTimeout(() => {
                btn.innerHTML = '<i class="bi bi-clipboard"></i>';
                btn.classList.replace("btn-success", "btn-dark");
              }, 1500);
            } catch {
              Swal.fire("Error", "Failed to copy the link.", "error");
            }
          });
        },
      });

    } catch (err) {
      console.error("Error sharing link:", err);
      Swal.fire("Error", "Failed to copy or share the link.", "error");
    }
  }); 
    
  document.addEventListener("DOMContentLoaded", () => {
    const shareBtn = document.getElementById("shareBtn");
    const shareOptions = document.getElementById("shareOptions");
    const shareIcons = document.querySelectorAll(".share-icon");

    // ✅ Toggle open/close on click
    shareBtn.addEventListener("click", (e) => {
      e.stopPropagation();
      shareOptions.classList.toggle("active");
    });

    // ✅ Close when clicking outside
    document.addEventListener("click", (e) => {
      if (!shareBtn.contains(e.target) && !shareOptions.contains(e.target)) {
        shareOptions.classList.remove("active");
      }
    });

    // ✅ Dynamic share actions
    shareIcons.forEach(icon => {
      icon.addEventListener("click", async (e) => {
        e.stopPropagation();
        const platform = icon.getAttribute("data-platform");
        const user = firebase.auth().currentUser;

        if (!user) {
          Swal.fire("Error", "You must be logged in to share your link.", "error");
          return;
        }

        const lawFirmId = window.existingLawFirmId || user.uid;
        const shareUrl = `https://duepro.com/userlogins?attorneyId=${lawFirmId}`;
        const message = `Check out my attorney profile on DuePro: ${shareUrl}`;

        switch (platform) {
          case "whatsapp":
            window.open(`https://wa.me/?text=${encodeURIComponent(message)}`, "_blank");
            break;
          case "facebook":
            window.open(`https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(shareUrl)}`, "_blank");
            break;
          case "twitter":
            window.open(`https://twitter.com/intent/tweet?text=${encodeURIComponent(message)}`, "_blank");
            break;
          case "linkedin":
            window.open(`https://www.linkedin.com/sharing/share-offsite/?url=${encodeURIComponent(shareUrl)}`, "_blank");
            break;
          case "instagram":
            window.open(`https://www.instagram.com/`, "_blank");
            break;
          case "copy":
            await navigator.clipboard.writeText(shareUrl);
            Swal.fire("Copied!", "Link copied to clipboard.", "success");
            break;
        }

        // auto-close after selection
        shareOptions.classList.remove("active");
      });
    });
  });
</script>





