 <style>
  #loader {
    display: none;
  }
</style>
 <main class="">
        <div class="container-fluid ">
            
            <div class="mb-5 mt-2">
                  <div class="row">
              <div class="col-md-12 my-2">
                <form
                  class="d-flex position-relative mt-2 mt-md-0"
                  role="search"
                >
                  <input
                    class="form-control me-2 search w-100 bg-white pe-4"
                    type="search"
                    placeholder="Search"
                    aria-label="Search"
                    style="width: 350px"
                  />
                  <img
                    src="../assets/images/icons/searchicon.png"
                    alt=""
                    width="15px"
                    height="15px"
                    class="searchIcon"
                  />
                </form>
              </div>
            </div>


<div id="loader" class="text-center my-5">
  <div class="spinner-border text-primary" role="status">
    <span class="visually-hidden">Loading...</span>
  </div>
</div>
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="row g-2" id="clientCards">
                 
            </div>
                </div>
            </div>

        </div>

    </main>
 <script>
 // Initialize Firebase
  firebase.initializeApp(firebaseConfig);
  const db = firebase.firestore();
  const auth = firebase.auth();
const loader = document.getElementById("loader");

loader.style.display = "block"; // show loader before fetch
  // DOM elements
  const container = document.querySelector(".row.g-2");
  const searchInput = document.querySelector(".search");

  let allClients = [];

  auth.onAuthStateChanged(async (user) => {
  if (user) {
    const currentUserId = user.uid;
    const usersRef = db.collection("Users");
    loader.style.display = "block"; // show loader before fetch

    // Run both queries separately
    const [criminalSnap, immigrationSnap] = await Promise.all([
      usersRef.where("designatedLawyerId", "==", currentUserId).get(),
      usersRef.where("designatedImmigrationLawyerId", "==", currentUserId).get()
    ]);

    // Combine both query results
    const combinedDocs = [...criminalSnap.docs, ...immigrationSnap.docs];

    if (combinedDocs.length === 0) {
      loader.style.display = "none";
      container.innerHTML = `
        <div class="col-12">
          <div class="alert alert-warning">
            <p class="text-center mt-4 text-warning fw-bolder">
              No clients assigned to you yet.
            </p>
          </div>
        </div>`;
      return;
    }

    // Remove duplicates (if a user appears in both queries)
    const uniqueUsers = new Map();
    combinedDocs.forEach(doc => uniqueUsers.set(doc.id, { id: doc.id, ...doc.data() }));

    const allClients = Array.from(uniqueUsers.values());

    renderClients(allClients);
    loader.style.display = "none";
  } else {
    loader.style.display = "none";
    container.innerHTML = `
      <div class="col-12 alert alert-success">
        <p class="text-center mt-4 text-danger">
          Please login to see your clients.
        </p>
      </div>`;
  }
});


  function renderClients(clients) {
    
    container.innerHTML = ""; // clear previous
    clients.forEach(client => {
        console.log(client)
      container.innerHTML += `
        <div class="col-md-12">
          <div class="card quote-card">
            <div class="card-body">
              <div class="d-flex gap-2">
                <img class="img-q" src="${client.imageUrl && client.imageUrl.trim() !== '' ? client.imageUrl : '../assets/images/th.jpeg'}" alt="">

                <div>
                  <p class="fo-1 mb-0">${client.Name || "No Name"}</p>
                  <p class="fo-2 mb-0">${client.email || "username"}</p>
                </div>
              </div>
              <div class="row g-2 mt-2">
                <div class="col-md-6">
                  <div class="d-flex gap-2 align-items-center">
                    <img src="../assets/images/ph.png" alt="" width="30px">
                    <p class="fo-3 mb-0">${client.userPhone || "N/A"}</p>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="d-flex gap-2 align-items-center">
                    <img src="../assets/images/locn.png" alt="" width="30px">
                    <p class="fo-3 mb-0">${client.address || "Not Provided"}</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>`;
    });
  }

  // 🔍 Search
  searchInput.addEventListener("input", (e) => {
    const term = e.target.value.toLowerCase();
    const filtered = allClients.filter(client =>
      (client.Name && client.Name.toLowerCase().includes(term)) ||
      (client.email && client.email.toLowerCase().includes(term)) ||
      (client.phone && client.phone.includes(term))
    );
    renderClients(filtered);
  });
</script>
