   <style>
   .swvl-loader {
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background: rgba(255,255,255,0.8);
  display: flex;
  justify-content: center;
  align-items: center;
  z-index: 9999;
}

.swvl-loader .spinner {
  width: 60px;
  height: 60px;
  border: 6px solid rgb(231, 80, 60);
  border-top: 6px solid transparent;
  border-radius: 50%;
  animation: spin 0.9s linear infinite;
}

@keyframes spin {
  0% { transform: rotate(0deg); }
  100% { transform: rotate(360deg); }
}

   </style>
   <!-- main -->
      <main class="">
        <div class="container-fluid">
        <div id="cameraLoader" class="swvl-loader d-none">
          <div class="spinner"></div>
        </div>


                  <div class="my-5">
                    <p class="f6" data-i18n="legal_emergency" id="title">Legal emergency?</p>
        <p class="f7 mt-4" data-i18n="tap_to_record" id="Message">
          Tap the button to activate alerts and begin recording.
        </p>

          
            <div class="position-relative">
              <button
                class="btn mt-5 ripple-triple-btn d-block m-auto"
                id="rpl-butn" 
              >
                <img
                  src="../assets/images/rp.png"
                  alt=""
                  id="rippleeffect"
                  width="150px"
                />
              </button>
              <span class="ripple ripple1"></span>
              <span class="ripple ripple2"></span>
              <span class="ripple ripple3"></span>
            </div>

            <!-- <button class="btn mt-4 f6 d-block mx-auto">Cancel</button> -->
          </div>
        </div>
      </main>

<script>
  firebase.auth().onAuthStateChanged(async (user) => {
    const titleEl = document.getElementById("title");
    const messageEl = document.getElementById("Message");
    const recordBtn = document.getElementById("rpl-butn");
    const recordImg = document.getElementById("rippleeffect");

    if (!user) {
      titleEl.textContent = "Login Required";
      messageEl.textContent = "You must be logged in to access this page.";
      recordBtn.disabled = true;
      return;
    }

    try {
      const db = firebase.firestore();
      const userRef = db.collection("Users").doc(user.uid);
      const userDoc = await userRef.get();

      if (!userDoc.exists) {
        titleEl.textContent = "User Not Found";
        messageEl.textContent = "User data not found.";
        recordBtn.disabled = true;
        return;
      }

      const data = userDoc.data();


      // Check 2: Profile completeness & emergency contact
      const isProfileIncomplete = !data.Name || !data.pinCode;
      const emergencySnapshot = await userRef.collection("EmergencyContacts").get();
      const hasNoEmergencyContacts = emergencySnapshot.empty;

      if (isProfileIncomplete || hasNoEmergencyContacts) {
        titleEl.textContent = "Personal Info Required";
        messageEl.textContent = "Please add your personal details and add emergency contact to continue.";
        recordBtn.disabled = true;
        document.querySelectorAll(".ripple").forEach(el => el.classList.add("d-none"));
        recordImg.src = "../assets/images/rp3.png";
        return;
      }

      // ✅ All checks passed
      titleEl.textContent = "Legal emergency?";
      messageEl.textContent = "Tap the button to activate alerts and begin recording.";
      recordBtn.disabled = false;
      recordImg.src = "../assets/images/rp.png";

    } catch (error) {
      console.error("Error validating user:", error);
      titleEl.textContent = "Error";
      messageEl.textContent = "An error occurred. Please try again.";
      recordBtn.disabled = true;
    }
  });
</script>


<script>


let isRecording = false;
let stream;
let mediaRecorder;
let chunks = [];
let alertDocId = null;
let chunkCounter = 0;
let stopTimeout;
let stoppedEarly = false;


const db = firebase.firestore();
const storage = firebase.storage();

async function check(){
   const userDoc = await  db.collection("Users").doc(user.uid).get();
  const userData = userDoc.data();
console.log("ss",userData)
  // 🔹 Check the Firestore fields
  if (userData.isNewUser === true || userData.userInitalSetup === "new") {
      // ✅ Redirect to site/boarding
      window.location.href = "<?= base_url('site/getstarted'); ?>";
      
  }
    // ➡️ If either field is missing
    // if (
    //     userData.isNewUser === undefined ||
    //     userData.userInitalSetup === undefined
    // ) {
    //     window.location.href = "<?= base_url('site/getstarted'); ?>";
    // }

}
check()
firebase.auth().onAuthStateChanged(async (user) => {
  if (!user) return;

  const userDoc = await db.collection("Users").doc(user.uid).get();
  const userData = userDoc.data();

  // 🔹 Check the Firestore fields
  if (userData.isNewUser === true && userData.userInitalSetup === "processing") {
      // ✅ Redirect to site/boarding
      window.location.href = "<?= base_url('site/boarding'); ?>";
      return; // ⛔ stop further JS
  }

  // 🔹 Normal emergency button logic
  document.getElementById("rpl-butn").addEventListener("click", async () => {
    if (isRecording) {
      askForPin(user.uid, userData.pinCode);
    } else {
      loader.classList.remove("d-none"); // Show spinner
      isRecording = true;
      await startEmergency(user.uid, userData);
      changeButtonToEmergency();
    }
  });
});


const startEmergency = async (uid, userData) => {

  const name = userData.Name;
  const lawyerId = userData.designatedLawyerId || "";
  console.log("lawyerId", lawyerId);
  const imigrationLawId = userData.designatedImmigrationLawyerId || "";
  console.log("imigrationLawId", imigrationLawId);

  
  const docRef = db.collection("QuoteAlert").doc();
  alertDocId = docRef.id;
  chunkCounter = 0;

  // 🔍 Step 1: Fetch arrest details
  let offense = "N/A";
  let detainedPlace = "N/A";

  try {
     const upperName = name.toUpperCase();
    const res = await fetch(`https://us-central1-duepro-2cf60.cloudfunctions.net/widgets/searchnew?name=${encodeURIComponent(upperName)}`);
    const result = await res.json();

    if (result.success !== 0 && result.result) {
      const arrest = result.result;
      // offense = arrest.offense || "N/A";
          offense = Array.isArray(arrest.offense) ? arrest.offense : []
      detainedPlace = arrest.detention || "N/A";
    }
    else{
       offense = [];  // ✅ Empty array if API doesn't return data
    detainedPlace = "N/A";
    }
  } catch (err) {
     offense = [];     
    console.error("Arrest API error:", err);
  }

  // 🧾 Step 2: Create alert with fetched info
  const alertData = {
    LawId: lawyerId,
    imigrationLawId: imigrationLawId,
    userId: uid,
    isOptOut: false,
    isImmigrationOptOut: false,
    userLat: userData.userlat,
    userLng: userData.userlon,
    country: "Pakistan",
    county: "Islamabad",
    city: "Islamabad",
    createdDate: Date.now(),
    isActive: true,
    isFalse: false,
    paidStatus: "0",
    qoutesDeposite: 0,
    qoutesPrice: 0,
    status: "request",
    videoUrl: "",
    videoImageUrl: "",
    title: `${name}`,
    videoUrls: [],
    isUserArchived: false,
    // isAttorneyAlerted :true,
    isAttorneyAlerted: !!lawyerId, // ✅ sets true if lawyerId is non-empty
    isNewHire:false,
    isLawArchived:false,
    offense,
    detainedPlace
  };

  await docRef.set(alertData);
   loader.classList.remove("d-none"); // Show spinner
  await startRecordingChunks();

  window.onbeforeunload = () => "Recording in progress. Do not leave or refresh.";
  stopTimeout = setTimeout(stopRecordingSession, 45 * 60 * 1000);
};

const loader = document.getElementById("cameraLoader");
const startRecordingChunks = async () => {
  try {
     loader.classList.remove("d-none"); // Show spinner

    stream = await navigator.mediaDevices.getUserMedia({ video: true, audio: true });
     loader.classList.add("d-none"); // Hide spinner once ready
    mediaRecorder = new MediaRecorder(stream);

    mediaRecorder.ondataavailable = async (e) => {
      if (e.data.size > 0) chunks.push(e.data);
    };

  
    mediaRecorder.onstop = async () => {
  if (!chunks.length) return;

  const blob = new Blob(chunks, { type: 'video/webm' });
  const fileName = `video_chunk_${++chunkCounter}_${Date.now()}.webm`;
  const ref = storage.ref(`Videos/${alertDocId}/${fileName}`);

  // Upload in background
  ref.put(blob).then(async () => {
    const url = await ref.getDownloadURL();

    await db.collection("QuoteAlert").doc(alertDocId).update({
      videoUrls: firebase.firestore.FieldValue.arrayUnion(url),
      ...(chunkCounter === 1 && { videoUrl: url })
    });
  });

  chunks = [];

  if (isRecording) {
    mediaRecorder.start();
    setTimeout(() => mediaRecorder.stop(), 20000);
  }
};


    mediaRecorder.start();
    setTimeout(() => mediaRecorder.stop(), 20000);
  } catch (err) {
      loader.classList.add("d-none"); // Hide spinner on error
    console.error("Error starting recording:", err);
    Swal.fire("Error", "Camera/mic permission error", "error");
    isRecording = false;
    resetButton();
  }
};


const stopRecordingSession = async () => {
  isRecording = false;
  clearTimeout(stopTimeout);
  resetButton(); // 👈 Reset button immediately

  let isSaving = true;

  // 🔒 Block navigation/refresh
  window.onbeforeunload = (e) => {
    if (isSaving) {
      e.preventDefault();
      e.returnValue = "Video is saving. Please wait...";
    }
  };

  if (mediaRecorder && mediaRecorder.state === "recording") {
    mediaRecorder.stop();
    await new Promise(resolve => {
      mediaRecorder.onstop = resolve;
    });
  }

  if (chunks.length) {
    const blob = new Blob(chunks, { type: 'video/webm' });
    const fileName = `video_chunk_${++chunkCounter}_${Date.now()}.webm`;
    const ref = storage.ref(`Videos/${alertDocId}/${fileName}`);
    await ref.put(blob);
    const url = await ref.getDownloadURL();

    await db.collection("QuoteAlert").doc(alertDocId).update({
      videoUrls: firebase.firestore.FieldValue.arrayUnion(url),
      ...(chunkCounter === 1 && { videoUrl: url }),
    });

    chunks = [];
  }

  if (stream) stream.getTracks().forEach(t => t.stop());

  // await db.collection("QuoteAlert").doc(alertDocId).update({
  //   isActive: true,
  //   status: "request"
  // });
  await db.collection("QuoteAlert").doc(alertDocId).update({
  isActive: true,
  status: "request",
  isFalse: stoppedEarly === true
});

  isSaving = false; // ✅ Allow navigation again
  window.onbeforeunload = null;
stoppedEarly = false;
  // Swal.fire("Complete", "Emergency session finished and video saved.", "success");
};




const askForPin = async (uid, pin) => {
  const { value: input } = await Swal.fire({
    title: "Enter 4-digit PIN",
    input: "password",
    inputAttributes: { maxlength: 4, inputmode: "numeric" },
    showCancelButton: true,
    inputValidator: val => (!val || val.length !== 4 ? "Enter a valid 4-digit PIN" : null),
  });
  if (input === pin) {
    stoppedEarly = true; // ✅ Mark that we stopped early
    await stopRecordingSession();
    // Swal.fire("Stopped", "Emergency cancelled.", "success");
  } else if (input) {
    Swal.fire("Wrong PIN", "Try again.", "error");
  }
};

const changeButtonToEmergency = () => {
  document.getElementById("rippleeffect").src = "../assets/images/rp2.png";
  document.querySelectorAll(".ripple").forEach(el => el.style.background = "rgba(182, 47, 47, 0.4)");
};

const resetButton = () => {
  document.getElementById("rippleeffect").src = "../assets/images/rp.png";
  document.querySelectorAll(".ripple").forEach(el => el.style.background = "rgba(7, 20, 145, 0.4)");
};

</script>
