  <main class="">
        <div class="container-fluid ">
            
            <div class="mb-5 mt-2">
                  <div class="row">
              <div class="col-md-12 my-2">
                <form
                  class="d-flex position-relative mt-2 mt-md-0"
                  role="search"
                >
                  <input
                    class="form-control me-2 search w-100 bg-white pe-4"
                    type="search"
                    placeholder="Search"
                    aria-label="Search"
                    style="width: 350px"
                  />
                  <img
                    src="../assets/images/icons/searchicon.png"
                    alt=""
                    width="15px"
                    height="15px"
                    class="searchIcon"
                  />
                </form>
              </div>
            </div>


          <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="row g-2" id="clientCards"></div>
            </div>
          </div>

        </div>

    </main>
 <script>
  // Initialize Firebase
  firebase.initializeApp(firebaseConfig);
  const db = firebase.firestore();
  const auth = firebase.auth();

  // DOM elements
  const container = document.querySelector(".row.g-2");
  const searchInput = document.querySelector(".search");

  let allClients = [];

  auth.onAuthStateChanged(async (user) => {
    if (!user) {
      container.innerHTML = `<div class="col-12 alert alert-success"><p class="text-center mt-4 text-danger">Please login to see your clients.</p></div>`;
      return;
    }

    const currentUserId = user.uid;
    const userDoc = await db.collection("Users").doc(currentUserId).get();

    const userData = userDoc.data();
    const userFriends = userData?.userFriends || {};

    // Get friend IDs where value is "added"
    const friendIds = Object.keys(userFriends).filter(
      (id) => userFriends[id] === "added"
    );

    if (friendIds.length === 0) {
      container.innerHTML = `<div class="col-12 alert alert-success"><p class="text-center mt-4">No friends added yet.</p></div>`;
      return;
    }

    // Fetch all friend user docs
    const friendPromises = friendIds.map((id) =>
      db.collection("Users").doc(id).get()
    );
    const friendDocs = await Promise.all(friendPromises);

    allClients = friendDocs.map((doc) => ({ id: doc.id, ...doc.data() }));

    renderClients(allClients);
  });

  function renderClients(clients) {
    container.innerHTML = ""; // Clear previous
  clients.forEach((client) => {

    // ❌ Prevent user from selecting himself
    if (client.id === auth.currentUser.uid) return;

    container.innerHTML += `
      <div class="col-md-12">
        <div class="card quote-card">
          <div class="card-body">
            <div class="d-flex gap-2">
              ${client.imageUrl && client.imageUrl.trim() !== "" ? 
                `<img class="img-q" src="${client.imageUrl}" alt="">` : ""}

              <div>
                <p class="fo-1 mb-0">${client.Name || "No Name"}</p>
                <p class="fo-2 mb-0">${client.email || "email"}</p>
              </div>
            </div>
            <div class="row g-2 mt-2">
              <div class="col-md-6">
                <div class="d-flex gap-2 align-items-center">
                    <img src="../assets/images/ph.png" alt="" width="30px">
                  <p class="fo-3 mb-0">${client.userPhone || "N/A"}</p>
                </div>
              </div>
              <div class="col-md-6">
                <div class="d-flex gap-2 align-items-center">
                    <img src="../assets/images/locn.png" alt="" width="30px">
                  <p class="fo-3 mb-0">${client.address || "Not Provided"}</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>`;
  });
}

  // 🔍 Search functionality
  searchInput.addEventListener("input", (e) => {
    const term = e.target.value.toLowerCase();
    const filtered = allClients.filter((client) =>
      (client.Name && client.Name.toLowerCase().includes(term)) ||
      (client.email && client.email.toLowerCase().includes(term)) ||
      (client.userPhone && client.userPhone.includes(term))
    );
    renderClients(filtered);
  });
</script>
