<style>
  #loader {
    display: none;
  }
  .img-atr2{
    width:100%;
    max-height:240px !important;
  }
  .card-height-attor{
    height:260px !important
  }
  .find-attorney-title{
      /* font-size:24px; */
      font-weight:600;
      margin-bottom:20px;
  }
  .btn{
      display:flex;
      align-items:center;
      justify-content:center;
  }
  .contact {
    color: inherit;
  }
  .contact:hover {
    color: #0d6efd;
  }

  .attorney-img-col {
  background-color: #f8f9fa;
  display: flex;
  justify-content: center;
  align-items: center;
  border-radius: 10px;
  }

  .attorney-img {
    max-height: 200px;
    height: 100%;
    vertical-align: middle;
    max-width: 200px;
    width: 100%;
    border-radius: 10px;
    transition: all 0.3s ease-in-out;
  }

  @media (max-width: 768px) {
    .attorney-img-col {
      background-color: transparent !important;
    }

    .attorney-img {
      max-height: 160px;
      border-radius: 50%;
      width: 160px;
      height: 160px;
      object-fit: cover;
    }
  }

</style>
<main class="mb-5">
  <div class="container my-5">
    <div class="row g-3" id="attorneyList">
      <h3 class="find-attorney-title f6">Find an Attorney</h3>
      <div class="d-flex justify-content-center">
        <ul class="nav nav-tabs  n-tabs gap-2" id="lawTabs" role="tablist">
          <li class="nav-item" role="presentation">
            <button class="nav-link active" id="criminal-tab" data-bs-toggle="tab" data-bs-target="#criminal"
              type="button" role="tab">Criminal Defense</button>
          </li>
          <li class="nav-item" role="presentation">
            <button class="nav-link" id="immigration-tab" data-bs-toggle="tab" data-bs-target="#immigration"
              type="button" role="tab">Immigration</button>
          </li>
        </ul>
      </div> 
      <div id="loader" class="text-center my-5">
        <div class="spinner-border text-primary" role="status">
          <span class="visually-hidden">Loading...</span>
        </div>
      </div>
      <div class="tab-content mt-3" id="lawTabsContent">
        <div class="tab-pane fade show active" id="criminal" role="tabpanel" aria-labelledby="criminal-tab">
          <div class="row justify-content-center">
            <div class="col-md-12 my-2">
              <div class="row g-2" id="criminalCards"></div>
            </div>
          </div>
        </div>
        <div class="tab-pane fade" id="immigration" role="tabpanel" aria-labelledby="immigration-tab">
          <div class="row justify-content-center">
            <div class="col-md-12 my-2">
              <div class="row g-2" id="immigrationCards"></div>
            </div>
          </div>
        </div>
      </div>
      <!-- Request Quote button -->
      <div class="col-md-12 my-3">
      </div>
    </div>
</main>

<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCkDJWMAbK59HWDyHOb50Fajk-XpmonOZw&libraries=places"></script>
<script>
  const loader = document.getElementById("loader");
    loader.style.display = "block"; // show loader before fetch

  const getQueryParam = (name) => new URLSearchParams(window.location.search).get(name);
  const quoteIdFromURL = getQueryParam("id");
  const criminalContainer = document.getElementById("criminalCards");
  const immigrationContainer = document.getElementById("immigrationCards");

  // --- Reverse geocode lat/lon to county using OpenStreetMap ---
  
async function getCountyFromLatLng(lat, lng) {
  return new Promise((resolve, reject) => {
    const geocoder = new google.maps.Geocoder();
    const latlng = { lat: parseFloat(lat), lng: parseFloat(lng) };

    geocoder.geocode({ location: latlng }, (results, status) => {
      if (status === "OK") {
        if (!results || results.length === 0) {
          resolve("Unknown Country");
          return;
        }

        let country = null;

        // Loop all results and inside loop all address components
        for (let result of results) {
          if (!result.address_components) continue;

          for (let comp of result.address_components) {
            if (comp.types.includes("country")) {
              country = comp.long_name;
              break;
            }
          }

          if (country) break; // stop early if found
        }

        resolve(country || "Unknown Country");
      } else {
        console.error("Geocoder failed:", status);
        reject("Geocoder failed: " + status);
      }
    });
  });
}

  firebase.auth().onAuthStateChanged(async (user) => {
    if (!user) return;

    const db = firebase.firestore();
    loader.style.display = "block";

    try {
      // --- Fetch quote + law firms + current user ---
      const [quoteSnap, lawFirmsSnap, userSnap] = await Promise.all([
        db.collection("QuoteAlert").doc(quoteIdFromURL).get(),
        db.collection("LawFirm").get(),
        db.collection("Users").doc(user.uid).get(),
      ]);

      if (!quoteSnap.exists) {
        loader.style.display = "none";
          return Swal.fire({
            icon: "error",
            title: "Quote not found!",
            text: "The quote ID in the URL is invalid.",
          });
      }

      const quoteData = { id: quoteSnap.id, ...quoteSnap.data() };
      const currentUserData = userSnap.data();


       // --- Get user county ---
    const userLat = parseFloat(currentUserData.userlat);
    const userLon = parseFloat(currentUserData.userlon);
    console.log("userLat",userLat);
    console.log("userLon",userLon);
    
    const userCounty = await getCountyFromLatLng(userLat, userLon);

    console.log("User county:", userCounty);
      // --- Filter out user's own firms ---
      const firms = lawFirmsSnap.docs
        .map(doc => ({ id: doc.id, ...doc.data() }))
        .filter(firm => firm.userId !== user.uid);

      // --- Fetch all firm users from Users collection ---
      const uniqueUserIds = [...new Set(firms.map(f => f.userId))];
      const userDocs = await Promise.all(
          uniqueUserIds.map(async (id) => {
            const userSnap = await db.collection("Users").doc(id).get();
            return userSnap.exists ? { id, ...userSnap.data() } : null;
        })
      );

        // --- Create a lookup map for fast access ---
      const userMap = {};
      for (const u of userDocs.filter(Boolean)) {
        userMap[u.id] = u;
      }

        // --- Separate attorneys by type ---
      const criminalFirms = [];
      const immigrationFirms = [];

      for (const firm of firms) {
        const u = userMap[firm.userId] || {};
        const attorney = {
          userId: firm.userId,
          name: u.Name || "N/A", // <-- fetched from Users collection
          imageUrl: firm.imageUrl || "../assets/images/placeholder.png",
          address: firm.address || "Unknown",
          phone: firm.phone || "+0000000000",
          email: firm.email || "example@email.com",
          isBest: firm.isBest || false,
          practiceAreas: firm.practiceAreas?.toLowerCase() || "general",
        };

        if (attorney.practiceAreas.includes("criminal")) criminalFirms.push(attorney);
        else if (attorney.practiceAreas.includes("immigration")) immigrationFirms.push(attorney);
      }

      // --- Render lists ---
      loader.style.display = "none";

      // --- Fetch all existing quote requests by this user ---
      const userQuotesSnap = await db.collection("QuoteAlert")
        .where("userId", "==", user.uid)
        .get();

      const alreadyRequestedLawIds = [];
      userQuotesSnap.forEach(doc => {
        const q = doc.data();
        if (q.LawId) alreadyRequestedLawIds.push(q.LawId);
        if (q.imigrationLawId) alreadyRequestedLawIds.push(q.imigrationLawId);
      });

       // --- Sort attorneys: designated → same county → rest ---
    function sortAttorneys(arr) {
      return arr.sort((a, b) => {
        const aDesignated = currentUserData.designatedLawyerId === a.userId || currentUserData.designatedImmigrationLawyerId === a.userId;
        const bDesignated = currentUserData.designatedLawyerId === b.userId || currentUserData.designatedImmigrationLawyerId === b.userId;
        if (aDesignated && !bDesignated) return -1;
        if (!aDesignated && bDesignated) return 1;

        const aSameCounty = a.county && a.county === userCounty;
        const bSameCounty = b.county && b.county === userCounty;
        if (aSameCounty && !bSameCounty) return -1;
        if (!aSameCounty && bSameCounty) return 1;

        return 0;
      });
    }

      renderAttorneyList(criminalFirms, criminalContainer, quoteData, currentUserData, alreadyRequestedLawIds);
      renderAttorneyList(immigrationFirms, immigrationContainer, quoteData, currentUserData, alreadyRequestedLawIds);


    document.body.addEventListener("click", async (e) => {
      if (!e.target.classList.contains("btn-request-quote")) return;

      const lawId = e.target.dataset.lawid;
      if (!quoteData?.id) {
        return Swal.fire({
          icon: "error",
          title: "Quote not loaded",
          text: "Cannot proceed without quote data.",
        });
      }

      try {
        Swal.fire({
          title: "Submitting...",
          allowOutsideClick: false,
          didOpen: () => Swal.showLoading(),
        });

        const isImmigration = e.target.closest("#immigrationCards") !== null;

        // ✅ Prepare new cloned quote
        const newQuote = {
          ...quoteData,
          LawId: isImmigration ? "" : lawId,
          imigrationLawId: isImmigration ? lawId : "",
          isLawArchived: false,
          isNewHire: false,
          isUserArchived: false,
          paidStatus: "0",
          qoutesDeposite: 0,
          qoutesPrice: 0,
          status: "request",
          isOptOut: false,
          isImmigrationOptOut: false,
          createdDate: Date.now(),
          updatedAt: firebase.firestore.FieldValue.serverTimestamp(),
        };

        delete newQuote.id; // remove old doc ID before adding

        // ✅ Add new QuoteAlert document
        await db.collection("QuoteAlert").add(newQuote);

        sessionStorage.removeItem("selectedAlert");

        // ✅ Update UI instantly without updating user designated lawyer
        e.target.textContent = "Requested";
        e.target.disabled = true;
        e.target.classList.add("card-requested");

        const redirectUrl = "<?= base_url('site/activityUser') ?>";
        const redirectTimer = setTimeout(() => (window.location.href = redirectUrl), 6000);

        Swal.fire({
          icon: "success",
          title: "New quote request created!",
          text: `Your ${isImmigration ? "immigration" : "criminal"} attorney has been linked.`,
          confirmButtonText: "OK",
          timer: 6000,
          timerProgressBar: true,
          willClose: () => clearTimeout(redirectTimer),
        });

      } catch (err) {
        console.error("Error creating quote:", err);
        Swal.fire({
          icon: "error",
          title: "Error!",
          text: "Could not create a new quote. Please try again.",
        });
      }
    });

    } catch (err) {
      console.error("Error loading data:", err);
      Swal.fire("Error", "Failed to load data.", "error");
    } finally {
      loader.style.display = "none";
    }
  });


  // --- Render attorney cards ---
  function renderAttorneyList(attorneys, container, quoteData, currentUserData, alreadyRequestedLawIds) {
    container.innerHTML = "";
    if (!attorneys.length) {
      container.innerHTML = `<div class="text-center my-3"><p>No attorneys found.</p></div>`;
      return;
    }

        // ✅ Sort attorneys: designated attorneys on top
    attorneys.sort((a, b) => {
      const isADesignated =
        (currentUserData?.designatedLawyerId === a.userId) ||
        (currentUserData?.designatedImmigrationLawyerId === a.userId);
      const isBDesignated =
        (currentUserData?.designatedLawyerId === b.userId) ||
        (currentUserData?.designatedImmigrationLawyerId === b.userId);

      if (isADesignated && !isBDesignated) return -1;
      if (!isADesignated && isBDesignated) return 1;
      return 0; // preserve relative order if both same
    });


    attorneys.forEach(attorney => {

      let label = "Request Quote";
      let isAlreadyRequested = false;
      let buttonClass = "";

      // ✅ Case 1: User already has this attorney designated
      if (
        (currentUserData?.designatedLawyerId && currentUserData.designatedLawyerId === attorney.userId) ||
        (currentUserData?.designatedImmigrationLawyerId && currentUserData.designatedImmigrationLawyerId === attorney.userId)
      ) {
        label = "Auto Quote Requested";
        isAlreadyRequested = true;
        buttonClass = "card-disable";
      }

      // ✅ Case 2: User already has quote alerts for this attorney
      else if (alreadyRequestedLawIds.includes(attorney.userId)) {
        label = "Requested";
        isAlreadyRequested = true;
        buttonClass = "card-requested";
      }


      const card = document.createElement("div");
      card.className = "col-md-10 col-lg-11 mx-auto my-3";
      card.innerHTML = `
        <div class="card shadow-sm border-0 rounded-4 overflow-hidden">
          <div class="row justify-content-center">
            <div class="col-md-4 text-center attorney-img-col p-3">
              <img src="${attorney.imageUrl}" alt="${attorney.name}" class="attorney-img img-fluid rounded-3" style="object-fit: cover;">
            </div>
            <div class="col-md-8 p-4 card-wrapper">
              <div class="d-flex justify-content-between align-items-end">
                <div>
                  <h5 class="fw-bold mb-1">${attorney.name}</h5>
                  <p class="text-muted small mb-2 text-capitalize">${attorney.practiceAreas}</p>
                </div>
                <div>${attorney.isBest ? `<span class="badge bg-warning text-dark mt-2 px-3 py-1">⭐ Best Attorney</span>` : ""}</div>
              </div>
              <div class="mt-2 mb-3">
                <div class="d-flex align-items-center mb-1 text-muted small">
                  <i class="fas fa-phone me-2 text-primary"></i><a class="contact" href="tel:${attorney.phone}">${attorney.phone}</a>
                </div>
                <div class="d-flex align-items-center mb-1 text-muted small">
                  <i class="fas fa-envelope me-2 text-primary"></i><a class="contact" href="mailto:${attorney.email}">${attorney.email}</a>
                </div>
                <div class="d-flex align-items-center text-muted small">
                  <i class="fas fa-map-marker-alt me-2 text-primary"></i>${attorney.address}
                </div>
              </div>
              <div class="d-flex justify-content-end gap-2">
                <a href="<?= base_url('site/details') ?>?lawId=${attorney.userId}&quoteId=${quoteData.id}" class="btn btn-outline-primary px-4 py-1">View Details</a>
                <button class="btn btn-primary px-4 py-1 btn-request-quote ${buttonClass}" 
                  data-lawid="${attorney.userId}" ${isAlreadyRequested ? "disabled" : ""}> ${label}
                </button>
               
              </div>
            </div>
          </div>
        </div>
      `;
      container.appendChild(card);
    });
    
  }

</script>

<style>
   .card-wrapper {
    position: relative;
  }
  .card-disable{
    pointer-events: none;
    opacity: 0.6;
    position: absolute;
    top: 18px;
    background-color: #808080 !important;
  }
  .card-requested{
    pointer-events: none;
    opacity: 0.6;
    position: static;
    background-color: #808080 !important;
  }
</style>