

      <main>
          <div class="container py-5">
    <div class="row justify-content-center">
      <div class="col-md-6">

        <div class="card shadow-sm border-0 text-center">
          <div class="card-body">
            <h4 class="mb-3"><i class="fas fa-wallet text-primary"></i> Your Wallet Balance</h4>
            <h2 class="display-5" id="walletBalance">$0</h2>
          </div>
        </div>

      </div>
    </div>
   

  </div>
  <div class="container mt-2 mb-5 ">
  <h5 class="mb-3">Transaction History</h5>
  <div id="transactionHistoryContainer"></div>
</div>


      </main>

      <script>
            const auth = firebase.auth();
    const db = firebase.firestore();

    auth.onAuthStateChanged(async (user) => {
      if (!user) {
        document.getElementById('walletBalance').textContent = "Not logged in";
        return;
      }

      try {
        const userDoc = await db.collection("Users").doc(user.uid).get();
        const userData = userDoc.data();
        const balance = userData.lawWallet || 0;

        document.getElementById('walletBalance').textContent = `$${balance}`;
      } catch (error) {
        console.error("Error fetching balance:", error);
        document.getElementById('walletBalance').textContent = "Error loading balance";
      }
    });
 

      </script>
   

<script>
//   const auth = firebase.auth();
//   const db = firebase.firestore();/

  function formatDate(timestamp) {
    const date = new Date(timestamp);
    return date.toLocaleDateString('en-US', {
      year: 'numeric',
      month: 'short',
      day: 'numeric'
    });
  }

  function createTransactionCard({ clientName, offense, quote, wallet, date }) {
    const isPositive = wallet >= 0;
    const amountColor = isPositive ? 'text-success' : 'text-danger';
    const amountSign = isPositive ? '+' : '-';

    return `
      <div class="card mb-3 shadow-sm">
        <div class="card-body">
          <div class="d-flex justify-content-between">
            <div>
              <strong>Client:</strong> ${clientName}<br/>
              <small class="text-muted">${date}</small>
            </div>
            <div class="text-end">
              <strong>DuePro Fee(s):</strong> $${offense}
            </div>
          </div>
          <div class="mt-3">
            <strong>Amount Paid:</strong> $${quote} (Full Payment)
          </div>
          <div class="mt-2 fs-5 fw-bold ${amountColor}">
            Payout Amount: ${amountSign} $${Math.abs(wallet)}
          </div>
        </div>
      </div>
    `;
  }

  auth.onAuthStateChanged(async (user) => {
    if (!user) return;

    const container = document.getElementById('transactionHistoryContainer');
    container.innerHTML = '';

    try {
      const transactionsSnapshot = await db.collection("TransactionHistory")
        .where("userId", "==", user.uid)
        .where("type", "==", "transaction")
        .get();

      for (const doc of transactionsSnapshot.docs) {
        const data = doc.data();
        const quoteId = data.quoteId;
        const offense = data.offensePrice || 0;
        const quote = data.pricePaid || 0;
        const wallet = data.priceInWallet || 0;
        const date = formatDate(data.timestamp);

        // Get QuoteAlert document
        const quoteDoc = await db.collection("QuoteAlert").doc(quoteId).get();
        const quoteData = quoteDoc.data();

        // Get userId of the client from QuoteAlert
        const clientUserId = quoteData?.userId;
        let clientName = 'Unknown';

        if (clientUserId) {
          const clientDoc = await db.collection("Users").doc(clientUserId).get();
          const clientData = clientDoc.data();
          clientName = clientData?.Name || 'Unknown';
        }

        container.innerHTML += createTransactionCard({
          clientName,
          offense,
          quote,
          wallet,
          date
        });
      }
    } catch (error) {
      console.error("Error loading transactions:", error);
      container.innerHTML = `<div class="alert alert-danger">Failed to load transactions.</div>`;
    }
  });
</script>


