<!-- Main -->
<main class="my-5">
  <div class="container-fluid">
    <div class="my-5 min-h-80">
    <p class="fs-4 fw-semibold text-center mb-4" data-i18n="login_security">Login & Security</p>

      <!-- Login Information Card -->
    <div class="card mb-4">
  <div class="card-body">
    <h5 class="section-title mb-3" data-i18n="login_info">Login Information</h5>

    
    <div class="mb-3">
     <label class="form-label" data-i18n="email_address">Email Address</label>
      <input id="userEmail" type="email" class="form-control" disabled />
   <a href="#" class="btn btn-save mt-2" data-bs-toggle="modal" data-bs-target="#changeEmailModal" data-i18n="change_email"  >Change email</a>
    </div>

    <div class="mb-3">
      <label class="form-label" data-i18n="phone_number">Phone Number</label>
      <input id="userPhone" type="tel" class="form-control" disabled />
   <a href="#" class="btn btn-save mt-2" data-i18n="change_phone" data-bs-toggle="modal" data-bs-target="#changePhoneModal">Change phone number</a>
    </div>
  </div>
  <!-- Change Email Modal -->
<div class="modal fade" id="changeEmailModal" tabindex="-1" aria-labelledby="changeEmailLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="changeEmailForm">
        <div class="modal-header">
          <h5 class="modal-title"  data-i18n="change_email">Change Email</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <input type="email" id="newEmail" class="form-control" placeholder="Enter new email" required />
        </div>
        <div class="modal-footer">
       <button type="submit" class="btn btn-save" data-i18n="update_email">Update Email</button>

        </div>
      </form>
    </div>
  </div>
</div>

<!-- Change Phone Number Modal -->
<div class="modal fade" id="changePhoneModal" tabindex="-1" aria-labelledby="changePhoneLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="changePhoneForm">
        <div class="modal-header">
          <h5 class="modal-title"  data-i18n="email_address">Change Phone Number</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <input type="tel" id="newPhone" class="form-control" placeholder="Enter new phone number" required />
        </div>
        <div class="modal-footer">
          <!-- <button type="submit" class="btn btn-save">Update Phone</button> 
           -->
          <button type="submit" class="btn btn-save" data-i18n="update_phone">Update Phone</button>

        </div>
      </form>
    </div>
  </div>
</div>

</div>


      <!-- Change Password Card -->
      <div class="card mb-4">
        <div class="card-body">
          <h5 class="section-title mb-3" data-i18n="change_password">Change Password</h5>
          <form id="changePasswordForm">
            <div class="mb-3">
              <label for="oldPassword" class="form-label" data-i18n="old_password">Old Password</label>
              <input type="password" class="form-control" id="oldPassword" placeholder="Enter old password" required />
            </div>
            <div class="mb-3">
              <label for="newPassword" class="form-label" data-i18n="new_password">New Password</label>
              <input type="password" class="form-control" id="newPassword" placeholder="Enter new password" required />
            </div>
            <div class="mb-3">
              <label for="confirmPassword" class="form-label" data-i18n="confirm_password">Confirm Password</label>
              <input type="password" class="form-control" id="confirmPassword" placeholder="Confirm new password" required />
            </div>
            <button type="submit" class="btn btn-save mt-2" data-i18n="change_password">Change Password</button>
          </form>
        </div>
      </div>

      <!-- Deactivate Account Card -->
      <div class="card mb-4">
        <div class="card-body">
          <h5 class="section-title mb-3" data-i18n="deactivate_account">Deactivate Account</h5>
          <button class="btn btn-danger mt-2" data-bs-toggle="modal" data-bs-target="#deactivateModal" data-i18n="deactivate">
            Deactivate
          </button>
        </div>
      </div>

      <!-- Deactivate Modal -->
      <div class="modal fade" id="deactivateModal" tabindex="-1" aria-labelledby="deactivateModalLabel" aria-hidden="true">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="deactivateModalLabel" data-i18n="are_you_sure">Are you sure?</h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <p data-i18n="deactivate_confirm">Do you really want to deactivate your account?</p>
            
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" data-i18n="cancel">Cancel</button>
            <button type="button" class="btn btn-danger" id="confirmDeactivate" data-i18n="deactivate">Deactivate</button>

            </div>
          </div>
        </div>
      </div>

    </div>
  </div>
  <!-- Confirm Password Modal -->
<div class="modal fade" id="confirmPasswordModal" tabindex="-1" aria-labelledby="confirmPasswordModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="confirmPasswordForm">
        <div class="modal-header">
          <h5 class="modal-title" id="confirmPasswordModalLabel">Confirm Your Password</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <div class="mb-3">
            <label for="confirmPasswordInput" class="form-label" data-i18n="current_password">Current Password</label>
            <input type="password" class="form-control" id="confirmPasswordInput" required />
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-save" data-i18n="continue">Continue</button>
        </div>
      </form>
    </div>
  </div>
</div>

</main>
<script>
firebase.auth().onAuthStateChanged(async (user) => {
  if (user) {
    // Show Firebase Auth email
    document.getElementById("userEmail").value = user.email || "";

    try {
      const doc = await firebase.firestore().collection("Users").doc(user.uid).get();
      if (doc.exists) {
        const data = doc.data();

        // Show phone number from Firestore (or Firebase Auth if used there)
        document.getElementById("userPhone").value = data.userPhone || "";
      }
    } catch (err) {
      console.error("Error fetching user info:", err);
      Swal.fire("Error", "Failed to load user data.", "error");
    }
  } else {
    window.location.href = "<?= base_url('/') ?>";
  }
});
</script>


<script>
  firebase.auth().onAuthStateChanged((user) => {
    if (user) {
      // Now we can safely set up the submit handler
      document
        .getElementById("changePasswordForm")
        .addEventListener("submit", async function (e) {
          e.preventDefault();

          const oldPassword = document.getElementById("oldPassword").value;
          const newPassword = document.getElementById("newPassword").value;
          const confirmPassword = document.getElementById("confirmPassword").value;

          if (newPassword !== confirmPassword) {
            Swal.fire("Error", "New passwords do not match.", "error");
            return;
          }
console.log( user.email,  oldPassword)
          const credential = firebase.auth.EmailAuthProvider.credential(
            user.email,
            oldPassword
          );

          try {
            // Reauthenticate
            await user.reauthenticateWithCredential(credential);

            // Then update password
            await user.updatePassword(newPassword);

            Swal.fire("Success", "Password changed successfully.", "success");

            // Clear form
            document.getElementById("changePasswordForm").reset();
          } catch (error) {
            console.error("Password Change Error:", error);
            Swal.fire("Error", error.message, "error");
          }
        });
    } else {
      Swal.fire("Not Logged In", "Please log in to change your password.", "warning");
      window.location.href = "<?= base_url('/') ?>";
    }
  });
</script>
<script>
firebase.auth().onAuthStateChanged((user) => {
  if (!user) return;

let pendingNewEmail = ""; // Store new email temporarily

document.getElementById("changeEmailForm").addEventListener("submit", (e) => {
  e.preventDefault();
  pendingNewEmail = document.getElementById("newEmail").value;

  // Show password modal
  const modal = new bootstrap.Modal(document.getElementById("confirmPasswordModal"));
  modal.show();
});

document.getElementById("confirmPasswordForm").addEventListener("submit", async (e) => {
  e.preventDefault();

  const user = firebase.auth().currentUser;
  const currentPassword = document.getElementById("confirmPasswordInput").value;

  if (!user || !pendingNewEmail) {
    Swal.fire("Error", "Something went wrong. Please try again.", "error");
    return;
  }

  try {
    const credential = firebase.auth.EmailAuthProvider.credential(user.email, currentPassword);
    await user.reauthenticateWithCredential(credential);

    await user.verifyBeforeUpdateEmail(pendingNewEmail);

    Swal.fire(
      "Verification Sent",
      "A verification email has been sent to the new address. Please check your inbox.",
      "info"
    );

    bootstrap.Modal.getInstance(document.getElementById("confirmPasswordModal")).hide();
    bootstrap.Modal.getInstance(document.getElementById("changeEmailModal")).hide();
    document.getElementById("changeEmailForm").reset();
    pendingNewEmail = "";

  } catch (error) {
    console.error("Reauthentication error:", error);
    Swal.fire("Error", error.message, "error");
  }
});

  // Change Phone
  document.getElementById("changePhoneForm").addEventListener("submit", async (e) => {
    e.preventDefault();
    const newPhone = document.getElementById("newPhone").value;

    try {
      await firebase.firestore().collection("Users").doc(user.uid).update({ userPhone: newPhone });

      Swal.fire("Success", "Phone number updated successfully.", "success");
      document.getElementById("userPhone").value = newPhone;
      document.getElementById("changePhoneForm").reset();
      bootstrap.Modal.getInstance(document.getElementById("changePhoneModal")).hide();
    } catch (error) {
      console.error("Phone update error:", error);
      Swal.fire("Error", error.message, "error");
    }
  });
});
</script>

<script>
  const db = firebase.firestore();
  const auth = firebase.auth();

  document.getElementById("confirmDeactivate").addEventListener("click", async () => {
    const user = auth.currentUser;
    if (!user) return;

    try {
      // Set isDeactive to true
      await db.collection("Users").doc(user.uid).update({ isDeactive: true });

      // Sign the user out
      await auth.signOut();

      Swal.fire("Deactivated", "Your account has been deactivated.", "success").then(() => {
        window.location.href = "/login"; // Redirect to login page
      });
    } catch (error) {
      console.error("Error deactivating:", error);
      Swal.fire("Error", "Could not deactivate account.", "error");
    }
  });
</script>
