<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Due Pro</title>
    <link
      rel="shortcut icon"
      type="image/x-icon"
      href="../assets/images/Fav.png"
    />
    <!-- bootstrap style link -->
    <link
      href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css"
      rel="stylesheet"
    />
    <!-- font-awesome cdn -->
    <link
      rel="stylesheet"
      href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"
    />
    <!-- custom css -->
  <link rel="stylesheet" href="<?= base_url('assets/css/style.css'); ?>" />

    <style>
      .main90vh {
        overflow: hidden;
        min-height: 82vh;
      }
      .nav-b{
        background:#0412CA
      }
      .navT{
        color:#fff !important;
      }
      .ddm{
          background:#0412CA;
          color:#fff !important;
      }
      .ddm li a{
          color:#fff !important;
      }
      .ddm li a:hover{
        background:transparent
      }
    </style>
  </head>

  <body class="">
    <!-- navbar -->
    <nav class="navbar navbar-expand-lg nav-b">
      <div class="container-fluid z-2">
        <a class="navbar-brand" href="#">
          <img src="<?= base_url(); ?>/assets/images/logo.png" alt="" />
        </a>
        <button
          class="navbar-toggler"
          type="button"
          data-bs-toggle="collapse"
          data-bs-target="#navbarSupportedContent"
          aria-controls="navbarSupportedContent"
          aria-expanded="false"
          aria-label="Toggle navigation"
        >
          <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarSupportedContent">
          <ul class="navbar-nav mb-2 mb-lg-0 ms-auto">
            <li class="nav-item">
              <a class="nav-link navT" href="<?= base_url('site/company'); ?>">Company</a>
            </li>
            <li class="nav-item">
            <div class="dropdown ">
  <a class="nav-link navT dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
   Platform
  </a>

  <ul class="dropdown-menu ddm">
    <li><a class="dropdown-item" href="<?= base_url('site/individuals'); ?>">Individuals</a></li>
    <li><a class="dropdown-item" href="<?= base_url('site/lawfirm'); ?>">Law Firms</a></li>
  
  </ul>
</div>
            </li>
            <li class="nav-item">

              <a class="nav-link navT" aria-current="page" href="<?= base_url('/'); ?>"
                >Login</a
              >
            </li>
           
          </ul>
        </div>
      </div>
    </nav>
    <!-- nav bar end -->

    <!-- main -->
    <main class="container-fluid main main90vh">
      <div class="container h-100" style="z-index: 2">
        <div class="row h-100">
          <div
            class="col-md-4 my-2 align-self-center z-2 h-100 d-flex justify-content-center align-items-center"
          >
            <div>
              <h1 class="he1">
                Welcome to <br />
                DuePro
              </h1>
              <!-- <p class="f1">
                Please enter your username and password to access your account.
                If you don’t have an account yet, you can sign up easily to get
                started.
              </p> -->
            </div>
          </div>
          <div
            class="col-md-8 my-2 align-self-center z-2 h-100 d-flex justify-content-center align-items-center"
          >
            <div>
              <div class="card cardAuth">
                <form class="card-body" id="signupForm">
                  <p class="f2">Join DuePro</p>
                  <p class="f3">
                    Bring forward the start of your legal representation.
                  </p>
                  <!-- <input
                    class="form-control my-2 formInput"
                    type="text"
                    name="email"
                    id="email"
                    placeholder="Email"
                  />
                  <input
                    class="form-control my-2 formInput"
                    type="password"
                    name="password"
                    id="password"
                    placeholder="Password"
                  /> -->

                  <!-- Email Input -->
                  <input
                    class="form-control my-2 formInput"
                    type="text"
                    name="email"
                    id="email"
                    placeholder="Email"
                  />

                  <!-- Password Input (hidden initially) -->
                  <input
                    class="form-control my-2 formInput d-none"
                    type="password"
                    name="password"
                    id="password"
                    placeholder="Password"
                  />

                  <!-- Button Row -->
                  <div class="d-flex justify-content-between my-2">
                    <button id="backBtn" class="btn btnLog px-4 d-none">
                      Back
                    </button>
                    <button id="nextBtn" class="btn btnLog px-4">Next</button>
                  </div>
                  <div id="pstr" class="d-none">
                    <div
                      class="d-flex align-items-center gap-1"
                      id="rule-length"
                    >
                      <img src="../assets/images/iconcross.png" alt="" />
                      <p class="f4 textDanger m-0">At least 8 characters</p>
                    </div>
                    <div
                      class="d-flex align-items-center gap-1"
                      id="rule-lowercase"
                    >
                      <img src="../assets/images/iconcross.png" alt="" />
                      <p class="f4 textDanger m-0">
                        Contains one lowercase letter
                      </p>
                    </div>
                    <div
                      class="d-flex align-items-center gap-1"
                      id="rule-uppercase"
                    >
                      <img src="../assets/images/iconcross.png" alt="" />
                      <p class="f4 textDanger m-0">
                        Contains one Uppercase letter
                      </p>
                    </div>
                    <div
                      class="d-flex align-items-center gap-1"
                      id="rule-number"
                    >
                      <img src="../assets/images/iconcross.png" alt="" />
                      <p class="f4 textDanger m-0">Contains one number</p>
                    </div>
                    <div
                      class="d-flex align-items-center gap-1"
                      id="rule-special"
                    >
                      <img src="../assets/images/iconcross.png" alt="" />
                      <p class="f4 textDanger m-0">One special character</p>
                    </div>
                  </div>

                  <!-- <div class="d-flex justify-content-center my-2">
                    <a href="./index.html" class="btn btnLog px-5 py-2"
                      >Sign Up</a
                    >
                  </div> -->
                  <p class="fw-bold text-center mb-2">or</p>
                  <!-- <button
                    class="btn btn-outline-dark d-flex align-items-center justify-content-center gap-2 px-4 py-2 mx-auto border"
                    style="min-width: 250px" id="googleLoginBtn"
                  >
                    <img
                      src="https://developers.google.com/identity/images/g-logo.png"
                      alt="Google logo"
                      width="20"
                      height="20"
                    />
                    Continue with Google
                  </button> -->
                  <button
  id="googleLoginBtn"
  type="button"
  class="btn btn-outline-dark d-flex align-items-center justify-content-center gap-2 px-4 py-2 mx-auto border"
  style="min-width: 250px"
>
  <img
    src="https://developers.google.com/identity/images/g-logo.png"
    alt="Google logo"
    width="20"
    height="20"
  />
  Continue with Google
</button>

                </form>
              </div>
              <div class="d-flex justify-content-center">
                <a class="my-2">
                  <p class="forgText">Terms & Conditions</p>
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </main>
    <!-- main end -->
    <!-- footer  -->
    <footer class="footer p-2 d-flex justify-content-center align-items-center">
      <p class="text-center m-0 fs2 text-white">
        Copyright © 2024-2025 DuePro. All rights reserved.
      </p>
    </footer>
    <!-- footer end -->
<!--swal   sweetalert2 -->
 <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- bootstrap scripts   -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"></script>
   <!-- jquery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>


  <!-- Firebase Scripts -->
 <!-- Firebase Scripts (Compat Versions) -->
  <!-- <script src="https://www.gstatic.com/firebasejs/9.6.1/firebase-app-compat.js"></script>
  <script src="https://www.gstatic.com/firebasejs/9.6.1/firebase-auth-compat.js"></script>
  <script src="https://www.gstatic.com/firebasejs/9.6.1/firebase-database-compat.js"></script> -->
  <!-- Firebase SDKs (add in this order) -->
<script src="https://www.gstatic.com/firebasejs/9.6.1/firebase-app-compat.js"></script>
<script src="https://www.gstatic.com/firebasejs/9.6.1/firebase-auth-compat.js"></script>
<script src="https://www.gstatic.com/firebasejs/9.6.1/firebase-firestore-compat.js"></script>




<script>
  // ✅ Correct Firebase Config ----> real one
   const firebaseConfig = {
     apiKey: "AIzaSyCkDJWMAbK59HWDyHOb50Fajk-XpmonOZw",
     authDomain: "duepro-2cf60.firebaseapp.com",
     projectId: "duepro-2cf60",
     storageBucket: "duepro-2cf60.appspot.com", // ✅ corrected
     messagingSenderId: "626020023304",
     appId: "1:626020023304:web:618ae729d21b9ec4daa5bd",
     measurementId: "G-D38W7PD70R"
   };


  // for testing
  //   const firebaseConfig = {
  //    apiKey: "AIzaSyDg1_W33W26alDtLkpmhHoGvVjZYOIJibo",
  //    authDomain: "freeme-6e63a.firebaseapp.com",
  //    projectId: "freeme-6e63a",
  //    storageBucket: "freeme-6e63a.firebasestorage.app",
  //    messagingSenderId: "721532160627",
  //    appId: "1:721532160627:web:8827f39f6a6d9211527806",
  //    measurementId: "G-F5H1XMFWMS"
  // };
  firebase.initializeApp(firebaseConfig);
   const db = firebase.firestore(); // ✅ Initialize Firestore
</script>




<script>
  const emailInput = document.getElementById("email");
  const passwordInput = document.getElementById("password");
  const nextBtn = document.getElementById("nextBtn");
  const backBtn = document.getElementById("backBtn");

  // const db = firebase.firestore();

  const rules = {
    length: (pwd) => pwd.length >= 8,
    lowercase: (pwd) => /[a-z]/.test(pwd),
    uppercase: (pwd) => /[A-Z]/.test(pwd),
    number: (pwd) => /[0-9]/.test(pwd),
    special: (pwd) => /[!@#$%^&*(),.?":{}|<>]/.test(pwd),
  };

  function isValidPassword(pwd) {
    return Object.values(rules).every((validate) => validate(pwd));
  }

  function isValidEmail(email) {
    return /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email);
  }

  nextBtn.addEventListener("click", async (event) => {
    event.preventDefault();
    const email = emailInput.value.trim();
    const password = passwordInput.value;

    if (!passwordInput.classList.contains("d-block")) {
      if (!email || !isValidEmail(email)) {
        Swal.fire("Invalid Email", "Please enter a valid email address.", "warning");
        return;
      }
      emailInput.classList.add("d-none");
      passwordInput.classList.remove("d-none", "d-block");
      passwordInput.classList.add("d-block");
      backBtn.classList.remove("d-none");
      nextBtn.textContent = "Sign Up";
    } else {
      if (!password || !isValidPassword(password)) {
        Swal.fire("Weak Password", "Please enter a strong password that meets all the rules.", "error");
        return;
      }

      try {
          Swal.fire({
  title: "Please wait...",
  text: "signing Up",
  allowOutsideClick: false,
  allowEscapeKey: false,
  didOpen: () => {
    Swal.showLoading();
  }
});
        const userCredential = await firebase.auth().createUserWithEmailAndPassword(email, password);
        const user = userCredential.user;

        const basicUserData = {
          email: email,
          isActive: true,
          userRole: "user",
          password:password,
          isNewUser:true,
          userInitalSetup:"new"
        };

        await db.collection("Users").doc(user.uid).set(basicUserData);

        // ✅ Call external API to get Stripe cust_id/account_id
        const response = await fetch("https://us-central1-duepro-2cf60.cloudfunctions.net/widgetsforusa/checkcustidexistornot", {
        //   const response = await fetch("https://us-central1-freeme-6e63a.cloudfunctions.net/widgetsforusa/checkcustidexistornot", {
          method: "POST",
          headers: {
            "Content-Type": "application/json"
          },
          body: JSON.stringify({
            userId: user.uid,
            email: email
          })
        });

        const result = await response.json();

        if (result.success === 1) {
          await db.collection("Users").doc(user.uid).update({
            stripeCustid: result.cust_id,
            stripeaccount_id: result.account_id
          });
        }

        // Swal.fire({
        //   icon: "success",
        //   title: "Signup Successful",
        //   text: "Your account has been created.",
        //   confirmButtonText: "Go to Login"
        // }).then(() => {
        //   window.location.href = "<?= base_url('/') ?>";
        // });
        Swal.fire({
  icon: "success",
  title: "Signup Successful",
  text: "You are now being logged in.",
  showConfirmButton: false,
  timer: 1500
}).then(async () => {
  // Optionally, save session
  sessionStorage.setItem("user", JSON.stringify({
    uid: user.uid,
    email: user.email,
    userRole: "user",
    isActive: true
  }));

  window.location.href = "<?= base_url('site/getstarted') ?>";
});


      } catch (error) {
        console.error("Signup error:", error);
        Swal.fire("Signup Error", error.message, "error");
      }
    }
  });

  backBtn.addEventListener("click", () => {
    passwordInput.classList.add("d-none");
    passwordInput.classList.remove("d-block");
    emailInput.classList.remove("d-none");
    backBtn.classList.add("d-none");
    nextBtn.textContent = "Next";
    document.getElementById("pstr").classList.add("d-none");
  });

  passwordInput.addEventListener("input", function () {
    const pwd = this.value;
    document.getElementById("pstr").classList.remove("d-none");

    const ruleMap = {
      length: "rule-length",
      lowercase: "rule-lowercase",
      uppercase: "rule-uppercase",
      number: "rule-number",
      special: "rule-special",
    };

    Object.entries(rules).forEach(([key, validate]) => {
      const isValid = validate(pwd);
      const ruleEl = document.getElementById(ruleMap[key]);
      const img = ruleEl.querySelector("img");
      const p = ruleEl.querySelector("p");

      if (isValid) {
        img.src = "../assets/images/icontick.png";
        p.classList.remove("textDanger");
        p.classList.add("textSuccess");
      } else {
        img.src = "../assets/images/iconcross.png";
        p.classList.remove("textSuccess");
        p.classList.add("textDanger");
      }
    });
  });
</script>

<!-- googe auth script -->
 <script>
  document.getElementById("googleLoginBtn").addEventListener("click", async () => {
    const provider = new firebase.auth.GoogleAuthProvider();
    try {
      const result = await firebase.auth().signInWithPopup(provider);
      const user = result.user;

      // Optional: save to Firestore if new
      const userDoc = await db.collection("Users").doc(user.uid).get();
      if (!userDoc.exists) {
        await db.collection("Users").doc(user.uid).set({
          email: user.email,
          isActive: true,
          userRole: "user",
          displayName: user.displayName || '',
          photoURL: user.photoURL || '',
        });
      }

      sessionStorage.setItem("user", JSON.stringify({
        uid: user.uid,
        email: user.email,
        displayName: user.displayName,
      }));

      Swal.fire({
        icon: "success",
        title: "Google Signup Successful",
        text: "You are now logged in.",
        timer: 2000,
        showConfirmButton: false
      }).then(() => {
        window.location.href = "<?= base_url('site/getstarted') ?>";
      });

    } catch (error) {
      Swal.fire({
        icon: "error",
        title: "Google Login Failed",
        text: error.message
      });
    }
  });
 </script>

 

  </body>
</html>
