<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>MyCase Connect</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
    <style>
        body {
            background: #f3f6fa;
        }

        .center-box {
            max-width: 450px;
            margin: 8% auto;
            padding: 25px;
            background: white;
            border-radius: 10px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
            text-align: center;
        }

        .modal-content {
            border-radius: 12px;
        }
    </style>
</head>

<body>

    <div class="center-box">
        <img src="https://cdn-icons-png.flaticon.com/512/3597/3597075.png" width="70" class="mb-3">
        <h4 class="mb-3">MyCase Integration Demo</h4>
        <p class="text-muted mb-4">Connect your attorney MyCase account to continue.</p>

        <button class="btn btn-primary btn-lg" data-toggle="modal" data-target="#credentialModal">
            Connect MyCase
        </button>


    </div>

    <!-- Modal -->
    <div class="modal fade" id="credentialModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content p-4">
                <h5 class="mb-3">Enter MyCase Credentials</h5>
                <form id="credForm" method="POST" action="<?= base_url('mycase/connect_start') ?>">
                    <div class="form-group">
                        <label>Client ID</label>
                        <input type="text" class="form-control" name="client_id" required>
                    </div>
                    <div class="form-group">
                        <label>Client Secret</label>
                        <input type="text" class="form-control" name="client_secret" required>
                    </div>
                    <div class="form-group">
                        <label>Redirect URI</label>
                        <input type="text" class="form-control" name="redirect_uri"
                            value="<?= base_url('mycase/access') ?>" required>
                    </div>
                    <button class="btn btn-success btn-block mt-3" type="submit">Start Authorization</button>
                </form>
            </div>
        </div>
    </div>

</body>

</html>