<?php
defined('BASEPATH') or exit('No direct script access allowed');

class AuthenticationController extends MY_Controller
{
    protected $publicMethods = ['login', 'signup', 'storeUser', 'loginUser', 'help'];

    // protected $firebase;
    // protected $emailService;
    protected $user;
    // protected $userModel;

    public function __construct()
    {
        parent::__construct();

        // Load Firebase library
        $this->load->library('firebase');

        // Load Email service (create later if needed)
        // $this->load->library('emailservice');

        // Load UserModel
        $this->load->model('UserModel', 'userModel');

        // Load validation
        $this->load->library('form_validation');

        // Load session
        $this->load->library('session');

        // $this->firebase = $this->firebase;
        // $this->emailService = $this->emailservice;
    }

    // Login page
    public function login()
    {
        if ($this->session->userdata('user_logged_in')) {
            redirect('dashboard');
        }
        $this->load->view('auth/login');
    }

    public function signup()
    {
        // if ($this->session->userdata('user_logged_in')) {
        //     redirect('dashboard');
        // }
        $this->load->view('auth/signup');
    }
    // Register user
    public function storeUser()
    {
        if (!$this->input->is_ajax_request()) {
            echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
            return;
        }

        $this->form_validation->set_rules('fname', 'First Name', 'required|min_length[2]');
        $this->form_validation->set_rules('lname', 'Last Name', 'required|min_length[2]');
        $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
        $this->form_validation->set_rules('phone', 'Phone', 'required|numeric|min_length[10]');
        $this->form_validation->set_rules('password', 'Password', 'required|min_length[6]');
        $this->form_validation->set_rules('confpassword', 'Confirm Password', 'required|matches[password]');

        if ($this->form_validation->run() == FALSE) {
            echo json_encode([
                'status' => 'error',
                'errors' => $this->form_validation->error_array()
            ]);
            return;
        }

        $post = $this->input->post();

        try {
            $auth = $this->firebase->getAuth();
            $createdUser = $auth->createUserWithEmailAndPassword($post['email'], $post['password']);
        } catch (\Kreait\Firebase\Exception\Auth\EmailExists $e) {
            echo json_encode(['status' => 'error', 'errors' => ['email' => 'Email already exists.']]);
            return;
        } catch (\Exception $e) {
            log_message('error', 'Auth Create Error: ' . $e->getMessage());
            echo json_encode(['status' => 'error', 'errors' => ['email' => 'Something went wrong. Please try again.']]);
            return;
        }

        $firestore = $this->firebase->getFirestore();
        $usersRef = $firestore->collection('Users')->document($createdUser->uid);

        $hashedPassword = password_hash($post['password'], PASSWORD_DEFAULT);

        $userData = [
            'userName'        => $post['fname'] . ' ' . $post['lname'],
            'email'           => $post['email'],
            'password'        => $hashedPassword,
            'phone'           => $post['phone'],
            'userRole'        => 'coach',
            'isOnline'        => false,
            'isSubscribed'    => false,
            'deviceType'      => null,
            'lat'             => null,
            'lng'             => null,
            'token'           => null,
            'stripeCustid'    => null,
            'subscription_id' => null,
            'affiliatedWith'  => [],
            'createdAt'       => new \Google\Cloud\Core\Timestamp(new \DateTime()),
            'updatedAt'       => new \Google\Cloud\Core\Timestamp(new \DateTime())
        ];

        $usersRef->set($userData);

        echo json_encode(['status' => 'success', 'message' => 'Account created successfully.']);
    }

    // Login user
    public function loginUser()
    {
        if (!$this->input->is_ajax_request()) {
            echo json_encode(['status' => 'error', 'message' => 'Invalid request.']);
            return;
        }

        $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
        $this->form_validation->set_rules('password', 'Password', 'required|min_length[6]');

        if ($this->form_validation->run() == FALSE) {
            echo json_encode(['status' => 'error', 'errors' => $this->form_validation->error_array()]);
            return;
        }

        $post = $this->input->post();
        $email = $post['email'];
        $password = $post['password'];

        try {
            $auth = $this->firebase->getAuth();
            $signInResult = $auth->signInWithEmailAndPassword($email, $password);

            $firestore = $this->firebase->getFirestore();
            $userDocs = $firestore->collection('Users')
                ->where('email', '=', $email)
                ->limit(1)
                ->documents();

            if ($userDocs->isEmpty()) {
                echo json_encode(['status' => 'error', 'errors' => ['email' => 'Invalid email and/or password.']]);
                return;
            }

            foreach ($userDocs as $doc) {
                if ($doc->exists()) {
                    $userData = $doc->data();

                    // ✅ Check if user is a coach
                    if (!isset($userData['userRole']) || $userData['userRole'] !== 'coach') {
                        echo json_encode(['status' => 'error', 'errors' => ['email' => 'User does not exist.']]);
                        return;
                    }

                    // Continue login for coach
                    $sessionData = [
                        'user_logged_in' => true,
                        'user_doc_id'    => $doc->id(),
                        'user_uid'       => $signInResult->firebaseUserId(),
                        'user_email'     => $email,
                        'user_name'      => $userData['userName'] ?? '',
                        'user_role'      => $userData['userRole']
                    ];
                    $this->session->set_userdata($sessionData);

                    // Update Firestore online status
                    $firestore->collection('Users')->document($doc->id())->update([
                        ['path' => 'isOnline', 'value' => true],
                        ['path' => 'updatedAt', 'value' => new \Google\Cloud\Core\Timestamp(new \DateTime())]
                    ]);

                    echo json_encode([
                        'status'   => 'success',
                        'message'  => 'Login successful.',
                        'redirect' => site_url('dashboard')
                    ]);
                    return;
                }
            }
        } catch (\Kreait\Firebase\Auth\SignIn\FailedToSignIn $e) {
            echo json_encode([
                'status' => 'error',
                'errors' => ['email' => 'Invalid email and/or password.']
            ]);
        }
    }


    public function userProfile()
    {
        $coach = $this->userModel->getCoach();
        if (!$coach) {
            redirect('authenticationcontroller/login');
        }
        $this->load->view('auth/user_profile', ['coach' => $coach]);
    }

    public function logout()
    {
        $this->session->sess_destroy();
        redirect('login');
    }
}
