<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Home extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        // Load models
        $this->load->model('UserModel');
        $this->load->model('WorkoutModel');
    }

    // public function index()
    // {
    //     // Loads the default welcome view
    //     $this->load->view('welcome_message');
    // }

    // public function dashboard()
    // {

    //     // Get coach data from model
    //     $coach = $this->UserModel->getCoach();


    //     // Load the dashboard view and pass data
    //     $this->load->view('dashboard', array(
    //         'coach' => $coach
    //     ));
    // }
    public function dashboard()
    {
        $coach = $this->UserModel->getCoach();
        $workoutPlans = $this->WorkoutModel->getWorkoutPlans();
        $trainees = $this->UserModel->getAffiliatedUsers();

        $totalVideos = count($workoutPlans);
        $totalTrainees = count($trainees);
        $totalWorkouts = array_sum(array_column($workoutPlans, 'subWorkoutCount'));

        // ===== GRAPH DATA =====
        $this->load->library('firebase');
        $firestore = $this->firebase->getFirestore();

        // Last 7 days timestamps
        $today = new DateTimeImmutable();
        $dates = [];
        for ($i = 6; $i >= 0; $i--) {
            $d = $today->sub(new DateInterval("P{$i}D"));
            $dates[$d->format('Y-m-d')] = 0; // initialize
        }

        // 🔹 1. New Trainees affiliated with coach
        $traineeGraph = $dates;
        // $traineeDocs = $firestore->collection('Users')
        //     ->where('userRole', '=', 'user')
        //     ->where('affiliatedWith', 'array-contains', $this->session->userdata('user_doc_id'))
        //     ->documents();
        $userDocId = $this->session->userdata('user_doc_id');

        if (!empty($userDocId)) {
            $traineeDocs = $firestore->collection('Users')
                ->where('userRole', '=', 'user')
                ->where('affiliatedWith', 'array-contains', $userDocId)
                ->documents();
        } else {
            $traineeDocs = []; // ya phir empty result
        }



        foreach ($traineeDocs as $doc) {
            if ($doc->exists() && isset($doc['createdAt'])) {
                $day = date('Y-m-d', $doc['createdAt'] / 1000);
                if (isset($traineeGraph[$day])) {
                    $traineeGraph[$day]++;
                }
            }
        }

        // 🔹 2. Workout Plans Uploaded
        $workoutGraph = $dates;
        $planDocs = $firestore->collection('workoutplan')->documents();

        foreach ($planDocs as $doc) {
            if ($doc->exists() && isset($doc['createdAt'])) {
                $day = date('Y-m-d', $doc['createdAt'] / 1000);
                if (isset($workoutGraph[$day])) {
                    $workoutGraph[$day]++;
                }
            }
        }

        // 🔹 3. Videos uploaded (count subWorkOutPlan videos)
        $videoGraph = $dates;
        foreach ($planDocs as $doc) {
            if (!$doc->exists()) continue;
            $subWorkouts = $doc->reference()->collection('subWorkOutPlan')->documents();
            foreach ($subWorkouts as $sub) {
                if ($sub->exists() && isset($sub['createdAt']) && !empty($sub['video'])) {
                    $day = date('Y-m-d', $sub['createdAt'] / 1000);
                    if (isset($videoGraph[$day])) {
                        $videoGraph[$day]++;
                    }
                }
            }
        }
        // 🔹 4. Get affiliated new users (joined in last 7 days)
        $newUsers = [];
        foreach ($traineeDocs as $doc) {
            if ($doc->exists() && isset($doc['createdAt'])) {
                $timestamp = strtotime($doc['createdAt']);
                if ($timestamp !== false && $timestamp >= $lastWeek->getTimestamp()) {
                    $newUsers[] = [
                        'name' => isset($doc['userName']) ? $doc['userName'] : 'Unknown',
                        'email' => isset($doc['email']) ? $doc['email'] : '',
                        'dp' => isset($doc['profilePic']) ? $doc['profilePic'] : '',
                        'joinedAt' => date('Y-m-d', $timestamp)
                    ];
                }
            }
        }


        // Prepare graph data for Chart.js
        $labels = array_keys($dates);
        $graphData = [
            'trainees' => [
                'labels' => $labels,
                'values' => array_values($traineeGraph)
            ],
            'workouts' => [
                'labels' => $labels,
                'values' => array_values($workoutGraph)
            ],
            'videos' => [
                'labels' => $labels,
                'values' => array_values($videoGraph)
            ],
        ];

        $this->load->view('dashboard', [
            'coach' => $coach,
            'totalVideos' => $totalVideos,
            'totalTrainees' => $totalTrainees,
            'totalWorkouts' => $totalWorkouts,
            'graphData' => $graphData,
            'newUsers' => $newUsers

        ]);
    }
}
