<?php
defined('BASEPATH') or exit('No direct script access allowed');

class MyVideoController extends CI_Controller
{
    // no protected properties, CI3 manages them dynamically

    public function __construct()
    {
        parent::__construct();

        // Load Firebase library (must exist in application/libraries/Firebase.php)
        $this->load->library('firebase');

        // Load WorkoutModel (application/models/WorkoutModel.php)
        $this->load->model('WorkoutModel', 'workoutModel');
    }

    public function index()
    {
        $workoutTypes = $this->workoutModel->getWorkoutTypes();

        $limit = 12;
        $page = (int) $this->input->get('page');
        if ($page < 1) $page = 1;

        $this->load->library('session');
        $cursors = $this->session->userdata('workout_cursors') ?? [];

        $startAfterId = null;
        if ($page > 1 && isset($cursors[$page - 1])) {
            $startAfterId = $cursors[$page - 1];
        }

        $result = $this->workoutModel->getWorkoutPlansCursor($limit, $startAfterId);


        if ($result['lastDocId']) {
            $cursors[$page] = $result['lastDocId'];
            $this->session->set_userdata('workout_cursors', $cursors);
        }


        $this->load->view('pages/myVideos', [
            'workoutTypes' => $workoutTypes,
            'workoutPlans' => $result['plans'],
            'page' => $page,
            'hasMore' => $result['hasMore']
        ]);
    }
}
