<?php
defined('BASEPATH') or exit('No direct script access allowed');

class TestFirebase extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        // Load Firebase library
        $this->load->library('firebase');
    }

    public function index()
    {
        try {
            // Get Firestore instance
            $firestore = $this->firebase->getFirestore();

            // Reference your collection (example: "Users")
            $collection = $firestore->collection('Users');

            // Get all documents
            $documents = $collection->documents();

            $result = [];

            foreach ($documents as $doc) {
                if ($doc->exists()) {
                    $data = $doc->data();
                    $result[] = [
                        'id'   => $doc->id(),
                        'name' => $data['userName'] ?? 'N/A',
                        'role' => $data['userRole'] ?? 'N/A',
                    ];
                }
            }

            // Show result
            echo '<pre>';
            print_r($result);
            echo '</pre>';
        } catch (\Throwable $e) {
            echo "Error: " . $e->getMessage();
        }
    }
}
