<?php
defined('BASEPATH') or exit('No direct script access allowed');

class EmailService
{
    protected $CI;
    protected $apiUrl = 'https://sugarfest.online/emailapi/mail_service.php';

    public function __construct()
    {
        $this->CI = &get_instance();
    }

    /**
     * Send an email using external API
     * @param string $to
     * @param string $subject
     * @param string $message
     * @return bool
     */
    public function sendInviteEmail($to, $orderUrl)
    {
        $subject = "You have been invited!";
        $htmlMessage = "
            <p>You have been invited! Click the button below to accept:</p>
            <p>
                <a href='{$orderUrl}' style='
                    display: inline-block;
                    padding: 12px 25px;
                    font-size: 16px;
                    color: #ffffff;
                    background-color: #007bff;
                    text-decoration: none;
                    border-radius: 5px;
                '>Accept Invite</a>
            </p>
        ";

        // Build API payload
        $payload = [
            'email'   => $to,
            'subject' => $subject,
            'message' => $htmlMessage
        ];

        // Use cURL to POST data to API
        $ch = curl_init($this->apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

        $response = curl_exec($ch);
        $error = curl_error($ch);
        curl_close($ch);

        if ($error) {
            log_message('error', 'Email API Error: ' . $error);
            return false;
        }

        // Decode API response (if JSON)
        $result = json_decode($response, true);

        if (isset($result['success']) && $result['success']) {
            return true;
        } else {
            log_message('error', 'Email API failed: ' . $response);
            return false;
        }
    }
}
