<?php
defined('BASEPATH') or exit('No direct script access allowed');

require_once FCPATH . 'vendor/autoload.php';

use Kreait\Firebase\Factory;

class Firebase
{

    protected $factory;
    protected $auth;
    protected $firestore;
    protected $storage;

    public function __construct()
    {
        // Path to your Firebase service account JSON
        $serviceAccount = APPPATH . 'third_party/firebase/serviceAccount-mycoach.json';

        $this->factory = (new Factory)->withServiceAccount($serviceAccount);

        // Firebase Auth
        $this->auth = $this->factory->createAuth();

        // Firestore database
        $this->firestore = $this->factory->createFirestore()->database();

        // Firebase Storage
        $storageClient = $this->factory->createStorage();
        $this->storage = $this->factory->createStorage()->getBucket('me-and-my-coach.firebasestorage.app');
    }

    // Get Auth instance
    public function getAuth()
    {
        return $this->auth;
    }

    // Get Firestore instance
    public function getFirestore()
    {
        return $this->firestore;
    }

    // Get Storage bucket
    public function getStorage()
    {
        return $this->storage;
    }
}
