<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Signup</title>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="<?= base_url('assets/css/style.css') ?>" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" />

    <style>
        .is-invalid {
            border-color: #dc3545 !important;
        }

        .invalid-feedback {
            display: block;
            font-size: 0.875em;
        }
    </style>
</head>

<body class="bgPrimary">
    <div class="container min-h-100vh d-flex flex-column justify-content-center">
        <div class="row justify-content-center py-4">
            <div class="col-md-6">
                <img class="d-block mx-auto mb-5" src="<?= base_url('assets/images/logo.png') ?>" alt="Logo" />

                <div class="card">
                    <div class="card-body">
                        <form id="signupForm" action="<?= site_url('signup') ?>" method="post" class="row g-3">
                            <div class="col-md-6">
                                <input class="form-control" type="text" name="fname" id="fname"
                                    placeholder="First Name" />
                                <small id="fnameError" class="text-danger"></small>
                            </div>

                            <div class="col-md-6">
                                <input class="form-control" type="text" name="lname" id="lname"
                                    placeholder="Last Name" />
                                <small id="lnameError" class="text-danger"></small>
                            </div>

                            <div class="col-md-6">
                                <input class="form-control" type="text" name="email" id="email"
                                    placeholder="Email Address" />
                                <small id="emailError" class="text-danger"></small>
                            </div>

                            <div class="col-md-6">
                                <input class="form-control" type="tel" name="phone" id="phone"
                                    placeholder="Phone Number" />
                                <small id="phoneError" class="text-danger"></small>
                            </div>

                            <div class="col-md-6">
                                <div class="input-group">
                                    <input class="form-control" type="password" name="password" id="password"
                                        placeholder="Password" />
                                    <span class="input-group-text bg-transparent"><i class="eye fas fa-eye"></i></span>
                                </div>
                                <small id="passwordError" class="text-danger"></small>
                            </div>

                            <div class="col-md-6">
                                <div class="input-group">
                                    <input class="form-control" type="password" name="confpassword" id="confpassword"
                                        placeholder="Confirm Password" />
                                    <span class="input-group-text bg-transparent"><i class="eye fas fa-eye"></i></span>
                                </div>
                                <small id="confpasswordError" class="text-danger"></small>
                            </div>

                            <div class="col-12 text-center">
                                <button type="submit" class="btn btnSub py-2 w-100">Sign Up</button>
                            </div>
                        </form>
                    </div>
                </div>

                <p class="fs1 mt-3 text-center">
                    Already have an account? <a href="<?= base_url('login') ?>" class="fs2">Sign In</a>
                </p>
            </div>
        </div>
    </div>
    <script>
        // Toggle password visibility
        $(document).on("click", ".eye", function() {
            const input = $(this).closest(".input-group").find("input");
            if (input.attr("type") === "password") {
                input.attr("type", "text");
                $(this).removeClass("fa-eye").addClass("fa-eye-slash");
            } else {
                input.attr("type", "password");
                $(this).removeClass("fa-eye-slash").addClass("fa-eye");
            }
        });

        // AJAX Signup with loading
        $("#signupForm").submit(function(e) {
            e.preventDefault();

            $("small.text-danger").text("");
            $(".form-control").removeClass("is-invalid");

            // 🔥 Loading state
            const btn = $(this).find("button[type='submit']");
            btn.prop("disabled", true);
            btn.html(
                `<span id="signupText">Creating Account...</span>
             <span id="signupSpinner" class="spinner-border spinner-border-sm ms-2" role="status"></span>`
            );

            $.ajax({
                url: $(this).attr("action"),
                type: "POST",
                data: $(this).serialize(),
                dataType: "json",
                success: function(response) {
                    if (response.status === "success") {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            timer: 2000,
                            showConfirmButton: false
                        }).then(() => {
                            window.location.href = "<?= base_url('login') ?>";
                        });
                    } else if (response.errors) {
                        $.each(response.errors, function(field, errorMsg) {
                            $("#" + field).addClass("is-invalid");
                            $("#" + field + "Error").text(errorMsg);
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: response.message
                        });
                    }
                },
                error: function() {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Something went wrong.'
                    });
                },
                complete: function() {
                    // 🔥 Reset button
                    btn.prop("disabled", false);
                    btn.html(`Sign Up`);
                }
            });
        });
    </script>

</body>

</html>