<?php
// Start output buffering to capture dashboard content
ob_start();
?>

<!-- Dashboard -->
<div class="row my-3">
    <!-- Left Content -->
    <div class="col-md-8">
        <h3 class="fmon fh2 mb-3">Overview</h3>

        <!-- Stats Row -->
        <div class="row g-3">
            <div class="col-md-3">
                <div class="profileCard text-center p-3">
                    <img class="mb-2" src="<?= base_url('dashboard-assets/images/megaIcons/videos.png') ?>"
                        alt="" style="width:60px; height:60px; object-fit:contain;">
                    <h4 style="font-size:18px; font-weight:bold; margin-bottom:4px;"><?= $totalVideos ?></h4>
                    <p style="font-size:14px; margin:0; color:#555;">Total Videos</p>
                </div>
            </div>

            <div class="col-md-3">
                <div class="profileCard text-center p-3">
                    <img class="mb-2" src="<?= base_url('dashboard-assets/images/megaIcons/tainee.png') ?>"
                        alt="" style="width:60px; height:60px; object-fit:contain;">
                    <h4 style="font-size:18px; font-weight:bold; margin-bottom:4px;"><?= $totalTrainees ?></h4>
                    <p style="font-size:14px; margin:0; color:#555;">Total Trainees</p>
                </div>
            </div>

            <div class="col-md-3">
                <div class="profileCard text-center p-3">
                    <img class="mb-2" src="<?= base_url('dashboard-assets/images/megaIcons/workout.png') ?>"
                        alt="" style="width:60px; height:60px; object-fit:contain;">
                    <h4 style="font-size:18px; font-weight:bold; margin-bottom:4px;"><?= $totalWorkouts ?></h4>
                    <p style="font-size:14px; margin:0; color:#555;">Workout Plans</p>
                </div>
            </div>

            <div class="col-md-3">
                <div class="profileCard text-center p-3">
                    <img class="mb-2" src="<?= base_url('dashboard-assets/images/megaIcons/Ellipse 10.png') ?>"
                        alt="" style="width:60px; height:60px; object-fit:contain;">
                    <h4 style="font-size:18px; font-weight:bold; margin-bottom:4px;">$8.00</h4>
                    <p style="font-size:14px; margin:0; color:#555;">Income</p>
                </div>
            </div>
        </div>


        <!-- Charts Row -->
        <div class="row g-3 mt-3">
            <div class="col-md-6">
                <div class="profileCard p-3">
                    <h5 class="text-center mb-2">New Trainees (Weekly)</h5>
                    <canvas id="lineChart" height="150"></canvas>
                </div>
            </div>
            <div class="col-md-6">
                <div class="profileCard p-3">
                    <h5 class="text-center mb-2">Videos Uploaded</h5>
                    <canvas id="barChart" height="150"></canvas>
                </div>
            </div>
            <div class="col-md-12">
                <div class="profileCard p-3">
                    <h5 class="text-center mb-2">Workout Plans Uploaded</h5>
                    <canvas id="workoutChart" height="180"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Right Sidebar -->
    <div class="col-md-4">
        <!-- Profile -->
        <h3 class="fmon fh2 mb-3">Profile</h3>
        <div class="profileCard p-3 text-center mb-3">
            <img class="mx-auto mb-2" src="<?= base_url('dashboard-assets/images/pIMage.png') ?>" alt="">
            <h5 class="pname mb-1"><?= !empty($coach['userName']) ? $coach['userName'] : 'Admin' ?></h5>

            <!-- Social Icons -->
            <div class="d-flex justify-content-center gap-2 my-2">
                <span class="social"><img src="<?= base_url('dashboard-assets/images/fac.png') ?>" alt=""></span>
                <span class="social"><img src="<?= base_url('dashboard-assets/images/x.png') ?>" alt=""></span>
                <span class="social"><img src="<?= base_url('dashboard-assets/images/lin.png') ?>" alt=""></span>
                <span class="social"><img src="<?= base_url('dashboard-assets/images/you.png') ?>" alt=""></span>
            </div>

            <!-- Info -->
            <div class="text-start mt-3">
                <div class="d-flex align-items-center my-2 gap-2">
                    <img src="<?= base_url('dashboard-assets/images/ema.png') ?>" alt="">
                    <p class="m-0 fs4"><?= !empty($coach['email']) ? $coach['email'] : 'Not available' ?></p>
                </div>
                <div class="d-flex align-items-center my-2 gap-2">
                    <img src="<?= base_url('dashboard-assets/images/pho.png') ?>" alt="">
                    <p class="m-0 fs4"><?= !empty($coach['phone']) ? $coach['phone'] : '' ?></p>
                </div>
                <div class="d-flex align-items-center my-2 gap-2">
                    <img src="<?= base_url('dashboard-assets/images/loc.png') ?>" alt="">
                    <p class="m-0 fs4"><?= !empty($coach['address']) ? $coach['address'] : '' ?></p>
                </div>
            </div>

            <hr>
            <a href="<?= base_url('dashboard/coach-profile') ?>" class="btn btn-sm btn-primary">View Full Profile</a>
        </div>

        <!-- New Users Joined -->
        <h3 class="fmon fh2 mb-3">New Users (Last 7 Days)</h3>
        <div class="profileCard p-3">
            <?php if (!empty($newUsers)): ?>
                <?php foreach ($newUsers as $user): ?>
                    <div class="d-flex align-items-center mb-3">
                        <img src="<?= !empty($user['dp']) ? $user['dp'] : base_url('dashboard-assets/images/default-user.png') ?>"
                            class="rounded-circle me-2" width="40" height="40" alt="User DP">
                        <div>
                            <p class="m-0 fw-bold"><?= $user['name'] ?></p>
                            <small class="text-muted">Joined: <?= $user['joinedAt'] ?></small>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p class="text-muted">No new users joined this week.</p>
            <?php endif; ?>
        </div>

    </div>
</div>



<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Data from PHP
    const traineeLabels = <?= json_encode($graphData['trainees']['labels']) ?>;
    const traineeValues = <?= json_encode($graphData['trainees']['values']) ?>;

    const videoLabels = <?= json_encode($graphData['videos']['labels']) ?>;
    const videoValues = <?= json_encode($graphData['videos']['values']) ?>;

    const workoutLabels = <?= json_encode($graphData['workouts']['labels']) ?>;
    const workoutValues = <?= json_encode($graphData['workouts']['values']) ?>;

    // Common options for all charts
    const commonOptions = {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true, // never negative
                ticks: {
                    precision: 0, // whole numbers only
                    callback: function(value) {
                        return Number.isInteger(value) ? value : null;
                    }
                }
            }
        }
    };

    // Mini line chart (trainees short overview)
    new Chart(document.getElementById('miniLineChart'), {
        type: 'line',
        data: {
            labels: traineeLabels,
            datasets: [{
                data: traineeValues,
                borderColor: '#36A2EB',
                backgroundColor: 'rgba(54,162,235,0.2)',
                tension: 0.4
            }]
        },
        options: {
            ...commonOptions,
            plugins: {
                legend: {
                    display: false
                }
            }
        }
    });

    // Line Chart - New Trainees
    new Chart(document.getElementById('lineChart'), {
        type: 'line',
        data: {
            labels: traineeLabels,
            datasets: [{
                label: 'New Trainees',
                data: traineeValues,
                borderColor: 'blue',
                backgroundColor: 'rgba(0,0,255,0.2)',
                tension: 0.4
            }]
        },
        options: commonOptions
    });

    // Bar Chart - Videos Uploaded
    new Chart(document.getElementById('barChart'), {
        type: 'bar',
        data: {
            labels: videoLabels,
            datasets: [{
                label: 'Videos Uploaded',
                data: videoValues,
                backgroundColor: 'rgba(0, 200, 100, 0.6)'
            }]
        },
        options: commonOptions
    });

    // Extra chart for workout plans
    new Chart(document.getElementById('workoutChart'), {
        type: 'line',
        data: {
            labels: workoutLabels,
            datasets: [{
                label: 'Workout Plans Uploaded',
                data: workoutValues,
                borderColor: 'red',
                backgroundColor: 'rgba(255,0,0,0.2)',
                tension: 0.4
            }]
        },
        options: commonOptions
    });
</script>

<?php
// Capture all content in a variable
$content = ob_get_clean();

// Load the layout and pass the content
$this->load->view('layouts/app', ['content' => $content]);
