<?php
// Start output buffering
ob_start();
?>

<div class="container-fluid">
    <div class="row">
        <!-- LEFT SIDE: CHAT LIST -->
        <div class="col-md-4 border-end" style="height: 80vh; overflow-y: auto;">
            <h5 class="p-1">Chats</h5>
            <div id="chatList"></div>
        </div>

        <!-- RIGHT SIDE: CHAT BOX -->
        <div class="col-md-8 p-2" style="height: 90vh; display: flex; flex-direction: column;">
            <div id="chatHeader" class="mb-3"><strong>Select a chat to start messaging</strong></div>
            <div id="chatBox"
                style="flex: 1; overflow-y: auto; border: 1px solid #ccc; padding: 10px; background: #f9f9f9;"></div>
            <div class="d-flex mt-3">
                <input class="form-control me-2" id="messageInput" placeholder="Type a message..." disabled />
                <button class="btn btn-primary" id="sendMessageBtn" disabled>Send</button>
            </div>
        </div>
    </div>
</div>

<style>
    .message-row {
        display: flex;
        margin-bottom: 8px;
    }

    .message-row.sent {
        justify-content: flex-end;
    }

    .message-row.received {
        justify-content: flex-start;
    }

    .message-bubble {
        max-width: 70%;
        padding: 10px 14px;
        border-radius: 18px;
        background-color: #dcf8c6;
        position: relative;
        word-wrap: break-word;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    }

    .message-row.received .message-bubble {
        background-color: #e1f0ff;
        border: 1px solid #d0e4ff;
    }

    .message-time {
        font-size: 0.75em;
        color: #666;
        text-align: right;
        margin-top: 4px;
    }

    .chat-item:hover {
        background-color: #f1f1f1;
    }
</style>

<!-- Firebase SDK -->
<script src="https://www.gstatic.com/firebasejs/8.10.1/firebase-app.js"></script>
<script src="https://www.gstatic.com/firebasejs/8.10.1/firebase-firestore.js"></script>
<script src="https://www.gstatic.com/firebasejs/8.10.1/firebase-auth.js"></script>

<script>
    // Firebase Config
    const firebaseConfig = {
        apiKey: "AIzaSyBE5KqH0atMHbWwhJJOYf0_AxG53OhfhI0",
        authDomain: "me-and-my-coach.firebaseapp.com",
        projectId: "me-and-my-coach",
        storageBucket: "me-and-my-coach.appspot.com",
        messagingSenderId: "1234567890",
        appId: "1:1234567890:web:abcdef"
    };
    firebase.initializeApp(firebaseConfig);
    const db = firebase.firestore();

    // Variables from PHP (CI3 way)
    const coachId = "<?= $coachId ?>";
    const DEFAULT_PROFILE_IMAGE = "<?= base_url('dashboard-assets/images/avatars/11.png') ?>";

    let activeChatId = null;
    let activeUserId = null;
    let activeUserName = null;
    let activeUserImage = null;

    async function getUserInfoById(userId) {
        try {
            const userDoc = await db.collection('Users').doc(userId).get();
            if (userDoc.exists) {
                const u = userDoc.data();
                return {
                    name: u.userName || 'User',
                    image: u.image || DEFAULT_PROFILE_IMAGE
                };
            }
        } catch (e) {
            console.error("Error fetching user info:", e);
        }
        return {
            name: 'User',
            image: DEFAULT_PROFILE_IMAGE
        };
    }

    function closeChat() {
        activeChatId = null;
        activeUserId = null;
        activeUserName = null;
        activeUserImage = null;

        chatHeader.innerHTML = `<strong>Select a chat to start messaging</strong>`;
        chatBox.innerHTML = '';
        messageInput.value = '';
        messageInput.disabled = true;
        sendMessageBtn.disabled = true;
    }

    // Fetch chats for this coach
    db.collection('Chats')
        .where(`participants.${coachId}`, '==', true)
        .onSnapshot(async snapshot => {
            if (snapshot.empty) {
                chatList.innerHTML = `<p class="p-3 text-muted">No chats found.</p>`;
                return;
            }

            let chats = [];
            for (let doc of snapshot.docs) {
                let chat = doc.data();
                chat.id = doc.id;
                chats.push(chat);
            }

            chats.sort((a, b) => {
                let tA = a.lastMessage?.timestamp || 0;
                let tB = b.lastMessage?.timestamp || 0;
                return tB - tA;
            });

            chatList.innerHTML = '';

            for (let chat of chats) {
                const chatId = chat.id;
                const otherUserId = Object.keys(chat.participants).find(id => id !== coachId);
                const {
                    name,
                    image
                } = await getUserInfoById(otherUserId);
                const lastMessage = chat.lastMessage?.content || 'No messages yet';

                const chatItem = document.createElement('div');
                chatItem.className = 'chat-item p-2 d-flex align-items-center border-bottom';
                chatItem.style.cursor = "pointer";
                chatItem.innerHTML = `
                    <img src="${image}" width="40" height="40" class="me-2 rounded-circle" 
                         onerror="this.src='${DEFAULT_PROFILE_IMAGE}'">
                    <div>
                        <strong>${name}</strong><br>
                        <small>${lastMessage}</small>
                    </div>
                `;
                chatItem.onclick = () => loadMessages(chatId, otherUserId, name, image);
                chatList.appendChild(chatItem);
            }
        });

    function loadMessages(chatId, otherUserId, otherUserName, otherUserImage) {
        activeChatId = chatId;
        activeUserId = otherUserId;
        activeUserName = otherUserName;
        activeUserImage = otherUserImage;

        chatHeader.innerHTML = `<strong>${activeUserName}</strong>`;
        messageInput.disabled = false;
        sendMessageBtn.disabled = false;

        db.collection('Chats').doc(chatId).collection('Conversations')
            .orderBy('timestamp', 'asc')
            .onSnapshot(snapshot => {
                let messages = [];
                snapshot.forEach(doc => messages.push(doc.data()));

                messages.sort((a, b) => (a.timestamp || 0) - (b.timestamp || 0));

                chatBox.innerHTML = '';
                messages.forEach(msg => {
                    const isSender = msg.fromID === coachId;
                    const timeString = msg.timestamp ?
                        new Date(msg.timestamp).toLocaleTimeString([], {
                            hour: '2-digit',
                            minute: '2-digit'
                        }) : '';

                    chatBox.innerHTML += `
                    <div class="message-row ${isSender ? 'sent' : 'received'}">
                        <div class="message-bubble">
                            ${msg.content}
                            <div class="message-time">${timeString}</div>
                        </div>
                    </div>`;
                });

                chatBox.scrollTop = chatBox.scrollHeight;
            });
    }

    sendMessageBtn.onclick = async () => {
        const content = messageInput.value.trim();
        if (!content) return;

        try {
            let chatIdToUse = activeChatId;
            const timestampMs = Date.now();

            if (!chatIdToUse) {
                const newChatRef = await db.collection('Chats').add({
                    participants: {
                        [coachId]: true,
                        [activeUserId]: true
                    },
                    lastMessage: {
                        content,
                        timestamp: timestampMs
                    },
                    createdAt: timestampMs
                });
                chatIdToUse = newChatRef.id;
                activeChatId = chatIdToUse;
            }

            const message = {
                content,
                fromID: coachId,
                toID: activeUserId,
                isRead: false,
                type: "text",
                timestamp: timestampMs
            };

            await db.collection('Chats').doc(chatIdToUse)
                .collection('Conversations')
                .add(message);

            await db.collection('Chats').doc(chatIdToUse).update({
                lastMessage: {
                    content,
                    timestamp: timestampMs
                }
            });

            messageInput.value = '';
        } catch (error) {
            console.error("Send error:", error);
        }
    };
</script>

<?php
// Capture buffered content
$content = ob_get_clean();

// Load layout and inject content
$this->load->view('layouts/app', ['content' => $content]);
?>