<?php ob_start(); ?>

<div class="d-flex flex-row justify-content-between align-items-center mb-4">
    <h2 class="fh2 fmon">Workout Library</h2>
</div>

<!-- Simple Grid - 12 items per page -->
<div class="row g-4" id="libraryGrid">
    <?php foreach ($workoutPlans as $plan): ?>
        <div class="col-6 col-md-4 col-lg-3">
            <div class="library-card" onclick="viewWorkout('<?= $plan['id'] ?>')">
                <div class="library-img">
                    <img src="<?= !empty($plan['thumbnail']) ? htmlspecialchars($plan['thumbnail']) : base_url('dashboard-assets/images/img/Mask.png') ?>"
                        alt="<?= htmlspecialchars($plan['title']) ?>">
                </div>
                <div class="library-title">
                    <h6><?= htmlspecialchars($plan['title']) ?></h6>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<!-- Pagination -->
<?php if ($hasMore || $currentPage > 1): ?>
    <div class="d-flex justify-content-center mt-4 gap-2">
        <?php if ($currentPage > 1): ?>
            <button class="btn btn-outline-primary" onclick="loadPage(<?= $currentPage - 1 ?>, '<?= $prevDocId ?? '' ?>')">
                <i class="bi bi-chevron-left"></i> Previous
            </button>
        <?php endif; ?>

        <span class="btn btn-primary disabled">Page <?= $currentPage ?></span>

        <?php if ($hasMore): ?>
            <button class="btn btn-outline-primary" onclick="loadPage(<?= $currentPage + 1 ?>, '<?= $lastDocId ?? '' ?>')">
                Next <i class="bi bi-chevron-right"></i>
            </button>
        <?php endif; ?>
    </div>
<?php endif; ?>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script>
    const base_url = "<?= base_url() ?>";

    function viewWorkout(planId) {
        window.location.href = `${base_url}workout/libraryDetail/${planId}`;
    }

    function loadPage(page, lastDoc) {
        let url = `${base_url}dashboard/library?page=${page}`;
        if (lastDoc) {
            url += `&lastDoc=${lastDoc}`;
        }
        window.location.href = url;
    }
</script>

<style>
    .library-card {
        background: #fff;
        border-radius: 12px;
        overflow: hidden;
        cursor: pointer;
        transition: transform 0.2s ease, box-shadow 0.2s ease;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }

    .library-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
    }

    .library-img {
        width: 100%;
        height: 180px;
        overflow: hidden;
    }

    .library-img img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.3s ease;
    }

    .library-card:hover .library-img img {
        transform: scale(1.1);
    }

    .library-title {
        padding: 12px;
        text-align: center;
    }

    .library-title h6 {
        margin: 0;
        font-weight: 600;
        font-size: 14px;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    @media (max-width: 768px) {
        .library-img {
            height: 140px;
        }
    }
</style>

<?php
$content = ob_get_clean();
$this->load->view('layouts/app', ['content' => $content]);
?>