<?php ob_start(); ?>

<div class="mb-4">
    <a href="<?= base_url('dashboard/library') ?>" class="btn btn-outline-dark mb-3">
        <i class="bi bi-arrow-left"></i> Back to Library
    </a>
    <h2 class="fh2 fmon"><?= htmlspecialchars($plan['title']) ?></h2>
    <p class="text-muted"><?= htmlspecialchars($plan['description']) ?></p>
</div>

<!-- Gallery Grid -->
<div class="row g-3">
    <?php
    $mediaIndex = 0;
    foreach ($plan['subWorkouts'] as $sub):
        // Add video first if exists
        if (!empty($sub['video'])):
            $mediaIndex++;
    ?>
            <div class="col-6 col-md-4 col-lg-3">
                <div class="gallery-item" onclick="openMedia(<?= $mediaIndex - 1 ?>)">
                    <div class="gallery-thumb">
                        <img src="<?= !empty($sub['imageUrls'][0]) ? htmlspecialchars($sub['imageUrls'][0]) : base_url('dashboard-assets/images/img/Mask.png') ?>"
                            alt="<?= htmlspecialchars($sub['title']) ?>">
                        <div class="play-overlay">
                            <i class="bi bi-play-circle-fill"></i>
                        </div>
                    </div>
                    <div class="gallery-caption">
                        <small><?= htmlspecialchars($sub['title']) ?></small>
                    </div>
                </div>
            </div>
            <?php
        endif;

        // Add images
        if (!empty($sub['imageUrls'])):
            foreach ($sub['imageUrls'] as $imageUrl):
                $mediaIndex++;
            ?>
                <div class="col-6 col-md-4 col-lg-3">
                    <div class="gallery-item" onclick="openMedia(<?= $mediaIndex - 1 ?>)">
                        <div class="gallery-thumb">
                            <img src="<?= htmlspecialchars($imageUrl) ?>" alt="<?= htmlspecialchars($sub['title']) ?>">
                        </div>
                        <div class="gallery-caption">
                            <small><?= htmlspecialchars($sub['title']) ?></small>
                        </div>
                    </div>
                </div>
    <?php
            endforeach;
        endif;
    endforeach;
    ?>
</div>

<!-- Fullscreen Viewer -->
<div id="mediaViewer" class="media-viewer" style="display: none;">
    <div class="media-viewer-header">
        <button onclick="closeMedia()" class="btn-close-viewer">
            <i class="bi bi-x-lg"></i>
        </button>
    </div>
    <div class="media-viewer-content" id="mediaContent"></div>
    <div class="media-viewer-nav">
        <button onclick="prevMedia()" class="nav-btn">
            <i class="bi bi-chevron-left"></i>
        </button>
        <span id="mediaCounter"></span>
        <button onclick="nextMedia()" class="nav-btn">
            <i class="bi bi-chevron-right"></i>
        </button>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script>
    const mediaList = [
        <?php
        foreach ($plan['subWorkouts'] as $sub):
            if (!empty($sub['video'])):
        ?> {
                    type: 'video',
                    url: '<?= addslashes($sub['video']) ?>',
                    title: '<?= addslashes($sub['title']) ?>'
                },
                <?php
            endif;
            if (!empty($sub['imageUrls'])):
                foreach ($sub['imageUrls'] as $imageUrl):
                ?> {
                        type: 'image',
                        url: '<?= addslashes($imageUrl) ?>',
                        title: '<?= addslashes($sub['title']) ?>'
                    },
        <?php
                endforeach;
            endif;
        endforeach;
        ?>
    ];

    let currentIndex = 0;

    function openMedia(index) {
        currentIndex = index;
        showMedia();
        $('#mediaViewer').fadeIn(200);
        $('body').css('overflow', 'hidden');
    }

    function closeMedia() {
        $('#mediaViewer').fadeOut(200);
        $('body').css('overflow', 'auto');
    }

    function showMedia() {
        const media = mediaList[currentIndex];
        const content = $('#mediaContent');

        if (media.type === 'video') {
            content.html(`
            <video controls autoplay class="viewer-media">
                <source src="${media.url}" type="video/mp4">
            </video>
        `);
        } else {
            content.html(`<img src="${media.url}" class="viewer-media" alt="${media.title}">`);
        }

        $('#mediaCounter').text(`${currentIndex + 1} / ${mediaList.length}`);
    }

    function prevMedia() {
        if (currentIndex > 0) {
            currentIndex--;
            showMedia();
        }
    }

    function nextMedia() {
        if (currentIndex < mediaList.length - 1) {
            currentIndex++;
            showMedia();
        }
    }

    // Keyboard navigation
    $(document).on('keydown', function(e) {
        if ($('#mediaViewer').is(':visible')) {
            if (e.key === 'ArrowLeft') prevMedia();
            if (e.key === 'ArrowRight') nextMedia();
            if (e.key === 'Escape') closeMedia();
        }
    });
</script>

<style>
    .gallery-item {
        background: #fff;
        border-radius: 8px;
        overflow: hidden;
        cursor: pointer;
        transition: transform 0.2s ease;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }

    .gallery-item:hover {
        transform: translateY(-3px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    .gallery-thumb {
        position: relative;
        width: 100%;
        height: 150px;
        overflow: hidden;
    }

    .gallery-thumb img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.3s ease;
    }

    .gallery-item:hover .gallery-thumb img {
        transform: scale(1.1);
    }

    .play-overlay {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
        background: rgba(0, 0, 0, 0.3);
    }

    .play-overlay i {
        font-size: 3rem;
        color: white;
    }

    .gallery-caption {
        padding: 8px;
        text-align: center;
    }

    .gallery-caption small {
        font-size: 12px;
        font-weight: 500;
    }

    /* Fullscreen Viewer */
    .media-viewer {
        position: fixed;
        top: 0;
        left: 0;
        width: 100vw;
        height: 100vh;
        background: rgba(0, 0, 0, 0.95);
        z-index: 9999;
        display: flex;
        flex-direction: column;
    }

    .media-viewer-header {
        padding: 20px;
        text-align: right;
    }

    .btn-close-viewer {
        background: transparent;
        border: none;
        color: white;
        font-size: 24px;
        cursor: pointer;
        padding: 10px;
    }

    .media-viewer-content {
        flex: 1;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 20px;
    }

    .viewer-media {
        max-width: 90vw;
        max-height: 80vh;
        object-fit: contain;
    }

    .media-viewer-nav {
        padding: 20px;
        display: flex;
        justify-content: center;
        align-items: center;
        gap: 20px;
        color: white;
    }

    .nav-btn {
        background: rgba(255, 255, 255, 0.2);
        border: none;
        color: white;
        padding: 10px 15px;
        border-radius: 8px;
        cursor: pointer;
        font-size: 20px;
        transition: background 0.2s ease;
    }

    .nav-btn:hover {
        background: rgba(255, 255, 255, 0.3);
    }

    @media (max-width: 768px) {
        .gallery-thumb {
            height: 120px;
        }
    }
</style>

<?php
$content = ob_get_clean();
$this->load->view('layouts/app', ['content' => $content]);
?>