<?php
// Start output buffering
ob_start();
?>

<div class="d-flex flex-row justify-content-between mb-3">
    <h3 class="fh2 fmon">Workout Plans</h3>
    <a href="<?= base_url('dashboard/add-workput-plan') ?>" class="btn btn-dark">Create Workout Plan</a>
</div>

<ul class="nav nav-tabs gap-2" id="myTab" role="tablist">
    <!-- All Category Tab -->
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="all-category-tab" data-bs-toggle="tab" data-bs-target="#all-category"
            type="button" role="tab" aria-controls="all-category" aria-selected="true">All Category</button>
    </li>

    <!-- Dynamic workout type tabs -->
    <?php if (!empty($workoutTypes)):
        $maxVisible = 5; // show only first 5 tabs
    ?>
        <?php foreach ($workoutTypes as $index => $type):
            $typeName = is_array($type) && isset($type['name']) ? $type['name'] : (is_string($type) ? $type : '');
            $tabId = strtolower(str_replace(' ', '-', $typeName));
            $hiddenClass = ($index >= $maxVisible) ? 'd-none extra-tab' : '';
        ?>
            <li class="nav-item <?= $hiddenClass ?>" role="presentation">
                <button class="nav-link" id="<?= $tabId ?>-tab" data-bs-toggle="tab" data-bs-target="#<?= $tabId ?>"
                    type="button" role="tab" aria-controls="<?= $tabId ?>" aria-selected="false">
                    <?= htmlspecialchars($typeName) ?>
                </button>
            </li>
        <?php endforeach; ?>

        <?php if (count($workoutTypes) > $maxVisible): ?>
            <li class="nav-item">
                <button class="btn btn-outline-primary" id="toggle-tabs-btn" type="button">
                    More
                </button>
            </li>

        <?php endif; ?>
    <?php endif; ?>
</ul>

<div class="tab-content" id="myTabContent">
    <!-- All Category Tab -->
    <div class="tab-pane fade show active" id="all-category" role="tabpanel" aria-labelledby="all-category-tab">
        <div class="row mt-3">
            <?php if (!empty($workoutPlans)): ?>
                <?php foreach ($workoutPlans as $plan):
                    $planType = is_array($plan['type']) ? implode(', ', $plan['type']) : $plan['type'];
                ?>
                    <div class="col-md-4 mb-3">
                        <div class="profileCard d-flex flex-row" style="cursor: pointer;"
                            onclick="window.location.href='<?= base_url('workout/subworkout/' . $plan['id']) ?>'">
                            <div class="card-body p-2">
                                <h5 class="card-title"><?= htmlspecialchars($plan['title']) ?></h5>
                                <p class="card-text"><?= htmlspecialchars($planType) ?></p>
                                <?php
                                    $monthlyPrice = $plan['monthlyPrice'] ?? ($plan['price'] ?? null);
                                    $priceLabel = is_numeric($monthlyPrice) ? '$' . number_format((float)$monthlyPrice, 2) . ' / mo' : 'N/A';
                                ?>
                                <div class="d-flex align-items-center gap-2">
                                    <p class="card-text ctext px-2 py-1 m-0">
                                        <small class="text-muted">
                                            <img src="<?= base_url('assets/images/megaIcons/pause.png') ?>" alt="">
                                            <?= isset($plan['subWorkoutCount']) ? htmlspecialchars($plan['subWorkoutCount']) : '0' ?>
                                            Videos
                                        </small>
                                    </p>
                                    <p class="card-text ctext px-2 py-1 m-0">
                                        <small class="text-muted">
                                            <img src="<?= base_url('assets/images/megaIcons/dollr.png') ?>" alt="">
                                            <?= htmlspecialchars($priceLabel) ?>
                                        </small>
                                    </p>
                                </div>
                            </div>
                            <img src="<?= !empty($plan['thumbnail']) ? htmlspecialchars($plan['thumbnail']) : base_url('dashboard-assets/images/img/Mask.png') ?>"
                                class="pcImageMyVideos" alt="<?= htmlspecialchars($plan['title']) ?>"
                                style="object-fit: cover; border-radius: 0 10px 10px 0; width: 140px; height: 140px;">
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p class="text-muted">No workout plans available.</p>
            <?php endif; ?>

            <!-- ✅ Pagination Block Added -->
            <nav class="mt-3">
                <ul class="pagination justify-content-end">
                    <?php if ($page > 1): ?>
                        <li class="page-item">
                            <a class="page-link" href="<?= base_url('myvideos?page=' . ($page - 1)) ?>">Previous</a>
                        </li>
                    <?php else: ?>
                        <li class="page-item disabled"><span class="page-link">Previous</span></li>
                    <?php endif; ?>

                    <li class="page-item disabled"><span class="page-link">Page <?= $page ?></span></li>

                    <?php if (!empty($hasMore)): ?>
                        <li class="page-item">
                            <a class="page-link" href="<?= base_url('myvideos?page=' . ($page + 1)) ?>">Next</a>
                        </li>
                    <?php else: ?>
                        <li class="page-item disabled"><span class="page-link">Next</span></li>
                    <?php endif; ?>
                </ul>
            </nav>
        </div>
    </div>

    <!-- Dynamic workout type tab content -->
    <?php if (!empty($workoutTypes)): ?>
        <?php foreach ($workoutTypes as $type):
            $tabId = strtolower(str_replace(' ', '-', $type['name']));
        ?>
            <div class="tab-pane fade" id="<?= $tabId ?>" role="tabpanel" aria-labelledby="<?= $tabId ?>-tab">
                <div class="row mt-3">
                    <?php
                    //  Filter workoutPlans by workout_type_id
                    $filteredPlans = array_filter($workoutPlans, function ($p) use ($type) {
                        return isset($p['workout_type_id']) && $p['workout_type_id'] === $type['id'];
                    });

                    if (!empty($filteredPlans)):
                        foreach ($filteredPlans as $plan):
                            $planType = $type['name']; // ab type ka name direct workoutTypes se milega
                    ?>
                            <div class="col-md-4 mb-3">
                                <div class="profileCard d-flex flex-row" style="cursor: pointer;"
                                    onclick="window.location.href='<?= base_url('workout/subworkout/' . $plan['id']) ?>'">
                                    <div class="card-body p-2">
                                        <h5 class="card-title"><?= htmlspecialchars($plan['title']) ?></h5>
                                        <p class="card-text"><?= htmlspecialchars($planType) ?></p>
                                        <?php
                                            $monthlyPrice = $plan['monthlyPrice'] ?? ($plan['price'] ?? null);
                                            $priceLabel = is_numeric($monthlyPrice) ? '$' . number_format((float)$monthlyPrice, 2) . ' / mo' : 'N/A';
                                        ?>
                                        <div class="d-flex align-items-center gap-2">
                                            <p class="card-text ctext px-2 py-1 m-0">
                                                <small class="text-muted">
                                                    <img src="<?= base_url('assets/images/megaIcons/pause.png') ?>" alt="">
                                                    <?= isset($plan['subWorkoutCount']) ? htmlspecialchars($plan['subWorkoutCount']) : '0' ?>
                                                    Videos
                                                </small>
                                            </p>
                                            <p class="card-text ctext px-2 py-1 m-0">
                                                <small class="text-muted">
                                                    <img src="<?= base_url('assets/images/megaIcons/dollr.png') ?>" alt="">
                                                    <?= htmlspecialchars($priceLabel) ?>
                                                </small>
                                            </p>
                                        </div>
                                    </div>
                                    <img src="<?= !empty($plan['thumbnail']) ? htmlspecialchars($plan['thumbnail']) : base_url('dashboard-assets/images/img/Mask.png') ?>"
                                        class="pcImageMyVideos" alt="<?= htmlspecialchars($plan['title']) ?>"
                                        style="object-fit: cover; border-radius: 0 10px 10px 0; width: 140px; height: 140px;">
                                </div>
                            </div>
                    <?php
                        endforeach;
                    else:
                        echo '<p class="text-muted">No plans available for this category.</p>';
                    endif;
                    ?>
                </div>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>

</div>

<?php
// End buffering and capture content
$content = ob_get_clean();

// Load layout and pass content
$this->load->view('layouts/app', ['content' => $content]);
?>
<script>
    document.addEventListener("DOMContentLoaded", function() {
        const toggleBtn = document.getElementById("toggle-tabs-btn");
        if (toggleBtn) {
            toggleBtn.addEventListener("click", function() {
                const extraTabs = document.querySelectorAll(".extra-tab");

                extraTabs.forEach(tab => tab.classList.toggle("d-none"));

                if (toggleBtn.textContent.trim() === "More") {
                    toggleBtn.textContent = "See Less";
                    toggleBtn.classList.remove("btn-outline-primary");
                    toggleBtn.classList.add("btn-outline-danger");
                } else {
                    toggleBtn.textContent = "More";
                    toggleBtn.classList.remove("btn-outline-danger");
                    toggleBtn.classList.add("btn-outline-primary");
                }
            });
        }
    });
</script>
