<?php
// Start output buffering
ob_start();
?>

<div class="d-flex flex-row justify-content-between align-items-center">
    <h2 class="fh2 fmon">Trainee</h2>


    <!-- Invite Modal -->
    <div class="modal fade" id="inviteModal" tabindex="-1" aria-labelledby="inviteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form id="inviteForm">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="inviteModalLabel">Invite User</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="user_email" class="form-label">User Email</label>
                            <input type="email" class="form-control" id="user_email" name="user_email" required
                                placeholder="user@example.com">
                        </div>
                        <div id="inviteMessage" class="text-success small mt-2"></div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-dark">Send Invite</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Trainee Cards -->
<div class="row trainee-list mt-4">
    <?php if (!empty($trainees) && is_array($trainees)): ?>
        <?php foreach ($trainees as $index => $trainee): ?>
            <div class="col-md-4 my-2">
                <a href="<?= base_url('dashboard/trainee/detail/' . $trainee['id']) ?>"
                    class="profileCard trainee-card d-flex flex-row justify-content-center">
                    <img src="<?= htmlspecialchars($trainee['image']) ?>" class="card-img-top" alt="User">
                    <div class="card-body">
                        <h5 class="fs2"><?= htmlspecialchars($trainee['userName']) ?></h5>
                        <p class="fs1">
                            <?php if (!empty($trainee['isSubscribed'])): ?>
                                <span class="badge bg-success fs-6">Subscribed</span>
                            <?php else: ?>
                                <span class="badge bg-secondary fs-6">Not Subscribed</span>
                            <?php endif; ?>
                        </p>
                    </div>
                    <button class="btn dropdown-toggle trainee-btn"></button>
                </a>
            </div>
        <?php endforeach; ?>
    <?php else: ?>
        <div class="col-12">
            <p class="text-muted">No trainees found.</p>
        </div>
    <?php endif; ?>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script>
    $(document).ready(function() {
        $('#inviteForm').off('submit').on('submit', function(e) {
            e.preventDefault();

            const msgBox = $('#inviteMessage');
            const submitBtn = $(this).find('button[type="submit"]');
            submitBtn.prop('disabled', true).text('Sending...');

            $.ajax({
                url: '<?= base_url('invite/send') ?>',
                method: 'POST',
                data: $(this).serialize(),
                dataType: 'json',
                success: function(response) {
                    if (response.status === "success") {
                        msgBox.removeClass('text-danger').addClass('text-success').text(response
                            .message);
                        $('#user_email').val('');
                    } else {
                        msgBox.removeClass('text-success').addClass('text-danger').text(response
                            .message || 'Something went wrong.');
                    }
                    setTimeout(() => msgBox.text(''), 3000);
                },
                error: function(xhr) {
                    let errorMessage = 'Something went wrong.';
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMessage = xhr.responseJSON.message;
                    }
                    msgBox.removeClass('text-success').addClass('text-danger').text(
                        errorMessage);
                    setTimeout(() => msgBox.text(''), 3000);
                },
                complete: function() {
                    submitBtn.prop('disabled', false).text('Send Invite');
                }
            });
        });
    });
</script>

<?php
// End buffering and capture content
$content = ob_get_clean();

// Load layout and pass content
$this->load->view('layouts/app', ['content' => $content]);
?>