<?php
// Start output buffering
ob_start();
?>

<div class="container mt-4">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="mb-0">Trainee Details</h2>
        <a href="<?= base_url('dashboard/trainee') ?>" class="btn btn-outline-secondary">← Back</a>
    </div>

    <!-- Profile Card -->
    <div class="card p-4 mb-4">
        <div class="row align-items-center">
            <div class="col-md-3 text-center">
                <img src="<?= htmlspecialchars($trainee['image'] ?? base_url('dashboard-assets/images/avatars/11.png')) ?>"
                    class="img-fluid rounded-circle" width="120" alt="Trainee Image">
            </div>
            <div class="col-md-9">
                <h4><?= htmlspecialchars($trainee['userName'] ?? 'Unknown') ?></h4>
                <p><strong>Email:</strong> <?= htmlspecialchars($trainee['email'] ?? 'N/A') ?></p>
                <p><strong>Device Type:</strong> <?= htmlspecialchars($trainee['deviceType'] ?? 'Unknown') ?></p>
                <p><strong>Online:</strong>
                    <?php if (!empty($trainee['isOnline'])): ?>
                        <span class="badge bg-success">Online</span>
                    <?php else: ?>
                        <span class="badge bg-secondary">Offline</span>
                    <?php endif; ?>
                </p>
                <p><strong>Location:</strong> <?= htmlspecialchars($trainee['lat'] ?? '-') ?>,
                    <?= htmlspecialchars($trainee['lng'] ?? '-') ?></p>
                <p><strong>Status:</strong>
                    <?php if (!empty($trainee['isSubscribed'])): ?>
                        <span class="badge bg-success">Subscribed</span>
                    <?php else: ?>
                        <span class="badge bg-secondary">Not Subscribed</span>
                    <?php endif; ?>
                </p>
            </div>
        </div>
    </div>

    <!-- Chat Box -->
    <div class="card p-3">
        <h5>Chat with <?= htmlspecialchars($trainee['userName']) ?></h5>
        <div id="chatMessages" class="border rounded p-2 mb-3" style="height: 250px; overflow-y: auto;">
            <p class="text-muted">Loading chat...</p>
        </div>
        <div class="input-group">
            <input type="text" id="chatInput" class="form-control" placeholder="Type your message...">
            <button class="btn btn-primary" id="sendMessageBtn">Send</button>
        </div>
    </div>
</div>

<!-- Firebase SDK -->
<script src="https://www.gstatic.com/firebasejs/9.23.0/firebase-app-compat.js"></script>
<script src="https://www.gstatic.com/firebasejs/9.23.0/firebase-firestore-compat.js"></script>

<script>
    // ===== Firebase Config =====
    const firebaseConfig = {
        apiKey: "AIzaSyBE5KqH0atMHbWwhJJOYf0_AxG53OhfhI0",
        authDomain: "me-and-my-coach.firebaseapp.com",
        projectId: "me-and-my-coach",
        storageBucket: "me-and-my-coach.appspot.com",
        messagingSenderId: "1234567890",
        appId: "1:1234567890:web:abcdef"
    };
    firebase.initializeApp(firebaseConfig);
    const db = firebase.firestore();

    // ===== Variables =====
    const coachId = "<?= htmlspecialchars($coachId) ?>";
    const traineeId = "<?= htmlspecialchars($trainee['id']) ?>";
    let chatId = null;

    const chatMessages = document.getElementById('chatMessages');
    const chatInput = document.getElementById('chatInput');
    const sendBtn = document.getElementById('sendMessageBtn');

    // ===== Find or Create Chat =====
    async function initChat() {
        const chatQuery = await db.collection("Chats")
            .where(`participants.${coachId}`, "==", true)
            .where(`participants.${traineeId}`, "==", true)
            .limit(1)
            .get();

        if (!chatQuery.empty) {
            chatId = chatQuery.docs[0].id;
        } else {
            const newChatRef = await db.collection("Chats").add({
                participants: {
                    [coachId]: true,
                    [traineeId]: true
                },
                createdAt: Date.now(),
                lastMessage: {}
            });
            chatId = newChatRef.id;
        }
        listenForMessages();
    }

    // ===== Listen for Messages =====
    function listenForMessages() {
        db.collection("Chats").doc(chatId)
            .collection("Conversations")
            .orderBy("timestamp", "asc")
            .onSnapshot(snapshot => {
                chatMessages.innerHTML = "";
                snapshot.forEach(doc => {
                    const msg = doc.data();
                    const isMe = msg.fromID === coachId;
                    const div = document.createElement('div');
                    div.className = isMe ? "text-end mb-2" : "text-start mb-4";
                    div.innerHTML =
                        `<span class="p-1 rounded ${isMe ? 'bg-primary text-white' : 'bg-light'}">${msg.content}</span>`;
                    chatMessages.appendChild(div);
                });
                chatMessages.scrollTop = chatMessages.scrollHeight;
            });
    }

    // ===== Send Message =====
    sendBtn.addEventListener('click', async () => {
        const content = chatInput.value.trim();
        if (!content || !chatId) return;

        const timestamp = Date.now();

        await db.collection("Chats").doc(chatId).collection("Conversations").add({
            content,
            fromID: coachId,
            toID: traineeId,
            timestamp,
            isRead: false,
            type: "text"
        });

        await db.collection("Chats").doc(chatId).update({
            lastMessage: {
                content,
                timestamp
            }
        });

        chatInput.value = "";
    });

    // ===== Start =====
    initChat();
</script>

<?php
// End buffering and capture content
$content = ob_get_clean();

// Load layout and pass content
$this->load->view('layouts/app', ['content' => $content]);
?>