$(document).ready(function () {
	// Remove any conflicting event handlers
	$(".btn-toggle").off("click");
	$(".sidebar-close").off("click");
	$(".overlay").off("click");

	// Reinitialize toggle functionality
	$(".btn-toggle").on("click", function (e) {
		e.preventDefault();

		const body = $("body");
		const isToggled = body.hasClass("toggled");

		if (isToggled) {
			body.removeClass("toggled");
			$(".sidebar-wrapper").off("mouseenter mouseleave");
		} else {
			body.addClass("toggled");

			$(".sidebar-wrapper")
				.on("mouseenter", function () {
					body.addClass("sidebar-hovered");
				})
				.on("mouseleave", function () {
					body.removeClass("sidebar-hovered");
				});
		}
	});

	$(".sidebar-close").on("click", function (e) {
		e.preventDefault();
		$("body").removeClass("toggled");
	});

	$(".overlay").on("click", function () {
		$("body").removeClass("toggled");
	});

	function handleResponsive() {
		const width = $(window).width();
		if (width < 768) {
			$("body").addClass("toggled");
		}
	}

	handleResponsive();
	$(window).on("resize", handleResponsive);
});
