<?php
defined('BASEPATH') or exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/userguide3/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'Home/dashboard';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;
$route['testfirebase'] = 'TestFirebase/index';


$route['login']   = 'AuthenticationController/login';
$route['signup']  = 'AuthenticationController/signup';
$route['logout']  = 'AuthenticationController/logout';

// Agar tum login aur signup ke POST handle alag rakhna chahte ho:
$route['loginUser']  = 'AuthenticationController/loginUser';
$route['storeUser']  = 'AuthenticationController/storeUser';
//
// Authentication routes
// $route['login']['get']             = 'AuthenticationController/login';

// $route['login']['post']             = 'AuthenticationController/loginUser';
// $route['signup']['get']              = 'AuthenticationController/signup';
// $route['signup']['post']            = 'AuthenticationController/storeUser';
// $route['logout'] = 'AuthenticationController/logout';
$route['user-profile']['get']       = 'UserController/getUser';
$route['dashboard/coach-profile']['get'] = 'AuthenticationController/userProfile';

// Dashboard routes
$route['dashboard']['get']          = 'Home/dashboard';
$route['dashboard/workout-plans']['get'] = 'MyVideoController/index';
$route['dashboard/chats']['get']    = 'ChatController/index';
$route['dashboard/trainee']['get']  = 'TraineeController/index';
$route['dashboard/trainee/detail/(:any)']['get'] = 'TraineeController/getUserData/$1';
$route['dashboard/add-workput-plan']['get'] = 'WorkoutController/index';
$route['dashboard/subscription']['get']  = 'SubscriptionController/index';
$route['dashboard/library']['get']  = 'WorkoutController/library';
$route['workout/libraryDetail/(:any)']['get'] = 'WorkoutController/libraryDetail/$1';

// Workout routes
$route['myvideos'] = 'MyVideoController/index';
$route['workout/submit']['post']         = 'WorkoutController/addWorkoutPlan';
$route['workout/all']['get']             = 'WorkoutController/getAllWorkoutPlans';
$route['workout/subworkout/(:any)']['get'] = 'WorkoutController/detailWorkout/$1';
//
$route['workout/getPlan/(:any)'] = 'WorkoutController/getPlan/$1';
$route['workout/update/(:any)']['post'] = 'WorkoutController/update/$1';
$route['workout/delete/(:any)']['post'] = 'WorkoutController/delete/$1';
$route['workout/addSubWorkout'] = 'WorkoutController/addSubWorkout';
$route['workout/updateSubWorkout'] = 'WorkoutController/updateSubWorkout';
$route['workout/deleteSubWorkout/(:any)/(:any)']['post'] = 'WorkoutController/deleteSubWorkout/$1/$2';


// Invitations
$route['invite/send']['post'] = 'InvitationController/sendInvite';
$route['invite/accept'] = 'InvitationController/acceptInvite';


// Chat routes
$route['chat/testInsertChat']['get']     = 'ChatController/testInsertChat';
$route['message/send/(:any)']['get']     = 'ChatController/send/$1';
$route['chat/getAllChats/(:any)']['get'] = 'ChatController/getAllChats/$1';
$route['send-message-to-coach']['get']   = 'ChatController/sendMessageToCoach';
