<?php
defined('BASEPATH') or exit('No direct script access allowed');

class ChatController extends CI_Controller
{
    protected $firestore;

    public function __construct()
    {
        parent::__construct();

        // Load Firebase library (jo aapne CI3 ke liye banayi hogi)
        $this->load->library('firebase');
        $this->firestore = $this->firebase->getFirestore();
        $this->load->library('session');
    }

    public function sendMessageToCoach()
    {
        $firestore = $this->firestore;

        $coachId = '98fe1211e33e49e6a92a'; // Receiver
        $userId  = 'ORzf7Rn0ivZFKAWxoXMtebGmW7n1'; // Sender
        $messageContent = 'hello coach.';

        try {
            $chatsQuery = $firestore->collection('Chats')
                ->where("participants.$coachId", '==', true)
                ->where("participants.$userId", '==', true)
                ->documents();

            if ($chatsQuery->isEmpty()) {
                $chatData = [
                    'participants' => [
                        $coachId => true,
                        $userId  => true
                    ],
                    'lastMessage' => null,
                    'createdAt'   => round(microtime(true) * 1000)
                ];
                $chatRef = $firestore->collection('Chats')->add($chatData);
                $chatId  = $chatRef->id();
            } else {
                $chatDoc = $chatsQuery->rows()[0];
                $chatId  = $chatDoc->id();
            }

            $timestampMs = round(microtime(true) * 1000);

            $message = [
                'content'   => $messageContent,
                'fromID'    => $userId,
                'toID'      => $coachId,
                'isRead'    => false,
                'type'      => 'text',
                'timestamp' => $timestampMs
            ];

            $messageRef = $firestore->collection('Chats')
                ->document($chatId)
                ->collection('Conversations')
                ->add($message);

            $messageId = $messageRef->id();
            $messageRef->update([['path' => 'messageId', 'value' => $messageId]]);
            $message['messageId'] = $messageId;

            $firestore->collection('Chats')
                ->document($chatId)
                ->update([['path' => 'lastMessage', 'value' => $message]]);

            echo "✅ Message sent to coach successfully in Chat ID: $chatId\n";
        } catch (Throwable $e) {
            echo "❌ Error sending message: " . $e->getMessage();
        }
    }

    public function testInsertChat()
    {
        $firestore = $this->firestore;
        $coachId = 'c777c59f230b48debe28';
        $userId  = '07xMEsN3SKfppmN8yUpfiwUUiXA3';

        try {
            $chatsQuery = $firestore->collection('Chats')
                ->where("participants.$coachId", '==', true)
                ->where("participants.$userId", '==', true)
                ->documents();

            if ($chatsQuery->isEmpty()) {
                echo "❌ No chat found. Creating one...\n";

                $chatData = [
                    'participants' => [
                        $coachId => true,
                        $userId  => true
                    ],
                    'lastMessage' => null,
                    'createdAt'   => time()
                ];
                $chatRef = $firestore->collection('Chats')->add($chatData);
                $chatId  = $chatRef->id();

                $message = [
                    'content'   => '🧪 Hello! This is a test message.',
                    'fromID'    => $coachId,
                    'toID'      => $userId,
                    'isRead'    => false,
                    'type'      => 'text',
                    'timestamp' => time()
                ];

                $messageRef = $firestore->collection('Chats')
                    ->document($chatId)
                    ->collection('Conversations')
                    ->add($message);

                $messageId = $messageRef->id();
                $messageRef->update([['path' => 'messageId', 'value' => $messageId]]);
                $message['messageId'] = $messageId;

                $firestore->collection('Chats')
                    ->document($chatId)
                    ->update([['path' => 'lastMessage', 'value' => $message]]);

                echo "✅ New chat created with ID: $chatId\n";
            } else {
                echo "📡 Found existing chat:\n";
                foreach ($chatsQuery as $chatDoc) {
                    $chatId   = $chatDoc->id();
                    $chatData = $chatDoc->data();
                    echo "<pre>" . print_r($chatData, true) . "</pre>";
                }
            }
        } catch (Throwable $e) {
            echo "❌ Error: " . $e->getMessage();
        }
    }

    public function getAllChats($coachId)
    {
        $firestore = $this->firestore;

        try {
            $chatsQuery = $firestore->collection('Chats')
                ->where('participants.' . $coachId, '==', true)
                ->documents();

            if ($chatsQuery->isEmpty()) {
                echo "❌ No chats found for Coach ID: $coachId";
                return;
            }

            echo "<h3>🗂 All Chats for Coach ID: $coachId</h3>";

            foreach ($chatsQuery as $chatDoc) {
                $chatId = $chatDoc->id();
                $chatData = $chatDoc->data();

                echo "<hr><b>💬 Chat ID:</b> {$chatId}<br>";
                echo "<pre>" . print_r($chatData, true) . "</pre>";
            }
        } catch (Throwable $e) {
            echo "❌ Error: " . $e->getMessage();
        }
    }

    public function index()
    {
        $coachId = $this->session->userdata('user_doc_id');
        if (!$coachId) {
            redirect('login');
        }
        $this->load->view('pages/chats', ['coachId' => $coachId]);
    }

    public function send($userId)
    {
        $coachId = $this->session->userdata('user_doc_id');
        if (!$coachId) {
            redirect('login');
        }

        $chatId = $this->getOrCreateChat($coachId, $userId);

        $this->load->view('chat/chats', [
            'chatId'  => $chatId,
            'coachId' => $coachId,
            'userId'  => $userId,
        ]);
    }

    private function getOrCreateChat($coachId, $userId)
    {
        $chatsRef = $this->firestore->collection('Chats');
        $query = $chatsRef
            ->where("participants.$coachId", '==', true)
            ->where("participants.$userId", '==', true)
            ->documents();

        foreach ($query as $doc) {
            return $doc->id(); // Chat exists
        }

        $chatRef = $chatsRef->add([
            'participants' => [
                $coachId => true,
                $userId  => true
            ],
            'lastMessage' => '',
            'createdAt'   => time()
        ]);

        return $chatRef->id();
    }
}
