<?php
defined('BASEPATH') or exit('No direct script access allowed');

class InvitationController extends CI_Controller
{
    // protected $firebase;
    // protected $emailService;
    protected $secret;
    protected $expireSeconds;

    public function __construct()
    {
        parent::__construct();

        // Load Firebase library (you must have application/libraries/Firebase.php)
        $this->load->library('firebase');
        $this->load->library('session');


        // Load Email service (you must create application/libraries/EmailService.php)
        $this->load->library('EmailService');

        // $this->firebase = $this->firebase;
        // $this->emailService = $this->emailservice;

        $this->secret = getenv('INVITE_SECRET') ?: 'default_secret';
        $this->expireSeconds = 172800; // 2 days
    }

    public function sendInvite()
    {
        // $coachId = $this->session->userdata('user_doc_id');
        $coachId = $this->session->userdata('user_doc_id');

        $email   = strtolower(trim($this->input->post('user_email')));
        $plan_id = $this->input->post('plan_id');

        if (!$email) {
            return $this->output
                ->set_status_header(200)
                ->set_content_type('application/json')
                ->set_output(json_encode([
                    'status'  => 'error',
                    'message' => 'Email is required.'
                ]));
        }

        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            return $this->output
                ->set_status_header(200)
                ->set_content_type('application/json')
                ->set_output(json_encode([
                    'status'  => 'error',
                    'message' => 'Invalid email format.'
                ]));
        }

        try {
            $firestore = $this->firebase->getFirestore();
            $ts        = time();
            $now       = round(microtime(true) * 1000);

            $payload = $coachId . '|' . $email . '|' . $ts;
            $sig     = hash_hmac('sha256', $payload, $this->secret);

            // 🔍 Check if user exists
            $userDocs = $firestore->collection('Users')
                ->where('email', '=', $email)
                ->limit(1)
                ->documents();

            $userId = null;
            foreach ($userDocs as $doc) {
                $userId = $doc->id();
                $userData = $doc->data();
                if (isset($userData['userRole']) && $userData['userRole'] !== 'user') {
                    return $this->output
                        ->set_status_header(200)
                        ->set_content_type('application/json')
                        ->set_output(json_encode([
                            'status'  => 'error',
                            'message' => 'Only users can be invited.'
                        ]));
                }
            }

            // Save invite
            $orderData = [
                'coachId'   => $coachId,
                'userEmail' => $email,
                'status'    => 'pending',
                'createdAt' => $now,
                'updatedAt' => null,
                'workoutPlanId' => $plan_id,
                'ts'        => $ts,
                'sig'       => $sig,
            ];

            if ($userId) {
                $orderData['userId'] = $userId;
            }

            $docRef   = $firestore->collection('Orders')->add($orderData);

            $orderId = $docRef->id();

            // Build invite link
            $orderUrl = base_url("invite/accept?orderId={$orderId}");

            // Send email
            $ddd = $this->emailservice->sendInviteEmail($email, $orderUrl);
            // print_r($email);
            // print_r($orderUrl);
            // print_r($ddd);
            // exit;


            return $this->output
                ->set_status_header(200)
                ->set_content_type('application/json')
                ->set_output(json_encode([
                    'status'  => 'success',
                    'message' => 'Invite sent successfully.'
                ]));
        } catch (Throwable $e) {
            log_message('error', 'Firestore Invite Error: ' . $e->getMessage());

            return $this->output
                ->set_status_header(500)
                ->set_content_type('application/json')
                ->set_output(json_encode([
                    'status'  => 'error',
                    'message' => 'Internal server error.'
                ]));
        }
    }

    public function acceptInvite()
    {
        $orderId = $this->input->get('orderId');
        redirect('https://play.google.com/store/apps/details?id=com.noteapp.memycoach');
    }
}
