<?php
defined('BASEPATH') or exit('No direct script access allowed');

class TraineeController extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();

        // Firebase library load
        $this->load->library('firebase');

        // UserModel load
        $this->load->model('UserModel', 'userModel');
    }

    public function index()
    {
        $affiliatedUsers = $this->userModel->getAffiliatedUsers();



        $this->load->view('pages/trainee', [
            'trainees' => $affiliatedUsers,
        ]);
    }

    public function getUserData($id)
    {
        $trainee = $this->userModel->getUserData($id);
        $trainee['image'] = '';

        $coachId = $this->session->userdata('user_doc_id');
        if (!$coachId) {
            redirect('login');
        }

        if (!$trainee) {
            $this->session->set_flashdata('error', 'Trainee not found.');
            redirect($_SERVER['HTTP_REFERER']);
        }

        $this->load->view('pages/trainee_details', [
            'trainee' => $trainee,
            'coachId' => $coachId,
        ]);
    }
}
