<?php
defined('BASEPATH') or exit('No direct script access allowed');

class UserModel extends CI_Model
{
    public function __construct()
    {
        parent::__construct();

        // Firebase library load
        $this->load->library('firebase');
        $this->load->library('session');  // 👈 yeh add karo

        $this->firestore = $this->firebase->getFirestore();

        // Cache service agar CI3 me use karna ho to CI cache driver load karo
        $this->load->driver('cache', ['adapter' => 'file']);
    }

    public function getCoach()
    {
        $cacheKey  = 'coach_data';
        $cacheTime = 600;

        // Try cache first
        $coachData = $this->cache->file->get($cacheKey);
        if ($coachData !== FALSE) {
            return $coachData;
        }

        // Get UID from session
        $uid = $this->session->userdata('user_doc_id');

        if (!$uid) {
            log_message('error', 'UID not found in session.');
            return null;
        }

        try {
            // Fetch from Firestore
            $coachDoc = $this->firestore->collection('Users')->document($uid)->snapshot();

            if (!$coachDoc->exists()) {
                log_message('error', "Firestore document for UID {$uid} does not exist.");
                return null;
            }

            $coachData = $coachDoc->data();

            // Save in cache
            $this->cache->file->save($cacheKey, $coachData, $cacheTime);

            return $coachData;
        } catch (Exception $e) {
            log_message('error', 'Firestore getCoach error: ' . $e->getMessage());
            return null;
        }
    }

    public function getAffiliatedUsers()
    {
        $uid = trim($this->session->userdata('user_doc_id'));
        if (!$uid) {
            log_message('error', 'UID not found in session.');
            return [];
        }

        try {
            $snapshot = $this->firestore
                ->collection('Users')
                ->where('userRole', '=', 'user')
                ->where('affiliatedWith', 'array-contains', $uid)
                ->documents();



            $users = [];
            foreach ($snapshot as $doc) {
                if ($doc->exists()) {
                    $data = $doc->data();
                    $users[] = [
                        'id'           => $doc->id(),
                        'userName'     => $data['userName'] ?? '',
                        'isSubscribed' => $data['isSubscribed'] ?? false,
                        'image'        => $data['image'] ?? base_url('dashboard-assets/images/avatars/11.png'),
                    ];
                }
            }

            log_message('debug', 'Affiliated UID: ' . $uid);
            log_message('debug', 'Fetched ' . count($users) . ' affiliated users.');
            return $users;
        } catch (Throwable $e) {
            log_message('error', 'Firestore getAffiliatedUsers error: ' . $e->getMessage());
            return [];
        }
    }

    public function getUserData($id)
    {
        try {
            $doc = $this->firestore->collection('Users')->document($id)->snapshot();

            if (!$doc->exists()) {
                return null;
            }

            $data = $doc->data();
            unset($data['password'], $data['token']);
            $data['id'] = $doc->id();

            return $data;
        } catch (Throwable $e) {
            log_message('error', 'Error fetching trainee: ' . $e->getMessage());
            return null;
        }
    }
}
