<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Dentifyed</title>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="<?= base_url('assets/css/style.css') ?>" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" />
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>

<body class="bgPrimary">
    <div class="container min-h-100vh d-flex flex-column justify-content-center">
        <div class="row justify-content-center py-4">
            <div class="col-md-6">

                <img class="d-block mx-auto mb-5" src="<?= base_url('assets/images/logo.png') ?>"
                    alt="Dentifyed Logo" />

                <div class="my-2">
                    <div class="card">
                        <div class="card-body">
                            <form id="loginForm" method="post">
                                <?php if ($this->security->get_csrf_token_name()): ?>
                                <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>"
                                    value="<?= $this->security->get_csrf_hash(); ?>" />
                                <?php endif; ?>

                                <div class="mb-4">
                                    <div class="input-group">
                                        <input class="form-control" type="email" name="email" id="email"
                                            placeholder="example@gmail.com" required />
                                        <span class="input-group-text bg-transparent"><i
                                                class="fas fa-envelope"></i></span>
                                    </div>
                                    <div id="emailError" class="text-danger mt-1 small"></div>
                                </div>

                                <div class="mb-4">
                                    <div class="input-group">
                                        <input class="form-control" type="password" name="password" id="password"
                                            placeholder="Password" required />
                                        <span class="input-group-text bg-transparent eye-toggle">
                                            <i class="eye fas fa-eye"></i>
                                        </span>
                                    </div>
                                    <div id="passwordError" class="text-danger mt-1 small"></div>
                                </div>

                                <div class="row justify-content-center">
                                    <div class="col-md-6">
                                        <button type="submit" class="btn btnSub py-2 w-100">
                                            <span id="loginText">Login</span>
                                            <span id="loginSpinner" class="spinner-border spinner-border-sm d-none"
                                                role="status"></span>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <p class="fs1">
                    Don't have an account?
                    <a href="<?= site_url('signup') ?>" class="fs2">Get Started</a>
                </p>
            </div>
        </div>
    </div>

    <script>
    $(document).ready(function() {
        // Password visibility toggle
        $(".eye-toggle").click(function() {
            const passwordField = $("#password");
            const eyeIcon = $(this).find("i");

            if (passwordField.attr("type") === "password") {
                passwordField.attr("type", "text");
                eyeIcon.removeClass("fa-eye").addClass("fa-eye-slash");
            } else {
                passwordField.attr("type", "password");
                eyeIcon.removeClass("fa-eye-slash").addClass("fa-eye");
            }
        });

        // AJAX login
        $("#loginForm").on("submit", function(e) {
            e.preventDefault();
            $("#emailError, #passwordError").text("");

            $("#loginText").text("Logging in...");
            $("#loginSpinner").removeClass("d-none");
            $("button[type='submit']").prop("disabled", true);

            $.ajax({
                url: "<?= site_url('loginUser') ?>",
                type: "POST",
                data: $(this).serialize(),
                dataType: "json",
                success: function(response) {
                    if (response.status === "success") {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            timer: 1500,
                            showConfirmButton: false
                        }).then(() => {
                            window.location.href = response.redirect ||
                                "<?= site_url('dashboard') ?>";
                        });
                    } else if (response.errors) {
                        if (response.errors.email) $("#emailError").text(response.errors
                            .email);
                        if (response.errors.password) $("#passwordError").text(response
                            .errors.password);
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: response.message
                        });
                    }
                },
                error: function() {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Server error. Try again later.'
                    });
                },
                complete: function() {
                    $("#loginText").text("Login");
                    $("#loginSpinner").addClass("d-none");
                    $("button[type='submit']").prop("disabled", false);
                }
            });
        });
    });
    </script>
</body>

</html>