<?php
// Start output buffering
ob_start();
?>

<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2>Coach Profile</h2>
        <a href="<?= base_url('dashboard') ?>" class="btn btn-outline-secondary">← Back to Dashboard</a>
    </div>

    <div class="card shadow-sm p-4">
        <div class="row align-items-center">
            <div class="col-md-3 text-center">
                <img src="<?= htmlspecialchars(!empty($coach['image']) ? $coach['image'] : base_url('dashboard-assets/images/avatars/11.png')) ?>"
                    alt="Coach Image" class="img-fluid rounded-circle" width="140">
            </div>
            <div class="col-md-9">
                <h4><?= htmlspecialchars(!empty($coach['userName']) ? $coach['userName'] : 'Admin') ?></h4>

                <p><strong>Email:</strong> <?= htmlspecialchars(!empty($coach['email']) ? $coach['email'] : 'N/A') ?>
                </p>

                <p><strong>Latitude:</strong> <?= htmlspecialchars(!empty($coach['lat']) ? $coach['lat'] : '-') ?></p>
                <p><strong>Longitude:</strong> <?= htmlspecialchars(!empty($coach['lng']) ? $coach['lng'] : '-') ?></p>

                <div class="mt-4">
                    <a href="#" class="btn btn-dark">Edit Profile</a>
                    <a href="<?= base_url('logout') ?>" class="btn btn-outline-danger">Logout</a>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
// End buffering and capture content
$content = ob_get_clean();

// Load layout and pass content
$this->load->view('layouts/app', ['content' => $content]);
?>