<!doctype html>
<html lang="en" data-bs-theme="light">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Me & My Coach</title>
    <!--favicon-->
    <link rel="icon" href="<?= base_url('dashboard-assets/images/favicon-32x32.png') ?>" type="image/png">

    <!--plugins-->
    <link href="<?= base_url('dashboard-assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css') ?>"
        rel="stylesheet">
    <link rel="stylesheet" type="text/css"
        href="<?= base_url('dashboard-assets/plugins/metismenu/metisMenu.min.css') ?>">
    <link rel="stylesheet" type="text/css" href="<?= base_url('dashboard-assets/plugins/metismenu/mm-vertical.css') ?>">
    <link rel="stylesheet" type="text/css"
        href="<?= base_url('dashboard-assets/plugins/simplebar/css/simplebar.css') ?>">

    <!--bootstrap css-->
    <link href="<?= base_url('dashboard-assets/css/bootstrap.min.css') ?>" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans:wght@300;400;500;600&amp;display=swap"
        rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Material+Icons+Outlined" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">

    <!--main css-->
    <link href="<?= base_url('dashboard-assets/css/bootstrap-extended.css') ?>" rel="stylesheet">
    <link href="<?= base_url('dashboard-assets/sass/main.css') ?>" rel="stylesheet">
    <link href="<?= base_url('dashboard-assets/sass/dark-theme.css') ?>" rel="stylesheet">
    <link href="<?= base_url('dashboard-assets/sass/semi-dark.css') ?>" rel="stylesheet">
    <link href="<?= base_url('dashboard-assets/sass/bordered-theme.css') ?>" rel="stylesheet">
    <link href="<?= base_url('dashboard-assets/sass/responsive.css') ?>" rel="stylesheet">

    <!-- SweetAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <!-- jsCalendar -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/simple-jscalendar@1.4.5/source/jsCalendar.min.css" />
</head>

<body>

    <!-- Load header and sidebar -->
    <?php $this->load->view('layouts/header'); ?>
    <?php $this->load->view('layouts/sidebar'); ?>

    <!--start main wrapper-->
    <main class="main-wrapper">
        <div class="main-content">
            <?php if (!empty($content)) echo $content; ?>
        </div>
    </main>
    <!--end main wrapper-->

    <!--start overlay-->
    <div class="overlay btn-toggle"></div>
    <!--end overlay-->

    <!-- ================== JS - CORRECT ORDER ================== -->

    <!-- 1. jQuery MUST load FIRST -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

    <!-- 2. Bootstrap bundle -->
    <script src="<?= base_url('dashboard-assets/js/bootstrap.bundle.min.js') ?>"></script>

    <!-- 3. Plugins that depend on jQuery -->
    <script src="<?= base_url('dashboard-assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js') ?>"></script>
    <script src="<?= base_url('dashboard-assets/plugins/metismenu/metisMenu.min.js') ?>"></script>
    <script src="<?= base_url('dashboard-assets/plugins/simplebar/js/simplebar.min.js') ?>"></script>

    <!-- 4. Main scripts AFTER jQuery and plugins -->
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    <script src="<?= base_url('dashboard-assets/js/main.js') ?>"></script>
    <script src="<?= base_url('dashboard-assets/js/index2.js') ?>"></script>

    <!-- 5. jsCalendar -->
    <script src="https://cdn.jsdelivr.net/npm/simple-jscalendar@1.4.5/source/jsCalendar.min.js"></script>

    <!-- 6. Calendar initialization -->
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            if (document.getElementById("my-calendar")) {
                const calendar = jsCalendar.new("#my-calendar");
                calendar.onDateClick(function(event, date) {
                    alert("You clicked on " + date.toDateString());
                });
            }
        });
    </script>
    <script src="<?= base_url('dashboard-assets/js/toggle-fix.js') ?>"></script>

    <script>
        $(document).ready(function() {
            $('.btn-toggle').off('click');
            $('.sidebar-close').off('click');
            $('.overlay').off('click');

            // Reinitialize toggle functionality
            $('.btn-toggle').on('click', function(e) {
                e.preventDefault();

                const body = $('body');
                const isToggled = body.hasClass('toggled');


                if (isToggled) {
                    body.removeClass('toggled');
                    $('.sidebar-wrapper').off('mouseenter mouseleave');
                } else {
                    body.addClass('toggled');

                    // Add hover functionality for collapsed sidebar
                    $('.sidebar-wrapper').on('mouseenter', function() {
                        body.addClass('sidebar-hovered');
                    }).on('mouseleave', function() {
                        body.removeClass('sidebar-hovered');
                    });
                }
            });

            // Close button functionality
            $('.sidebar-close').on('click', function(e) {
                e.preventDefault();
                $('body').removeClass('toggled');
            });

            // Overlay click to close
            $('.overlay').on('click', function() {
                $('body').removeClass('toggled');
            });


            // Mobile responsiveness
            function handleResponsive() {
                const width = $(window).width();

                if (width < 768) {
                    // MOBILE: sidebar should be closed
                    $('body').removeClass('toggled');
                } else {
                    // DESKTOP: keep default behavior
                    $('body').removeClass('sidebar-hovered');
                }
            }

            handleResponsive();
            $(window).on('resize', handleResponsive);

        });
    </script>


</body>

</html>
