<?php
defined('BASEPATH') or exit('No direct script access allowed');

use Google\Cloud\Firestore\FieldValue;
use Google\Cloud\Core\Timestamp;
use DateTime;

class Product extends CI_Controller
{

  function __construct()
  {
    parent::__construct();
    // $this->load->database();
    $this->load->helper('url');
    $this->load->library('session');
    $this->load->model('dashboard_model');
    $this->load->model('common');
  }

  public function settings()
  {
    $data["settings"] = $this->common->readdatafromcollectionbetween("Settings");


    $this->template->template_render('settings', $data);
  }
  public function saveSettings($id)
  {
    $post = $this->input->post();
    $response = $this->common->updatedatamodel("Settings", $id, $post);
    if ($response) {
      $this->session->set_flashdata('successmessage', 'Settings has been updated');
    } else {
      $this->session->set_flashdata('warningmessage', 'Error! Some issue with firebase.Please try again');
    }

    redirect(base_url('dashboard/settings'));
  }



  public function index()
  {
      $this->load->library('session');
      $sessionData = $this->session->userdata('session_data');
  
      if (!$sessionData || !isset($sessionData['userId'])) {
          redirect(base_url('login'));
      }
  
      try {
          $firebase = $this->firebase->init();
          $db = $firebase->createFirestore()->database();
  
          // Fetch products for current user
          $productsQuery = $db->collection('TailerServices')
              ->where('tailorId', '==', $sessionData['userId'])
              ->documents();
  
          // Fetch all categories
          $categories = $db->collection('Categories')->documents();
          $categoryMap = [];
          foreach ($categories as $cat) {
              $categoryMap[$cat->id()] = $cat->data()['name'] ?? 'Uncategorized';
          }
  
          // Process products data
          $products = [];
          foreach ($productsQuery as $doc) {
              $product = $doc->data();
              $products[] = [
                  'id' => $doc->id(),
                  'image' => $product['image'] ?? '',
                  'serviceName' => $product['serviceName'] ?? '',
                  'category' => $categoryMap[$product['categoryId']] ?? 'Unknown',
                  'date' => isset($product['date']) ? date('d M Y', $product['date'] / 1000) : 'N/A',
                  'shopLocation' => $product['shopLocation'] ?? '',
                  'price' => isset($product['price']) ? 'AED ' . number_format($product['price'], 2) : 'AED 0.00'
              ];
          }
  
          $data = [
              'userdetails' => $sessionData,
              'products' => $products
          ];
  
          $this->template->template_render('catalouge', $data);
  
      } catch (Exception $e) {
          $this->session->set_flashdata('warningmessage', 'Error loading catalogue: ' . $e->getMessage());
          redirect(base_url('dashboard'));
      }
  }

  public function addProduct()
  {
    $this->load->library('session');
    $sessionData = $this->session->userdata('session_data');

    if (!$sessionData || !isset($sessionData['userId'])) {
      redirect(base_url('login'));
    }

    try {
      $firebase = $this->firebase->init();
      $firestore = $firebase->createFirestore();
      $db = $firestore->database();

      // Fetch categories
      $categories = $db->collection('Categories')->documents();
      $categoryList = [];
      foreach ($categories as $category) {
        $categoryList[] = [
          'id' => $category->id(),
          'name' => $category->data()['name'] ?? 'Unnamed Category'
        ];
      }

      $data = [
        'userdetails' => $sessionData,
        'categories' => $categoryList
      ];

      $this->template->template_render('addproduct', $data);
    } catch (Exception $e) {
      $this->session->set_flashdata('warningmessage', 'Error loading form: ' . $e->getMessage());
      redirect(base_url('dashboard'));
    }
  }

  public function saveProduct()
  {
      $this->load->library('session');
      header('Content-Type: application/json');
  
      $sessionData = $this->session->userdata('session_data');
      if (!$sessionData || !isset($sessionData['userId'])) {
          echo json_encode(['success' => false, 'message' => 'User not authenticated.']);
          return;
      }
  
      try {
          $firebase = $this->firebase->init();
          $firestore = $firebase->createFirestore();
          $storage = $firebase->createStorage();
          $db = $firestore->database();
          $defaultBucket = $storage->getBucket();
  
          $userId = $sessionData['userId'];
          $imageUrl = '';
  
          // **?? Upload image to Firebase Storage inside "Products/{userId}/" folder**
          if (!empty($_FILES['product_image']['name'])) {
              try {
                  // Generate unique file path
                  $file_name = 'Products/' . $userId . '/' . uniqid() . '_' . $_FILES['product_image']['name'];
  
                  // Upload to Firebase Storage
                  $uploadedFile = $defaultBucket->upload(
                      file_get_contents($_FILES['product_image']['tmp_name']),
                      ['name' => $file_name, 'predefinedAcl' => 'publicRead']
                  );
  
                  if ($uploadedFile) {
                      $imageUrl = 'https://storage.googleapis.com/' . $defaultBucket->name() . '/' . $file_name;
                  }
              } catch (Exception $e) {
                  echo json_encode(['success' => false, 'message' => 'Image upload failed: ' . $e->getMessage()]);
                  return;
              }
          }
  
          // Generate unique Firestore document ID
          $docRef = $db->collection('TailerServices')->newDocument();
          $documentId = $docRef->id();
  
          $milliseconds = (int) (microtime(true) * 1000);
  
          // **Prepare product data**
          $productData = [
              'id' => $documentId,
              'serviceName' => $this->input->post('service_name'),
              'categoryId' => $this->input->post('category_id'),
              'detail' => $this->input->post('detail'),
              'price' => (float)$this->input->post('price'),
              'amount' => (float)$this->input->post('price'),
              'shopLocation' => $this->input->post('shop_location'),
              'image' => $imageUrl,  // **?? Stores Firebase image URL**
              'tailorId' => $userId,
              'date' => $milliseconds,
          ];
  
          // **Save product data in Firestore**
          $docRef->set($productData);
  
          echo json_encode([
              'success' => true,
              'message' => 'Product added successfully!',
              'redirect' => base_url('product') // Redirect URL
          ]);
      } catch (Exception $e) {
          echo json_encode(['success' => false, 'message' => 'Error saving product: ' . $e->getMessage()]);
      }
  }
  

  // public function orders()
  // {
  //     $this->load->library('session');
  //     $sessionData = $this->session->userdata('session_data');
  
  //     if (!$sessionData || !isset($sessionData['userId'])) {
  //         redirect(base_url('login'));
  //     }
  
  //     try {
  //         $firebase = $this->firebase->init();
  //         $db = $firebase->createFirestore()->database();

  //         $processedQuery = $db->collection('Orders')
  //             ->where('vendorId', '==', $sessionData['userId'])
  //             ->where('orderStatus', '==', 'processed')
  //             ->documents();
  
  //         $processQuery = $db->collection('Orders')
  //             ->where('vendorId', '==', $sessionData['userId'])
  //             ->where('orderStatus', '==', 'process')
  //             ->documents();
  
  //         // Merge and process results
  //         $orders = [];
  //         $orderNumber = 1;
          
  //         foreach ($processedQuery as $doc) {
  //             $orders[] = $this->processOrder($doc, $orderNumber++);
  //         }
          
  //         foreach ($processQuery as $doc) {
  //             $orders[] = $this->processOrder($doc, $orderNumber++);
  //         }
  
  //         $data = [
  //             'userdetails' => $sessionData,
  //             'orders' => $orders
  //         ];
  
  //         $this->template->template_render('orders', $data);
  
  //     } catch (Exception $e) {
  //         $this->session->set_flashdata('warningmessage', 'Error loading orders: ' . $e->getMessage());
  //         redirect(base_url('dashboard'));
  //     }
  // }
  
  // private function processOrder($doc, $orderNumber)
  // {
  //     $orderData = $doc->data();
  //     return [
  //         'orderId' => $doc->id(),
  //         'orderNumber' => 'Order #' . $orderNumber,
  //         // 'image' => $orderData['items'][0]['image'] ?? base_url('assets/images/su1.png'),
  //         // 'date' => isset($orderData['timestamp']) ? date('M d, Y', $orderData['timestamp']->get()->getTimestamp()) : 'N/A',
  //         // 'status' => $orderData['orderStatus'],
  //         // 'price' => isset($orderData['totalAmount']) ? 'AED ' . number_format($orderData['totalAmount'], 2) : 'AED 0.00'
  //     ];
  // }

  public function orders()
{
    // $this->load->library('session');
    // $sessionData = $this->session->userdata('session_data');

    // if (!$sessionData || !isset($sessionData['userId'])) {
    //     redirect(base_url('login'));
    // }

    $orders = $this->common->readdatafromcollectionbetween("Orders");
    $allOrders = array();

    foreach($orders as $key => $order){
        $allOrders[$key] = $order;
        $userId = $order['userId'];
        $user = $this->common->readdatadocument("Users", $userId);
        $allOrders[$key]['user'] = $user['firstName'] ." ". $user['lastName'];
    }
    // var_dump($allOrders);die;
    $data["orders"] = $allOrders;
    $this->template->template_render('orders', $data);
}

private function processOrder($doc, $orderNumber)
{
    $orderData = $doc->data();
    return [
        'orderId' => $doc->id(),
        'orderNumber' => 'Order #' . $orderNumber,
        'image' => $orderData['productsData'][0]['image'] ?? base_url('assets/images/su1.png'),
        'date' => isset($orderData['date']) ? date('M d, Y', $orderData['date'] / 1000) : 'N/A',
        'status' => $orderData['orderStatus'],
        'price' => isset($orderData['price']) ? 'AED ' . number_format($orderData['price'], 2) : 'AED 0.00',
        'address' => implode(', ', array_filter([
            $orderData['address']['streetAddress1'] ?? '',
            $orderData['address']['city'] ?? '',
            $orderData['address']['state'] ?? ''
        ]))
    ];
}

  


  public function orderDetails($orderId)
  {
      try {
          $firebase = $this->firebase->init();
          $db = $firebase->createFirestore()->database();
          $orderRef = $db->collection('Orders')->document($orderId);
          $orderDoc = $orderRef->snapshot();
          
          if (!$orderDoc->exists()) {
              throw new Exception('Order not found');
          }
  
          $orderData = $orderDoc->data();
          
          // Process address information
          $address = $orderData['address'] ?? [];
          $addressString = implode(', ', array_filter([
              $address['streetAddress1'] ?? '',
              $address['streetAddress2'] ?? '',
              $address['city'] ?? '',
              $address['state'] ?? '',
              $address['country'] ?? ''
          ]));
  
          // Process products data
          $products = [];
          $totalQuantity = 0;
          $subTotal = 0;
          
          foreach ($orderData['productsData'] ?? [] as $product) {
              $products[] = [
                  'image' => $product['image'] ?? '',
                  'name' => $product['serviceName'] ?? 'Unnamed Product',
                  'price' => number_format($product['price'] ?? 0, 2),
                  'quantity' => $product['amount'] ?? 0,
                  'total' => number_format(($product['price'] ?? 0) * ($product['amount'] ?? 0), 2)
              ];
              $totalQuantity += $product['amount'] ?? 0;
              $subTotal += ($product['price'] ?? 0) * ($product['amount'] ?? 0);
          }
  
          // Process timeline
          $timeline = [];
          foreach ($orderData['track'] ?? [] as $event) {
              $timeline[] = [
                  'date' => date('M d, Y h:i A', $event['date'] / 1000),
                  'event' => $event['name'] ?? 'Unknown Event'
              ];
          }
  
          // Get delivery date
          $deliveryDate = isset($orderData['deliveryDate']) 
              ? date('Y-m-d', strtotime($orderData['deliveryDate']))
              : null;
  
          $data = [
              'order' => [
                  'id' => $orderId,
                  'status' => $orderData['orderStatus'] ?? 'Unknown',
                  'orderDate' => date('M d, Y h:i A', $orderData['date'] / 1000),
                  'deliveryDate' => $deliveryDate,
                  'address' => $addressString,
                  'paymentId' => $orderData['pm_id'] ?? 'N/A',
                  'products' => $products,
                  'timeline' => $timeline,
                  'subTotal' => number_format($subTotal, 2),
                  'total' => number_format($orderData['price'] ?? $subTotal, 2),
                  'totalQuantity' => $totalQuantity
              ]
          ];
  
          $this->template->template_render('order_details', $data);
  
      } catch (Exception $e) {
          $this->session->set_flashdata('warningmessage', 'Error: ' . $e->getMessage());
          redirect(base_url('product/orders'));
      }
  }

public function setDeliveryDate($orderId)
{
    header('Content-Type: application/json');
    
    try {
        $firebase = $this->firebase->init();
        $db = $firebase->createFirestore()->database();

        $deliveryDate = $this->input->post('delivery_date');
        $dateObject = new DateTime($deliveryDate);
        
        $updates = [
            ['path' => 'deliveryDate', 'value' => $dateObject->format('Y-m-d')],
            ['path' => 'track', 'value' => FieldValue::arrayUnion([
                [
                    'date' => new Timestamp(new DateTime()),
                    'event' => 'Delivery Date Set',
                    'userId' => $this->session->userdata('session_data')['userId']
                ]
            ])]
        ];

        $db->collection('Orders')->document($orderId)->update($updates);

        echo json_encode(['success' => true]);
        
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
    }
}

public function updateOrderStatus($orderId)
{
    header('Content-Type: application/json');

    try {
        $firebase = $this->firebase->init();
        $db = $firebase->createFirestore()->database();

        // Read input JSON
        $json = file_get_contents('php://input');
        $data = json_decode($json, true);

        if (!isset($data['status'])) {
            throw new Exception('Missing status in request body');
        }

        $newStatus = $data['status'];

        // Check if order exists
        $orderDoc = $db->collection('Orders')->document($orderId)->snapshot();
        if (!$orderDoc->exists()) {
            throw new Exception('Order not found');
        }

        // Debugging: Log Firestore Data
        error_log('Order Data: ' . print_r($orderDoc->data(), true));

        // Validate status change
        $validStatuses = ['process', 'processed', 'readyToDeliver', 'deliver'];
        if (!in_array($newStatus, $validStatuses)) {
            throw new Exception('Invalid status selected');
        }


        if ($newStatus === 'readyToDeliver' && empty($orderDoc->data()['deliveryDate'])) {
            throw new Exception('Delivery date must be set before marking as Ready To Deliver');
        }

        $milliseconds = (int) (microtime(true) * 1000);
        $db->collection('Orders')->document($orderId)->update([
            ['path' => 'orderStatus', 'value' => $newStatus],
            ['path' => 'track', 'value' => FieldValue::arrayUnion([
                [
                    'date' => $milliseconds,
                    'name' => 'Status Changed to ' . ucfirst($newStatus)    
                ]
            ])]
        ]);

        echo json_encode(['success' => true]);
    } catch (Exception $e) {
        error_log('Update Order Status Error: ' . $e->getMessage());

        echo json_encode([
            'success' => false,
            'message' => 'Error updating order: ' . $e->getMessage()
        ]);
    }
}



  public function size()
  {

    $sessionData = $this->session->userdata('session_data');


    $data['userdetails'] = $sessionData;

    $this->template->template_render('size', $data);
  }

  public function deleteOrder()
  {
    $id = $this->uri->segment(3);

    $response = $this->common->deletedatamodel('Orders', $id);

    if ($response) {
      $this->session->set_flashdata('successmessage', 'Order deleted successfully..');
    } else {
      $this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
    }

    redirect(base_url('product/orders'));
  }

  
}